// ACES IDT for FUJIFILM F-Log2C
// FUFJIFILM Corpration
// Version:1.00


float FLog2ToSceneLinearReflection(float x) {
    if (x > 0.100686685370811)
        return (pow(10,(x - 0.384316) / 0.245281) - 0.064829) / 5.555556;
    else
        return (x - 0.092864) / 8.799461;
}

void main
(   input varying float rIn,
    input varying float gIn,
    input varying float bIn,
    input varying float aIn,
    output varying float rOut,
    output varying float gOut,
    output varying float bOut,
    output varying float aOut)
{

    float r_lin = FLog2ToSceneLinearReflection(rIn);
    float g_lin = FLog2ToSceneLinearReflection(gIn);
    float b_lin = FLog2ToSceneLinearReflection(bIn);

    rOut = r_lin *  0.84075669532565 + g_lin *  0.04423586200772 + b_lin *  0.11500744266663;
    gOut = r_lin * -0.00051739528808 + g_lin *  1.01221071623543 + b_lin * -0.01169332094735;
    bOut = r_lin * -0.00817253004405 + g_lin * -0.00560807817457 + b_lin *  1.01378060821862;
    aOut = 1.0;

}
