#include "FujiSDK.h"
#include <dlfcn.h>
#include <iostream>
#include <unistd.h>


CFujiSDK::CFujiSDK( LIB_HANDLE hModule, LPCSTR pRelativePath )
{
	m_hModule = dlopen(pRelativePath, RTLD_LAZY);
}


CFujiSDK::~CFujiSDK(void)
{
	if (m_hModule != NULL)
	{
		dlclose(m_hModule);
		m_hModule = NULL;
	}
}


void CFujiSDK::LoadSDKLibrary()
{
	m_iErr = FUJI_SDK_ERR_OK;

	if( NULL == m_hModule )
	{
		// ERROR
		m_iErr = FUJI_SDK_ERR_LOADSDK;
	} 
	else 
	{
		m_pfnInit                      = (_XSDK_Init                      )dlsym( m_hModule, "XSDK_Init" );
		m_pfnExit                      = (_XSDK_Exit                      )dlsym( m_hModule, "XSDK_Exit" );
		m_pfnDetect                    = (_XSDK_Detect                    )dlsym( m_hModule, "XSDK_Detect");
		m_pfnAppend                    = (_XSDK_Append                    )dlsym( m_hModule, "XSDK_Append");
		m_pfnOpenEx                    = (_XSDK_OpenEx                    )dlsym( m_hModule, "XSDK_OpenEx");
		m_pfnClose                     = (_XSDK_Close                     )dlsym( m_hModule, "XSDK_Close" );
		m_pfnPowerOFF                  = (_XSDK_PowerOFF                  )dlsym( m_hModule, "XSDK_PowerOFF" );
		m_pfnGetErrorNumber            = (_XSDK_GetErrorNumber            )dlsym( m_hModule, "XSDK_GetErrorNumber" );
		m_pfnGetVersionString          = (_XSDK_GetVersionString          )dlsym( m_hModule, "XSDK_GetVersionString" );
		m_pfnGetErrorDetails           = (_XSDK_GetErrorDetails           )dlsym( m_hModule, "XSDK_GetErrorDetails" );
		m_pfnGetDeviceInfo             = (_XSDK_GetDeviceInfo             )dlsym( m_hModule, "XSDK_GetDeviceInfo" );
		m_pfnWriteDeviceName           = (_XSDK_WriteDeviceName           )dlsym( m_hModule, "XSDK_WriteDeviceName" );
		m_pfnGetFirmwareVersion        = (_XSDK_GetFirmwareVersion        )dlsym( m_hModule, "XSDK_GetFirmwareVersion" );
		m_pfnGetLensInfo               = (_XSDK_GetLensInfo               )dlsym( m_hModule, "XSDK_GetLensInfo" );
		m_pfnGetLensVersion            = (_XSDK_GetLensVersion            )dlsym( m_hModule, "XSDK_GetLensVersion" );
		m_pfnGetDeviceInfoEx           = (_XSDK_GetDeviceInfoEx           )dlsym( m_hModule, "XSDK_GetDeviceInfoEx" );
		m_pfnCapPriorityMode           = (_XSDK_CapPriorityMode           )dlsym( m_hModule, "XSDK_CapPriorityMode" );
		m_pfnSetPriorityMode           = (_XSDK_SetPriorityMode           )dlsym( m_hModule, "XSDK_SetPriorityMode" );
		m_pfnGetPriorityMode           = (_XSDK_GetPriorityMode           )dlsym( m_hModule, "XSDK_GetPriorityMode" );
		m_pfnCapRelease                = (_XSDK_CapRelease                )dlsym( m_hModule, "XSDK_CapRelease" );
		m_pfnRelease                   = (_XSDK_Release                   )dlsym( m_hModule, "XSDK_Release" );
		m_pfnGetReleaseStatus          = (_XSDK_GetReleaseStatus          )dlsym( m_hModule, "XSDK_GetReleaseStatus");
		m_pfnCapReleaseEx              = (_XSDK_CapReleaseEx              )dlsym( m_hModule, "XSDK_CapReleaseEx" );
		m_pfnReleaseEx                 = (_XSDK_ReleaseEx                 )dlsym( m_hModule, "XSDK_ReleaseEx" );
		m_pfnReadImageInfo             = (_XSDK_ReadImageInfo             )dlsym( m_hModule, "XSDK_ReadImageInfo" );
		m_pfnReadPreview               = (_XSDK_ReadPreview               )dlsym( m_hModule, "XSDK_ReadPreview" );
		m_pfnReadImage                 = (_XSDK_ReadImage                 )dlsym( m_hModule, "XSDK_ReadImage" );
		m_pfnDeleteImage               = (_XSDK_DeleteImage               )dlsym( m_hModule, "XSDK_DeleteImage" );
		m_pfnGetBufferCapacity         = (_XSDK_GetBufferCapacity         )dlsym( m_hModule, "XSDK_GetBufferCapacity" );
		m_pfnCapAEMode                 = (_XSDK_CapAEMode                 )dlsym( m_hModule, "XSDK_CapAEMode" );
		m_pfnSetAEMode                 = (_XSDK_SetAEMode                 )dlsym( m_hModule, "XSDK_SetAEMode" );
		m_pfnGetAEMode                 = (_XSDK_GetAEMode                 )dlsym( m_hModule, "XSDK_GetAEMode" );
		m_pfnCapShutterSpeed           = (_XSDK_CapShutterSpeed           )dlsym( m_hModule, "XSDK_CapShutterSpeed" );
		m_pfnSetShutterSpeed           = (_XSDK_SetShutterSpeed           )dlsym( m_hModule, "XSDK_SetShutterSpeed" );
		m_pfnGetShutterSpeed           = (_XSDK_GetShutterSpeed           )dlsym( m_hModule, "XSDK_GetShutterSpeed" );
		m_pfnCapExposureBias           = (_XSDK_CapExposureBias           )dlsym( m_hModule, "XSDK_CapExposureBias" );
		m_pfnSetExposureBias           = (_XSDK_SetExposureBias           )dlsym( m_hModule, "XSDK_SetExposureBias" );
		m_pfnGetExposureBias           = (_XSDK_GetExposureBias           )dlsym( m_hModule, "XSDK_GetExposureBias" );
		m_pfnCapDynamicRange           = (_XSDK_CapDynamicRange           )dlsym( m_hModule, "XSDK_CapDynamicRange" );
		m_pfnSetDynamicRange           = (_XSDK_SetDynamicRange           )dlsym( m_hModule, "XSDK_SetDynamicRange" );
		m_pfnGetDynamicRange           = (_XSDK_GetDynamicRange           )dlsym( m_hModule, "XSDK_GetDynamicRange" );
		m_pfnCapSensitivity            = (_XSDK_CapSensitivity            )dlsym( m_hModule, "XSDK_CapSensitivity" );
		m_pfnSetSensitivity            = (_XSDK_SetSensitivity            )dlsym( m_hModule, "XSDK_SetSensitivity" );
		m_pfnGetSensitivity            = (_XSDK_GetSensitivity            )dlsym( m_hModule, "XSDK_GetSensitivity" );
		m_pfnCapMeteringMode           = (_XSDK_CapMeteringMode           )dlsym( m_hModule, "XSDK_CapMeteringMode" );
		m_pfnSetMeteringMode           = (_XSDK_SetMeteringMode           )dlsym( m_hModule, "XSDK_SetMeteringMode" );
		m_pfnGetMeteringMode           = (_XSDK_GetMeteringMode           )dlsym( m_hModule, "XSDK_GetMeteringMode" );
		m_pfnCapLensZoomPos            = (_XSDK_CapLensZoomPos            )dlsym( m_hModule, "XSDK_CapLensZoomPos" );
		m_pfnGetLensZoomPos            = (_XSDK_GetLensZoomPos            )dlsym( m_hModule, "XSDK_GetLensZoomPos" );
		m_pfnSetLensZoomPos            = (_XSDK_SetLensZoomPos            )dlsym( m_hModule, "XSDK_SetLensZoomPos" );
		m_pfnCapAperture               = (_XSDK_CapAperture               )dlsym( m_hModule, "XSDK_CapAperture" );
		m_pfnSetAperture               = (_XSDK_SetAperture               )dlsym( m_hModule, "XSDK_SetAperture" );
		m_pfnGetAperture               = (_XSDK_GetAperture               )dlsym( m_hModule, "XSDK_GetAperture" );
		m_pfnCapWBMode                 = (_XSDK_CapWBMode                 )dlsym( m_hModule, "XSDK_CapWBMode" );
		m_pfnSetWBMode                 = (_XSDK_SetWBMode                 )dlsym( m_hModule, "XSDK_SetWBMode" );
		m_pfnGetWBMode                 = (_XSDK_GetWBMode                 )dlsym( m_hModule, "XSDK_GetWBMode" );
		m_pfnCapWBColorTemp            = (_XSDK_CapWBColorTemp            )dlsym( m_hModule, "XSDK_CapWBColorTemp" );
		m_pfnSetWBColorTemp            = (_XSDK_SetWBColorTemp            )dlsym( m_hModule, "XSDK_SetWBColorTemp" );
		m_pfnGetWBColorTemp            = (_XSDK_GetWBColorTemp            )dlsym( m_hModule, "XSDK_GetWBColorTemp" );
		m_pfnCapMediaRecord            = (_XSDK_CapMediaRecord            )dlsym( m_hModule, "XSDK_CapMediaRecord" );
		m_pfnSetMediaRecord            = (_XSDK_SetMediaRecord            )dlsym( m_hModule, "XSDK_SetMediaRecord" );
		m_pfnGetMediaRecord            = (_XSDK_GetMediaRecord            )dlsym( m_hModule, "XSDK_GetMediaRecord" );
		m_pfnCapForceMode              = (_XSDK_CapForceMode              )dlsym( m_hModule, "XSDK_CapForceMode" );
		m_pfnSetForceMode              = (_XSDK_SetForceMode              )dlsym( m_hModule, "XSDK_SetForceMode" );	
		m_pfnSetBackupSettings         = (_XSDK_SetBackupSettings         )dlsym( m_hModule, "XSDK_SetBackupSettings" );
		m_pfnGetBackupSettings         = (_XSDK_GetBackupSettings         )dlsym( m_hModule, "XSDK_GetBackupSettings" );
		m_pfnCapDriveMode              = (_XSDK_CapDriveMode              )dlsym( m_hModule, "XSDK_CapDriveMode" );
		m_pfnSetDriveMode              = (_XSDK_SetDriveMode              )dlsym( m_hModule, "XSDK_SetDriveMode" );
		m_pfnGetDriveMode              = (_XSDK_GetDriveMode              )dlsym( m_hModule, "XSDK_GetDriveMode" );
		m_pfnCapMode                   = (_XSDK_CapMode                   )dlsym( m_hModule, "XSDK_CapMode" );
		m_pfnSetMode                   = (_XSDK_SetMode                   )dlsym( m_hModule, "XSDK_SetMode" );
		m_pfnGetMode                   = (_XSDK_GetMode                   )dlsym( m_hModule, "XSDK_GetMode" );
		m_pfnGetRecordingStatus        = (_XSDK_GetRecordingStatus        )dlsym( m_hModule, "XSDK_GetRecordingStatus" );
		m_pfnCapMovieShutterSpeed      = (_XSDK_CapMovieShutterSpeed      )dlsym( m_hModule, "XSDK_CapMovieShutterSpeed" );
		m_pfnSetMovieShutterSpeed      = (_XSDK_SetMovieShutterSpeed      )dlsym( m_hModule, "XSDK_SetMovieShutterSpeed" );
		m_pfnGetMovieShutterSpeed      = (_XSDK_GetMovieShutterSpeed      )dlsym( m_hModule, "XSDK_GetMovieShutterSpeed" );
		m_pfnCapMovieExposureBias      = (_XSDK_CapMovieExposureBias      )dlsym( m_hModule, "XSDK_CapMovieExposureBias" );
		m_pfnSetMovieExposureBias      = (_XSDK_SetMovieExposureBias      )dlsym( m_hModule, "XSDK_SetMovieExposureBias" );
		m_pfnGetMovieExposureBias      = (_XSDK_GetMovieExposureBias      )dlsym( m_hModule, "XSDK_GetMovieExposureBias" );
		m_pfnCapMovieSensitivity       = (_XSDK_CapMovieSensitivity       )dlsym( m_hModule, "XSDK_CapMovieSensitivity" );
		m_pfnSetMovieSensitivity       = (_XSDK_SetMovieSensitivity       )dlsym( m_hModule, "XSDK_SetMovieSensitivity" );
		m_pfnGetMovieSensitivity       = (_XSDK_GetMovieSensitivity       )dlsym( m_hModule, "XSDK_GetMovieSensitivity" );
		m_pfnCapMovieAperture          = (_XSDK_CapMovieAperture          )dlsym( m_hModule, "XSDK_CapMovieAperture" );
		m_pfnSetMovieAperture          = (_XSDK_SetMovieAperture          )dlsym( m_hModule, "XSDK_SetMovieAperture" );
		m_pfnGetMovieAperture          = (_XSDK_GetMovieAperture          )dlsym( m_hModule, "XSDK_GetMovieAperture" );
		m_pfnCapMovieDynamicRange      = (_XSDK_CapMovieDynamicRange      )dlsym( m_hModule, "XSDK_CapMovieDynamicRange" );
		m_pfnSetMovieDynamicRange      = (_XSDK_SetMovieDynamicRange      )dlsym( m_hModule, "XSDK_SetMovieDynamicRange" );
		m_pfnGetMovieDynamicRange      = (_XSDK_GetMovieDynamicRange      )dlsym( m_hModule, "XSDK_GetMovieDynamicRange" );
		m_pfnCapMovieMeteringMode      = (_XSDK_CapMovieMeteringMode      )dlsym( m_hModule, "XSDK_CapMovieMeteringMode" );
		m_pfnSetMovieMeteringMode      = (_XSDK_SetMovieMeteringMode      )dlsym( m_hModule, "XSDK_SetMovieMeteringMode" );
		m_pfnGetMovieMeteringMode      = (_XSDK_GetMovieMeteringMode      )dlsym( m_hModule, "XSDK_GetMovieMeteringMode" );
		m_pfnCapMovieWBMode            = (_XSDK_CapMovieWBMode            )dlsym( m_hModule, "XSDK_CapMovieWBMode" );
		m_pfnSetMovieWBMode            = (_XSDK_SetMovieWBMode            )dlsym( m_hModule, "XSDK_SetMovieWBMode" );
		m_pfnGetMovieWBMode            = (_XSDK_GetMovieWBMode            )dlsym( m_hModule, "XSDK_GetMovieWBMode" );
		m_pfnCapMovieWBColorTemp       = (_XSDK_CapMovieWBColorTemp       )dlsym( m_hModule, "XSDK_CapMovieWBColorTemp" );
		m_pfnSetMovieWBColorTemp       = (_XSDK_SetMovieWBColorTemp       )dlsym( m_hModule, "XSDK_SetMovieWBColorTemp" );
		m_pfnGetMovieWBColorTemp       = (_XSDK_GetMovieWBColorTemp       )dlsym( m_hModule, "XSDK_GetMovieWBColorTemp" );
		m_pfnCapProp                   = (_XSDK_CapProp                   )dlsym( m_hModule, "XSDK_CapProp" );
		m_pfnSetProp                   = (_XSDK_SetProp                   )dlsym( m_hModule, "XSDK_SetProp" );
		m_pfnGetProp                   = (_XSDK_GetProp                   )dlsym( m_hModule, "XSDK_GetProp" );


		if( ( m_pfnInit == NULL )
		    || ( m_pfnExit == NULL )
		    || ( m_pfnDetect == NULL )
		    || ( m_pfnAppend == NULL )
		    || ( m_pfnOpenEx == NULL )
		    || ( m_pfnClose == NULL )
		    || ( m_pfnPowerOFF == NULL )
		    || ( m_pfnGetErrorNumber == NULL )
		    || ( m_pfnGetVersionString == NULL )
		    || ( m_pfnGetErrorDetails == NULL )
		    || ( m_pfnGetDeviceInfo == NULL )
		    || ( m_pfnWriteDeviceName == NULL )
		    || ( m_pfnGetFirmwareVersion == NULL )
		    || ( m_pfnGetLensInfo == NULL )
		    || ( m_pfnGetLensVersion == NULL )
		    || ( m_pfnGetDeviceInfoEx == NULL )
		    || ( m_pfnCapPriorityMode == NULL )
		    || ( m_pfnSetPriorityMode == NULL )
		    || ( m_pfnGetPriorityMode == NULL )
		    || ( m_pfnCapRelease == NULL )
		    || ( m_pfnRelease == NULL )
		    || ( m_pfnGetReleaseStatus == NULL)
		    || ( m_pfnCapReleaseEx == NULL )
		    || ( m_pfnReleaseEx == NULL )
		    || ( m_pfnReadImageInfo == NULL )
		    || ( m_pfnReadPreview == NULL )
		    || ( m_pfnReadImage == NULL )
		    || ( m_pfnDeleteImage == NULL )
		    || ( m_pfnGetBufferCapacity == NULL )
		    || ( m_pfnCapAEMode == NULL )
		    || ( m_pfnSetAEMode == NULL )
		    || ( m_pfnGetAEMode == NULL )
		    || ( m_pfnCapShutterSpeed == NULL )
		    || ( m_pfnSetShutterSpeed == NULL )
		    || ( m_pfnGetShutterSpeed == NULL )
		    || ( m_pfnCapExposureBias == NULL )
		    || ( m_pfnSetExposureBias == NULL )
		    || ( m_pfnGetExposureBias == NULL )
		    || ( m_pfnCapDynamicRange == NULL )
		    || ( m_pfnSetDynamicRange == NULL )
		    || ( m_pfnGetDynamicRange == NULL )
		    || ( m_pfnCapSensitivity == NULL )
		    || ( m_pfnSetSensitivity == NULL )
		    || ( m_pfnGetSensitivity == NULL )
		    || ( m_pfnCapMeteringMode == NULL )
		    || ( m_pfnSetMeteringMode == NULL )
		    || ( m_pfnGetMeteringMode == NULL )
		    || ( m_pfnCapLensZoomPos == NULL )
		    || ( m_pfnGetLensZoomPos == NULL )
		    || ( m_pfnSetLensZoomPos == NULL )
		    || ( m_pfnCapAperture == NULL )
		    || ( m_pfnSetAperture == NULL )
		    || ( m_pfnGetAperture == NULL )
		    || ( m_pfnCapWBMode == NULL )
		    || ( m_pfnSetWBMode == NULL )
		    || ( m_pfnGetWBMode == NULL )
		    || ( m_pfnCapWBColorTemp == NULL )
		    || ( m_pfnSetWBColorTemp == NULL )
		    || ( m_pfnGetWBColorTemp == NULL )
		    || ( m_pfnCapMediaRecord == NULL )
		    || ( m_pfnSetMediaRecord == NULL )
		    || ( m_pfnGetMediaRecord == NULL )
		    || ( m_pfnCapForceMode == NULL )
		    || ( m_pfnSetForceMode == NULL )
		    || ( m_pfnSetBackupSettings == NULL )
		    || ( m_pfnGetBackupSettings == NULL )
		    || ( m_pfnCapDriveMode == NULL )
		    || ( m_pfnSetDriveMode == NULL )
		    || ( m_pfnGetDriveMode == NULL )
		    || ( m_pfnCapMode == NULL )
		    || ( m_pfnSetMode == NULL )
		    || ( m_pfnGetMode == NULL )
		    || ( m_pfnGetRecordingStatus == NULL )
		    || ( m_pfnCapMovieShutterSpeed == NULL )
		    || ( m_pfnSetMovieShutterSpeed == NULL )
		    || ( m_pfnGetMovieShutterSpeed == NULL )
		    || ( m_pfnCapMovieExposureBias == NULL )
		    || ( m_pfnSetMovieExposureBias == NULL )
		    || ( m_pfnGetMovieExposureBias == NULL )
		    || ( m_pfnCapMovieSensitivity == NULL )
		    || ( m_pfnSetMovieSensitivity == NULL )
		    || ( m_pfnGetMovieSensitivity == NULL )
		    || ( m_pfnCapMovieAperture == NULL )
		    || ( m_pfnSetMovieAperture == NULL )
		    || ( m_pfnGetMovieAperture == NULL )
		    || ( m_pfnCapMovieDynamicRange == NULL )
		    || ( m_pfnSetMovieDynamicRange == NULL )
		    || ( m_pfnGetMovieDynamicRange == NULL )
		    || ( m_pfnCapMovieMeteringMode == NULL )
		    || ( m_pfnSetMovieMeteringMode == NULL )
		    || ( m_pfnGetMovieMeteringMode == NULL )
		    || ( m_pfnCapMovieWBMode == NULL )
		    || ( m_pfnSetMovieWBMode == NULL )
		    || ( m_pfnGetMovieWBMode == NULL )
		    || ( m_pfnCapMovieWBColorTemp == NULL )
		    || ( m_pfnSetMovieWBColorTemp == NULL )
		    || ( m_pfnGetMovieWBColorTemp == NULL )
		    || ( m_pfnCapProp == NULL )
		    || ( m_pfnSetProp == NULL )
		    || ( m_pfnGetProp == NULL ) )
		{
			// ERROR
			dlclose(m_hModule);
			m_hModule = NULL;
			m_iErr = FUJI_SDK_ERR_SDKVERSION;

		}
		else
		{
			// Success
			m_iErr = FUJI_SDK_ERR_OK;
		}
	}
}


int CFujiSDK::GetError()
{
	return m_iErr;
}


LIB_HANDLE CFujiSDK::GetHModule()
{
	return m_hModule;
}


