#include <iostream>
#include <dlfcn.h>
#include <string>
#include <cstring>
#include <iomanip>
#include <pthread.h>
#include "CameraControl.h"

CCameraControl::CCameraControl()
{
	m_pFujiSDK = NULL;
	m_apiCode = 0;
	m_errCode = 0;
	pthread_mutex_init(&m_cameraControlExclusion, NULL);
}

CCameraControl::~CCameraControl()
{
	if(m_pFujiSDK)
	{
		delete m_pFujiSDK;
		m_pFujiSDK = NULL;
	}
	pthread_mutex_destroy(&m_cameraControlExclusion);
}

bool CCameraControl::LoadLibraty()
{
	m_pFujiSDK = new CFujiSDK(NULL, "./SDK/XAPI.so");
	
	m_pFujiSDK->LoadSDKLibrary();
	
	if (m_pFujiSDK->GetError() != FUJI_SDK_ERR_OK)
	{
		return false;
	}

	return true;
}

long CCameraControl::Init()
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnInit(0);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(NULL, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::Exit()
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnExit();
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(NULL, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::Detect(long iInterface, LPSTR pInterface, LPSTR pDeviceName, long* pCount)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnDetect(iInterface, pInterface, pDeviceName, pCount);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(NULL, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::Append(long iInterface, LPSTR pInterface, LPSTR pDeviceName, long* pCount, XSDK_CameraList* pCameraList)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnAppend(iInterface, pInterface, pDeviceName, pCount, pCameraList);    
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(NULL, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::Open(LPSTR pDevice, XSDK_HANDLE* phCamera, long* plCameraMode, void* pOption)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnOpenEx(pDevice, phCamera, plCameraMode, pOption);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(NULL, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::Close(XSDK_HANDLE hCamera)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnClose(hCamera);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::GetDeviceInfo(XSDK_HANDLE hCamera, XSDK_DeviceInformation* pDevInfo)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnGetDeviceInfo(hCamera, pDevInfo);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::GetSensitivity(XSDK_HANDLE hCamera, long* pSensitivity)
{
	long result = XSDK_ERROR;
	pthread_mutex_lock(&m_cameraControlExclusion);

	try
	{
		result = m_pFujiSDK->m_pfnGetSensitivity(hCamera, pSensitivity);
		if(result != XSDK_COMPLETE)
		{
			m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
		}
	}
	catch (...)
	{
	}
	pthread_mutex_unlock(&m_cameraControlExclusion);

	return result;
}

long CCameraControl::ReadImageInfo(XSDK_HANDLE hCamera, XSDK_ImageInformation* imgInfo)
{
    long result = XSDK_ERROR;
    pthread_mutex_lock(&m_cameraControlExclusion);
    
    try
    {
        result = m_pFujiSDK->m_pfnReadImageInfo(hCamera, imgInfo);
        if(result != XSDK_COMPLETE)
    	{
    	    m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
    	}
    }
    catch (...)
    {
    }
    pthread_mutex_unlock(&m_cameraControlExclusion);
    
    return result;
}

long CCameraControl::ReadImage(XSDK_HANDLE hCamera, unsigned char* pBuf, unsigned long lDataSize)
{
    long result = XSDK_ERROR;
    pthread_mutex_lock(&m_cameraControlExclusion);
    
    try
    {
        result = m_pFujiSDK->m_pfnReadImage(hCamera, pBuf, lDataSize);
        if(result != XSDK_COMPLETE)
    	{
    	    m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
    	}
    }
    catch (...)
    {
    }
    pthread_mutex_unlock(&m_cameraControlExclusion);
    
    return result;
}

long CCameraControl::SetPriorityMode(XSDK_HANDLE hCamera, long lmode)
{
    long result = XSDK_ERROR;
    pthread_mutex_lock(&m_cameraControlExclusion);
    
    try
    {
        result = m_pFujiSDK->m_pfnSetPriorityMode(hCamera, lmode);
        if(result != XSDK_COMPLETE)
    	{
    	    m_pFujiSDK->m_pfnGetErrorNumber(hCamera, &m_apiCode, &m_errCode);
    	}
    }
    catch (...)
    {
    }
    pthread_mutex_unlock(&m_cameraControlExclusion);
    
    return result;
}
