﻿using System;
using Gtk;
using ZoomPos;
using FujiSDK;
using CCameraControl;

public partial class ZoomPosForm : Gtk.Window
{
    public string state = "DisConnect";
    ZoomPosControl zoomPosControl;
    private uint timer;
    private Fixed fixed1;
    private Label BusyCountLabel, label2, ZoomFocalLength35, label4, ZoomFocalLength, label3, label1, StateLabel;
    private Button ExitButton;
    private Frame frame;

    public ZoomPosForm() : base("ZoomPos")
    {
        this.SetDefaultSize(400, 400);
        this.DeleteEvent += OnDeleteEvent;
        CreateUI();

        bool bLoad = false;
        zoomPosControl = new ZoomPosControl();

        zoomPosControl.LoadLibrary(); // Start SDK communication.
        bLoad = zoomPosControl.LoadLibrary();
        if (!bLoad)
        {
            // err
            using (var errDialog = new MessageDialog(null,
                DialogFlags.DestroyWithParent,
                MessageType.Error,
                ButtonsType.Ok,
                "Failed to load XAPI.so"))
            {
                errDialog.Title = "ERR Message";
                errDialog.Run();
                errDialog.Destroy();
            }
            Environment.Exit(0);
            return;
        }

        zoomPosControl.SetDetectOption(CameraControl.XSDK_DSC_IF_USB, null);
        zoomPosControl.BeginConnectThread();

        SetTimer();
    }

    protected void OnDeleteEvent(object sender, DeleteEventArgs a)
    {
        GLib.Source.Remove(timer);
        zoomPosControl.TerminateConnection();
        Application.Quit();
        a.RetVal = true;
    }
    // Exit Application
    protected void OnExitButtonClicked(object sender, EventArgs e)
    {
        GLib.Source.Remove(timer);
        zoomPosControl.TerminateConnection();
        Application.Quit();
    }

    private void CreateUI()
    {
        fixed1 = new Fixed
        {
            WidthRequest = 400,
            HeightRequest = 400,
            Name = "fixed1",
            HasWindow = false
        };
        this.Add(fixed1);

        CreateLabels();
        CreateButtons();
        CreateFrames();

        this.ShowAll();
    }

    private void CreateLabels()
    {
        BusyCountLabel = new Label
        {
            WidthRequest = 300,
            Name = "BusyCountLabel",
            Xalign = 1F,
            LabelProp = "0"
        };
        fixed1.Put(BusyCountLabel, 131, 282);

        label2 = new Label
        {
            Name = "label2",
            LabelProp = "Communication BUSY count:"
        };
        fixed1.Put(label2, 22, 253);

        ZoomFocalLength35 = new Label
        {
            WidthRequest = 300,
            Name = "ZoomFocalLength35",
            Xalign = 1F,
            LabelProp = "- - mm"
        };
        fixed1.Put(ZoomFocalLength35, 131, 215);

        label4 = new Label
        {
            Name = "label4",
            LabelProp = "Zoom focal length (in 35mm format):"
        };
        fixed1.Put(label4, 23, 184);

        ZoomFocalLength = new Label
        {
            WidthRequest = 300,
            Name = "ZoomFocalLength",
            Xalign = 1F,
            LabelProp = "- - mm"
        };
        fixed1.Put(ZoomFocalLength, 129, 146);

        label3 = new Label
        {
            LabelProp = "Zoom focal length:"
        };
        fixed1.Put(label3, 24, 105);

        label1 = new Label
        {
            WidthRequest = 300,
            Name = "label1",
            LabelProp = "──────────────────────────────"
        };
        fixed1.Put(label1, 0, 60);

        StateLabel = new Label
        {
            Name = "StateLabel",
            Xalign = 1F,
            LabelProp = "  Waiting for a camera to be connected.",
            UseUnderline = true
        };
        fixed1.Put(StateLabel, 25, 24);
    }

    private void CreateButtons()
    {
        ExitButton = new Button
        {
            WidthRequest = 120,
            Name = "ExitButton",
            UseUnderline = true,
            Label = "Exit"
        };
        fixed1.Put(ExitButton, 318, 343);
        ExitButton.Clicked += OnExitButtonClicked;
    }

    private void CreateFrames()
    {
        frame = new Frame
        {
            WidthRequest = 290,
            HeightRequest = 30,
            Name = "frame",
            ShadowType = ShadowType.Out
        };
        fixed1.Put(frame, 21, 20);
    }

    private void SetTimer()
    {
        timer = GLib.Timeout.Add(500, () =>
                {
                    ConectCheck();

                    return true;
                });
    }

    private void ConectCheck()
    {
        switch (state)
        {
            case "DisConnect":
                if (zoomPosControl != null)
                {
                    // Connection Check
                    if (zoomPosControl.IsConnectThread() == ZoomPosControl.FALSE)
                    {
                        zoomPosControl.EndConnectThread();
                        zoomPosControl.BeginPollThread();

                        state = "Connect";
                        StateLabel.Text = " Connect";
                        frame.WidthRequest = 80;
                    }
                }
                break;
            case "Connect":
                if (zoomPosControl != null)
                {
                    // Connection Check
                    if (zoomPosControl.IsPollThread() != ZoomPosControl.FALSE)
                    {
                        long lFocalLength;
                        int busyCount;

                        lFocalLength = zoomPosControl.GetFocalLength();
                        if (lFocalLength > 0)
                        {
                            ZoomFocalLength.Text = (lFocalLength / 100).ToString() + "." + (lFocalLength % 100).ToString() + " mm";
                        }
                        else
                        {
                            ZoomFocalLength.Text = "- - mm";
                        }

                        lFocalLength = zoomPosControl.Get35mmFocalLength();
                        if (lFocalLength > 0)
                        {
                            ZoomFocalLength35.Text = (lFocalLength / 100).ToString() + "." + (lFocalLength % 100).ToString() + " mm";
                        }
                        else
                        {
                            ZoomFocalLength35.Text = "- - mm";
                        }

                        busyCount = zoomPosControl.GetBusyCount();
                        BusyCountLabel.Text = busyCount.ToString();
                    }
                    else
                    {
                        zoomPosControl.EndPollThread();
                        zoomPosControl.TerminateConnection();
                        zoomPosControl.SetDetectOption(CameraControl.XSDK_DSC_IF_USB, null);
                        zoomPosControl.BeginConnectThread();

                        state = "DisConnect";
                        StateLabel.Text =" Waiting for a camera to be connected.";
                        frame.WidthRequest = 290;
                        ZoomFocalLength.Text = "- - mm";
                        ZoomFocalLength35.Text = "- - mm";
                        BusyCountLabel.Text = "0";
                    }
                }
                break;
        }
    }
}
