package com.fujifilm.zoompos

import androidx.lifecycle.lifecycleScope
import com.fujifilm.zoompos.xsdk.XSDK
import kotlinx.coroutines.*

class ZoomFocal (private val activity: MainActivity){

    @Synchronized
    fun startGetZoomFocal(hCamera: Long){
        activity.lifecycleScope.launch {
            withContext(Dispatchers.IO) {
                while (ZoomPosState.isStartZoomFocal) {
                    val numZoomPos = XSDK.SDKLong(0)
                    val plZoomPos = mutableListOf<Long>()
                    val plFocusLength = mutableListOf<Long>()
                    val pl35mmFocusLength = mutableListOf<Long>()
                    var res = CameraControl.capLensZoomPos(hCamera, numZoomPos, plZoomPos, plFocusLength, pl35mmFocusLength)
                    if (res != SDKResult.XSDK_COMPLETE) {
                        val errStr = CameraControl.getError(hCamera)
                        if (errStr.contains("XSDK_ERRCODE_BUSY") ||
                            errStr.contains("XSDK_ERRCODE_FORCEMODE_BUSY") ||
                            errStr.contains("XSDK_ERRCODE_RUNNING_OTHER_FUNCTION")) {
                            ZoomPosState.errorCount++
                            withContext(Dispatchers.Main){
                                activity.errorCount.text = ZoomPosState.errorCount.toString()
                            }
                        }else{
                            ZoomPosState.isStartZoomFocal = false
                            ZoomPosState.connectState = false
                            ZoomPosState.errorCount = 0
                            withContext(Dispatchers.Main){
                                activity.valueText.text = "- - mm"
                                activity.value35mmText.text = "- - mm"
                                activity.errorCount.text = ZoomPosState.errorCount.toString()
                            }
                            break
                        }
                    }else{
                        val zoompos = XSDK.SDKLong(0)
                        res = CameraControl.getLensZoomPos(hCamera, zoompos)
                        if (res != SDKResult.XSDK_COMPLETE) {
                            val errStr = CameraControl.getError(hCamera)
                            if (errStr.contains("XSDK_ERRCODE_BUSY") ||
                                errStr.contains("XSDK_ERRCODE_FORCEMODE_BUSY") ||
                                errStr.contains("XSDK_ERRCODE_RUNNING_OTHER_FUNCTION")) {
                                ZoomPosState.errorCount++
                                withContext(Dispatchers.Main){
                                    activity.errorCount.text = ZoomPosState.errorCount.toString()
                                }
                            }else{
                                ZoomPosState.isStartZoomFocal = false
                                ZoomPosState.connectState = false
                                ZoomPosState.errorCount = 0
                                withContext(Dispatchers.Main){
                                    activity.valueText.text = "- - mm"
                                    activity.value35mmText.text = "- - mm"
                                    activity.errorCount.text = ZoomPosState.errorCount.toString()
                                }
                                break
                            }
                        }else{
                            if (numZoomPos.long != 0L && plZoomPos.size != 0) {
                                for(i in 0 until numZoomPos.long.toInt()){
                                    if (plZoomPos[i] == zoompos.long) {
                                        withContext(Dispatchers.Main){
                                            if (plFocusLength[i] > 0) {
                                                val dVal = plFocusLength[i] / 100.0
                                                val d35mmVal = pl35mmFocusLength[i] / 100.0
                                                activity.valueText.text = "$dVal mm"
                                                activity.value35mmText.text = "$d35mmVal mm"
                                            } else {
                                                activity.valueText.text = "- - mm"
                                                activity.value35mmText.text = "- - mm"
                                            }
                                        }
                                        break
                                    }
                                    if(i == numZoomPos.long.toInt() - 1){
                                        withContext(Dispatchers.Main){
                                            activity.valueText.text = "- - mm"
                                            activity.value35mmText.text = "- - mm"
                                        }
                                        break
                                    }
                                }
                            }else{
                                withContext(Dispatchers.Main){
                                    activity.valueText.text = "- - mm"
                                    activity.value35mmText.text = "- - mm"
                                }
                            }
                        }
                    }
                    delay(300)
                }
            }
        }
    }
}