#include <jni.h>
#include <string>
#include <dlfcn.h>
#include "LibWrapper.h"

void *handle;

typedef long (*init_sdk)(long);
init_sdk sdk_init;
typedef long (*exit_sdk)();
exit_sdk sdk_exit;
typedef long (*setUSBDeviceHandle_sdk)(long, unsigned char*, void*);
setUSBDeviceHandle_sdk sdk_setUSBDeviceHandle;
typedef long (*close_sdk)(void*);
close_sdk sdk_close;
typedef long (*powerOFF_sdk)(void*);
powerOFF_sdk sdk_powerOFF;
typedef long (*getErrorNumber_sdk)(void*, long*, long*);
getErrorNumber_sdk sdk_getErrorNumber;
typedef long (*getErrorDetails_sdk)(void*, long*);
getErrorDetails_sdk sdk_getErrorDetails;
typedef long (*getVersionString_sdk)(char*);
getVersionString_sdk sdk_getVersionString;
typedef long (*getDeviceInfo_sdk)(void*, void*);
getDeviceInfo_sdk sdk_getDeviceInfo;
typedef long (*getDeviceInfoEx_sdk)(void*, void*, long*, long*);
getDeviceInfoEx_sdk sdk_getDeviceInfoEx;
typedef long (*writeDeviceName_sdk)(void*, char*);
writeDeviceName_sdk sdk_writeDeviceName;
typedef long (*getFirmwareVersion_sdk)(void*, char*);
getFirmwareVersion_sdk sdk_getFirmwareVersion;
typedef long (*getLensInfo_sdk)(void*, void*);
getLensInfo_sdk sdk_getLensInfo;
typedef long (*getLensVersion_sdk)(void*, char*);
getLensVersion_sdk sdk_getLensVersion;
typedef long (*capPriorityMode_sdk)(void*, long*, long*);
capPriorityMode_sdk sdk_capPriorityMode;
typedef long (*setPriorityMode_sdk)(void*, long);
setPriorityMode_sdk sdk_setPriorityMode;
typedef long (*getPriorityMode_sdk)(void*, long*);
getPriorityMode_sdk sdk_getPriorityMode;
typedef long (*capRelease_sdk)(void*, long*, long*);
capRelease_sdk sdk_capRelease;
typedef long (*release_sdk)(void*, long, long*, long*);
release_sdk sdk_release;
typedef long (*capReleaseEx_sdk)(void*, long*, long*);
capReleaseEx_sdk sdk_capReleaseEx;
typedef long (*releaseEx_sdk)(void*, long, long*, long*);
releaseEx_sdk sdk_releaseEx;
typedef long (*getReleaseStatus_sdk)(void*, long*);
getReleaseStatus_sdk sdk_getReleaseStatus;
typedef long (*getRecordingStatus_sdk)(void*, long*);
getRecordingStatus_sdk sdk_getRecordingStatus;
typedef long (*readImageInfo_sdk)(void*, void*);
readImageInfo_sdk sdk_readImageInfo;
typedef long (*readPreview_sdk)(void*, unsigned char*, unsigned long);
readPreview_sdk sdk_readPreview;
typedef long (*readImage_sdk)(void*, unsigned char*, unsigned long);
readImage_sdk sdk_readImage;
typedef long (*deleteImage_sdk)(void*);
deleteImage_sdk sdk_deleteImage;
typedef long (*getBufferCapacity_sdk)(void*, long*, long*);
getBufferCapacity_sdk sdk_getBufferCapacity;
typedef long (*capAEMode_sdk)(void*, long*, long*);
capAEMode_sdk sdk_capAEMode;
typedef long (*setAEMode_sdk)(void*, long);
setAEMode_sdk sdk_setAEMode;
typedef long (*getAEMode_sdk)(void*, long*);
getAEMode_sdk sdk_getAEMode;
typedef long (*capShutterSpeed_sdk)(void*, long*, long*, long*);
capShutterSpeed_sdk sdk_capShutterSpeed;
typedef long (*setShutterSpeed_sdk)(void*, long, long);
setShutterSpeed_sdk sdk_setShutterSpeed;
typedef long (*getShutterSpeed_sdk)(void*, long*, long*);
getShutterSpeed_sdk sdk_getShutterSpeed;
typedef long (*capExposureBias_sdk)(void*, long*, long*);
capExposureBias_sdk sdk_capExposureBias;
typedef long (*setExposureBias_sdk)(void*, long);
setExposureBias_sdk sdk_setExposureBias;
typedef long (*getExposureBias_sdk)(void*, long*);
getExposureBias_sdk sdk_getExposureBias;
typedef long (*capDynamicRange_sdk)(void*, long*, long*);
capDynamicRange_sdk sdk_capDynamicRange;
typedef long (*setDynamicRange_sdk)(void*, long);
setDynamicRange_sdk sdk_setDynamicRange;
typedef long (*getDynamicRange_sdk)(void*, long*);
getDynamicRange_sdk sdk_getDynamicRange;
typedef long (*capSensitivity_sdk)(void*, long*, long*);
capSensitivity_sdk sdk_capSensitivity;
typedef long (*setSensitivity_sdk)(void*, long);
setSensitivity_sdk sdk_setSensitivity;
typedef long (*getSensitivity_sdk)(void*, long*);
getSensitivity_sdk sdk_getSensitivity;
typedef long (*capMeteringMode_sdk)(void*, long*, long*);
capMeteringMode_sdk sdk_capMeteringMode;
typedef long (*setMeteringMode_sdk)(void*, long);
setMeteringMode_sdk sdk_setMeteringMode;
typedef long (*getMeteringMode_sdk)(void*, long*);
getMeteringMode_sdk sdk_getMeteringMode;
typedef long (*capLensZoomPos_sdk)(void*, long*, long*, long*, long*);
capLensZoomPos_sdk sdk_capLensZoomPos;
typedef long (*setLensZoomPos_sdk)(void*, long);
setLensZoomPos_sdk sdk_setLensZoomPos;
typedef long (*getLensZoomPos_sdk)(void*, long*);
getLensZoomPos_sdk sdk_getLensZoomPos;
typedef long (*capAperture_sdk)(void*, long, long*, long*);
capAperture_sdk sdk_capAperture;
typedef long (*setAperture_sdk)(void*, long);
setAperture_sdk sdk_setAperture;
typedef long (*getAperture_sdk)(void*, long*);
getAperture_sdk sdk_getAperture;
typedef long (*capWBMode_sdk)(void*, long*, long*);
capWBMode_sdk sdk_capWBMode;
typedef long (*setWBMode_sdk)(void*, long);
setWBMode_sdk sdk_setWBMode;
typedef long (*getWBMode_sdk)(void*, long*);
getWBMode_sdk sdk_getWBMode;
typedef long (*capWBColorTemp_sdk)(void*, long*, long*);
capWBColorTemp_sdk sdk_capWBColorTemp;
typedef long (*setWBColorTemp_sdk)(void*, long);
setWBColorTemp_sdk sdk_setWBColorTemp;
typedef long (*getWBColorTemp_sdk)(void*, long*);
getWBColorTemp_sdk sdk_getWBColorTemp;
typedef long (*capMovieShutterSpeed_sdk)(void*, long*, long long*);
capMovieShutterSpeed_sdk sdk_capMovieShutterSpeed;
typedef long (*setMovieShutterSpeed_sdk)(void*, long long);
setMovieShutterSpeed_sdk sdk_setMovieShutterSpeed;
typedef long (*getMovieShutterSpeed_sdk)(void*, long long*);
getMovieShutterSpeed_sdk sdk_getMovieShutterSpeed;
typedef long (*capMovieExposureBias_sdk)(void*, long*, long*);
capMovieExposureBias_sdk sdk_capMovieExposureBias;
typedef long (*setMovieExposureBias_sdk)(void*, long);
setMovieExposureBias_sdk sdk_setMovieExposureBias;
typedef long (*getMovieExposureBias_sdk)(void*, long*);
getMovieExposureBias_sdk sdk_getMovieExposureBias;
typedef long (*capMovieSensitivity_sdk)(void*, long*, long*);
capMovieSensitivity_sdk sdk_capMovieSensitivity;
typedef long (*setMovieSensitivity_sdk)(void*, long);
setMovieSensitivity_sdk sdk_setMovieSensitivity;
typedef long (*getMovieSensitivity_sdk)(void*, long*);
getMovieSensitivity_sdk sdk_getMovieSensitivity;
typedef long (*capMovieAperture_sdk)(void*, long*, long*);
capMovieAperture_sdk sdk_capMovieAperture;
typedef long (*setMovieAperture_sdk)(void*, long);
setMovieAperture_sdk sdk_setMovieAperture;
typedef long (*getMovieAperture_sdk)(void*, long*);
getMovieAperture_sdk sdk_getMovieAperture;
typedef long (*capMovieDynamicRange_sdk)(void*, long*, long*);
capMovieDynamicRange_sdk sdk_capMovieDynamicRange;
typedef long (*setMovieDynamicRange_sdk)(void*, long);
setMovieDynamicRange_sdk sdk_setMovieDynamicRange;
typedef long (*getMovieDynamicRange_sdk)(void*, long*);
getMovieDynamicRange_sdk sdk_getMovieDynamicRange;
typedef long (*capMovieMeteringMode_sdk)(void*, long*, long*);
capMovieMeteringMode_sdk sdk_capMovieMeteringMode;
typedef long (*setMovieMeteringMode_sdk)(void*, long);
setMovieMeteringMode_sdk sdk_setMovieMeteringMode;
typedef long (*getMovieMeteringMode_sdk)(void*, long*);
getMovieMeteringMode_sdk sdk_getMovieMeteringMode;
typedef long (*capMovieWBMode_sdk)(void*, long*, long*);
capMovieWBMode_sdk sdk_capMovieWBMode;
typedef long (*setMovieWBMode_sdk)(void*, long);
setMovieWBMode_sdk sdk_setMovieWBMode;
typedef long (*getMovieWBMode_sdk)(void*, long*);
getMovieWBMode_sdk sdk_getMovieWBMode;
typedef long (*capMovieWBColorTemp_sdk)(void*, long*, long*);
capMovieWBColorTemp_sdk sdk_capMovieWBColorTemp;
typedef long (*setMovieWBColorTemp_sdk)(void*, long);
setMovieWBColorTemp_sdk sdk_setMovieWBColorTemp;
typedef long (*getMovieWBColorTemp_sdk)(void*, long*);
getMovieWBColorTemp_sdk sdk_getMovieWBColorTemp;
typedef long (*capMediaRecord_sdk)(void*, long*, long*);
capMediaRecord_sdk sdk_capMediaRecord;
typedef long (*setMediaRecord_sdk)(void*, long);
setMediaRecord_sdk sdk_setMediaRecord;
typedef long (*getMediaRecord_sdk)(void*, long*);
getMediaRecord_sdk sdk_getMediaRecord;
typedef long (*capForceMode_sdk)(void*, long*, long*);
capForceMode_sdk sdk_capForceMode;
typedef long (*setForceMode_sdk)(void*, long);
setForceMode_sdk sdk_setForceMode;
typedef long (*capDriveMode_sdk)(void*, long*, long*);
capDriveMode_sdk sdk_capDriveMode;
typedef long (*setDriveMode_sdk)(void*, long);
setDriveMode_sdk sdk_setDriveMode;
typedef long (*getDriveMode_sdk)(void*, long*);
getDriveMode_sdk sdk_getDriveMode;
typedef long (*capMode_sdk)(void*, long*, long*);
capMode_sdk sdk_capMode;
typedef long (*setMode_sdk)(void*, long);
setMode_sdk sdk_setMode;
typedef long (*getMode_sdk)(void*, long*);
getMode_sdk sdk_getMode;
typedef long (*setBackupSettings_sdk)(void*, long, unsigned char*);
setBackupSettings_sdk sdk_setBackupSettings;
typedef long (*getBackupSettings_sdk)(void*, long*, unsigned char*);
getBackupSettings_sdk sdk_getBackupSettings;
typedef long (*capProp_sdk)(void*, long, long,...);
capProp_sdk sdk_capProp;
typedef long (*setProp_sdk)(void*, long, long,...);
setProp_sdk sdk_setProp;
typedef long (*getProp_sdk)(void*, long, long,...);
getProp_sdk sdk_getProp;

void Set_longTojlongFld	(JNIEnv *pEnv, jobject obj, jclass clazz, const char *FieldName, long longbuf)
{
    jfieldID fid = pEnv->GetFieldID(clazz, FieldName , "J");
    if (fid == NULL)
    {
        return;
    }
    pEnv->SetLongField(obj, fid, longbuf);
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1loadLibrary(JNIEnv *env, jobject thiz){
    handle = dlopen("XAPI.so", RTLD_LAZY);
    if(!handle)
    {
        char* str = dlerror();
        fprintf(stderr, "%s\n", str);
        return XSDK_APP_ERROR;
    }
    sdk_init = (init_sdk) dlsym(handle, "XSDK_Init");
    sdk_exit = (exit_sdk) dlsym(handle, "XSDK_Exit");
    sdk_setUSBDeviceHandle = (setUSBDeviceHandle_sdk) dlsym(handle, "XSDK_SetUSBDeviceHandle");
    sdk_close = (close_sdk) dlsym(handle, "XSDK_Close");
    sdk_powerOFF = (powerOFF_sdk) dlsym(handle, "XSDK_PowerOFF");
    sdk_getErrorNumber = (getErrorNumber_sdk) dlsym(handle, "XSDK_GetErrorNumber");
    sdk_getErrorDetails = (getErrorDetails_sdk) dlsym(handle, "XSDK_GetErrorDetails");
    sdk_getVersionString = (getVersionString_sdk) dlsym(handle, "XSDK_GetVersionString");
    sdk_getDeviceInfo = (getDeviceInfo_sdk) dlsym(handle, "XSDK_GetDeviceInfo");
    sdk_getDeviceInfoEx = (getDeviceInfoEx_sdk) dlsym(handle, "XSDK_GetDeviceInfoEx");
    sdk_writeDeviceName = (writeDeviceName_sdk) dlsym(handle, "XSDK_WriteDeviceName");
    sdk_getFirmwareVersion = (getFirmwareVersion_sdk) dlsym(handle, "XSDK_GetFirmwareVersion");
    sdk_getLensInfo = (getLensInfo_sdk) dlsym(handle, "XSDK_GetLensInfo");
    sdk_getLensVersion = (getLensVersion_sdk) dlsym(handle, "XSDK_GetLensVersion");
    sdk_capPriorityMode = (capPriorityMode_sdk) dlsym(handle, "XSDK_CapPriorityMode");
    sdk_setPriorityMode = (setPriorityMode_sdk) dlsym(handle, "XSDK_SetPriorityMode");
    sdk_getPriorityMode = (getPriorityMode_sdk) dlsym(handle, "XSDK_GetPriorityMode");
    sdk_capRelease = (capRelease_sdk) dlsym(handle, "XSDK_CapRelease");
    sdk_release = (release_sdk) dlsym(handle, "XSDK_Release");
    sdk_capReleaseEx = (capReleaseEx_sdk) dlsym(handle, "XSDK_CapReleaseEx");
    sdk_releaseEx = (releaseEx_sdk) dlsym(handle, "XSDK_ReleaseEx");
    sdk_getReleaseStatus = (getReleaseStatus_sdk) dlsym(handle, "XSDK_GetReleaseStatus");
    sdk_getRecordingStatus = (getRecordingStatus_sdk) dlsym(handle, "XSDK_GetRecordingStatus");
    sdk_readImageInfo = (readImageInfo_sdk) dlsym(handle, "XSDK_ReadImageInfo");
    sdk_readPreview = (readPreview_sdk) dlsym(handle, "XSDK_ReadPreview");
    sdk_readImage = (readImage_sdk) dlsym(handle, "XSDK_ReadImage");
    sdk_deleteImage = (deleteImage_sdk) dlsym(handle, "XSDK_DeleteImage");
    sdk_getBufferCapacity = (getBufferCapacity_sdk) dlsym(handle, "XSDK_GetBufferCapacity");
    sdk_capAEMode = (capAEMode_sdk) dlsym(handle, "XSDK_CapAEMode");
    sdk_setAEMode = (setAEMode_sdk) dlsym(handle, "XSDK_SetAEMode");
    sdk_getAEMode = (getAEMode_sdk) dlsym(handle, "XSDK_GetAEMode");
    sdk_capShutterSpeed = (capShutterSpeed_sdk) dlsym(handle, "XSDK_CapShutterSpeed");
    sdk_setShutterSpeed = (setShutterSpeed_sdk) dlsym(handle, "XSDK_SetShutterSpeed");
    sdk_getShutterSpeed = (getShutterSpeed_sdk) dlsym(handle, "XSDK_GetShutterSpeed");
    sdk_capExposureBias = (capExposureBias_sdk) dlsym(handle, "XSDK_CapExposureBias");
    sdk_setExposureBias = (setExposureBias_sdk) dlsym(handle, "XSDK_SetExposureBias");
    sdk_getExposureBias = (getExposureBias_sdk) dlsym(handle, "XSDK_GetExposureBias");
    sdk_capDynamicRange = (capDynamicRange_sdk) dlsym(handle, "XSDK_CapDynamicRange");
    sdk_setDynamicRange = (setDynamicRange_sdk) dlsym(handle, "XSDK_SetDynamicRange");
    sdk_getDynamicRange = (getDynamicRange_sdk) dlsym(handle, "XSDK_GetDynamicRange");
    sdk_capSensitivity = (capSensitivity_sdk) dlsym(handle, "XSDK_CapSensitivity");
    sdk_setSensitivity = (setSensitivity_sdk) dlsym(handle, "XSDK_SetSensitivity");
    sdk_getSensitivity = (getSensitivity_sdk) dlsym(handle, "XSDK_GetSensitivity");
    sdk_capMeteringMode = (capMeteringMode_sdk) dlsym(handle, "XSDK_CapMeteringMode");
    sdk_setMeteringMode = (setMeteringMode_sdk) dlsym(handle, "XSDK_SetMeteringMode");
    sdk_getMeteringMode = (getMeteringMode_sdk) dlsym(handle, "XSDK_GetMeteringMode");
    sdk_capLensZoomPos = (capLensZoomPos_sdk) dlsym(handle, "XSDK_CapLensZoomPos");
    sdk_setLensZoomPos = (setLensZoomPos_sdk) dlsym(handle, "XSDK_SetLensZoomPos");
    sdk_getLensZoomPos = (getLensZoomPos_sdk) dlsym(handle, "XSDK_GetLensZoomPos");
    sdk_capAperture = (capAperture_sdk) dlsym(handle, "XSDK_CapAperture");
    sdk_setAperture = (setAperture_sdk) dlsym(handle, "XSDK_SetAperture");
    sdk_getAperture = (getAperture_sdk) dlsym(handle, "XSDK_GetAperture");
    sdk_capWBMode = (capWBMode_sdk) dlsym(handle, "XSDK_CapWBMode");
    sdk_setWBMode = (setWBMode_sdk) dlsym(handle, "XSDK_SetWBMode");
    sdk_getWBMode = (getWBMode_sdk) dlsym(handle, "XSDK_GetWBMode");
    sdk_capWBColorTemp = (capWBColorTemp_sdk) dlsym(handle, "XSDK_CapWBColorTemp");
    sdk_setWBColorTemp = (setWBColorTemp_sdk) dlsym(handle, "XSDK_SetWBColorTemp");
    sdk_getWBColorTemp = (getWBColorTemp_sdk) dlsym(handle, "XSDK_GetWBColorTemp");
    sdk_capMovieShutterSpeed = (capMovieShutterSpeed_sdk) dlsym(handle, "XSDK_CapMovieShutterSpeed");
    sdk_setMovieShutterSpeed = (setMovieShutterSpeed_sdk) dlsym(handle, "XSDK_SetMovieShutterSpeed");
    sdk_getMovieShutterSpeed = (getMovieShutterSpeed_sdk) dlsym(handle, "XSDK_GetMovieShutterSpeed");
    sdk_capMovieExposureBias = (capMovieExposureBias_sdk) dlsym(handle, "XSDK_CapMovieExposureBias");
    sdk_setMovieExposureBias = (setMovieExposureBias_sdk) dlsym(handle, "XSDK_SetMovieExposureBias");
    sdk_getMovieExposureBias = (getMovieExposureBias_sdk) dlsym(handle, "XSDK_GetMovieExposureBias");
    sdk_capMovieSensitivity = (capMovieSensitivity_sdk) dlsym(handle, "XSDK_CapMovieSensitivity");
    sdk_setMovieSensitivity = (setMovieSensitivity_sdk) dlsym(handle, "XSDK_SetMovieSensitivity");
    sdk_getMovieSensitivity = (getMovieSensitivity_sdk) dlsym(handle, "XSDK_GetMovieSensitivity");
    sdk_capMovieAperture = (capMovieAperture_sdk)dlsym(handle, "XSDK_CapMovieAperture");
    sdk_setMovieAperture = (setMovieAperture_sdk)dlsym(handle, "XSDK_SetMovieAperture");
    sdk_getMovieAperture = (getMovieAperture_sdk)dlsym(handle, "XSDK_GetMovieAperture");
    sdk_capMovieDynamicRange = (capMovieDynamicRange_sdk) dlsym(handle, "XSDK_CapMovieDynamicRange");
    sdk_setMovieDynamicRange = (setMovieDynamicRange_sdk) dlsym(handle, "XSDK_SetMovieDynamicRange");
    sdk_getMovieDynamicRange = (getMovieDynamicRange_sdk) dlsym(handle, "XSDK_GetMovieDynamicRange");
    sdk_capMovieMeteringMode = (capMovieMeteringMode_sdk) dlsym(handle, "XSDK_CapMovieMeteringMode");
    sdk_setMovieMeteringMode = (setMovieMeteringMode_sdk) dlsym(handle, "XSDK_SetMovieMeteringMode");
    sdk_getMovieMeteringMode = (getMovieMeteringMode_sdk) dlsym(handle, "XSDK_GetMovieMeteringMode");
    sdk_capMovieWBMode = (capMovieWBMode_sdk) dlsym(handle, "XSDK_CapMovieWBMode");
    sdk_setMovieWBMode = (setMovieWBMode_sdk) dlsym(handle, "XSDK_SetMovieWBMode");
    sdk_getMovieWBMode = (getMovieWBMode_sdk) dlsym(handle, "XSDK_GetMovieWBMode");
    sdk_capMovieWBColorTemp = (capMovieWBColorTemp_sdk) dlsym(handle, "XSDK_CapMovieWBColorTemp");
    sdk_setMovieWBColorTemp = (setMovieWBColorTemp_sdk) dlsym(handle, "XSDK_SetMovieWBColorTemp");
    sdk_getMovieWBColorTemp = (getMovieWBColorTemp_sdk) dlsym(handle, "XSDK_GetMovieWBColorTemp");
    sdk_capMediaRecord = (capMediaRecord_sdk) dlsym(handle, "XSDK_CapMediaRecord");
    sdk_setMediaRecord = (setMediaRecord_sdk) dlsym(handle, "XSDK_SetMediaRecord");
    sdk_getMediaRecord = (getMediaRecord_sdk) dlsym(handle, "XSDK_GetMediaRecord");
    sdk_capForceMode = (capForceMode_sdk) dlsym(handle, "XSDK_CapForceMode");
    sdk_setForceMode = (setForceMode_sdk) dlsym(handle, "XSDK_SetForceMode");
    sdk_capDriveMode = (capDriveMode_sdk) dlsym(handle, "XSDK_CapDriveMode");
    sdk_setDriveMode = (setDriveMode_sdk) dlsym(handle, "XSDK_SetDriveMode");
    sdk_getDriveMode = (getDriveMode_sdk) dlsym(handle, "XSDK_GetDriveMode");
    sdk_capMode = (capMode_sdk) dlsym(handle, "XSDK_CapMode");
    sdk_setMode = (setMode_sdk) dlsym(handle, "XSDK_SetMode");
    sdk_getMode = (getMode_sdk) dlsym(handle, "XSDK_GetMode");
    sdk_setBackupSettings = (setBackupSettings_sdk) dlsym(handle, "XSDK_SetBackupSettings");
    sdk_getBackupSettings = (getBackupSettings_sdk) dlsym(handle, "XSDK_GetBackupSettings");
    sdk_capProp = (capProp_sdk) dlsym(handle, "XSDK_CapProp");
    sdk_setProp = (setProp_sdk) dlsym(handle, "XSDK_SetProp");
    sdk_getProp = (getProp_sdk) dlsym(handle, "XSDK_GetProp");

    if (sdk_init == NULL||
        sdk_exit == NULL||
        sdk_setUSBDeviceHandle == NULL||
        sdk_close == NULL||
        sdk_powerOFF == NULL||
        sdk_getErrorNumber == NULL||
        sdk_getErrorDetails == NULL||
        sdk_getVersionString == NULL||
        sdk_getDeviceInfo == NULL||
        sdk_getDeviceInfoEx == NULL||
        sdk_writeDeviceName == NULL||
        sdk_getFirmwareVersion == NULL||
        sdk_getLensInfo == NULL||
        sdk_getLensVersion == NULL||
        sdk_capPriorityMode == NULL||
        sdk_setPriorityMode == NULL||
        sdk_getPriorityMode == NULL||
        sdk_capRelease == NULL||
        sdk_release == NULL||
        sdk_capReleaseEx == NULL||
        sdk_releaseEx == NULL||
        sdk_getReleaseStatus == NULL||
        sdk_getRecordingStatus == NULL||
        sdk_readImageInfo == NULL||
        sdk_readPreview == NULL||
        sdk_readImage == NULL||
        sdk_deleteImage == NULL||
        sdk_getBufferCapacity == NULL||
        sdk_capAEMode == NULL||
        sdk_setAEMode == NULL||
        sdk_getAEMode == NULL||
        sdk_capShutterSpeed == NULL||
        sdk_setShutterSpeed == NULL||
        sdk_getShutterSpeed == NULL||
        sdk_capExposureBias == NULL||
        sdk_setExposureBias == NULL||
        sdk_getExposureBias == NULL||
        sdk_capDynamicRange == NULL||
        sdk_setDynamicRange == NULL||
        sdk_getDynamicRange == NULL||
        sdk_capSensitivity == NULL||
        sdk_setSensitivity == NULL||
        sdk_getSensitivity == NULL||
        sdk_capMeteringMode == NULL||
        sdk_setMeteringMode == NULL||
        sdk_getMeteringMode == NULL||
        sdk_capLensZoomPos == NULL||
        sdk_setLensZoomPos == NULL||
        sdk_getLensZoomPos == NULL||
        sdk_capAperture == NULL||
        sdk_setAperture == NULL||
        sdk_getAperture == NULL||
        sdk_capWBMode == NULL||
        sdk_setWBMode == NULL||
        sdk_getWBMode == NULL||
        sdk_capWBColorTemp == NULL||
        sdk_setWBColorTemp == NULL||
        sdk_getWBColorTemp == NULL||
        sdk_capMovieShutterSpeed == NULL||
        sdk_setMovieShutterSpeed == NULL||
        sdk_getMovieShutterSpeed == NULL||
        sdk_capMovieExposureBias == NULL||
        sdk_setMovieExposureBias == NULL||
        sdk_getMovieExposureBias == NULL||
        sdk_capMovieSensitivity == NULL||
        sdk_setMovieSensitivity == NULL||
        sdk_getMovieSensitivity == NULL||
        sdk_capMovieAperture == NULL ||
        sdk_setMovieAperture == NULL ||
        sdk_getMovieAperture == NULL ||
        sdk_capMovieDynamicRange == NULL||
        sdk_setMovieDynamicRange == NULL||
        sdk_getMovieDynamicRange == NULL||
        sdk_capMovieMeteringMode == NULL||
        sdk_setMovieMeteringMode == NULL||
        sdk_getMovieMeteringMode == NULL||
        sdk_capMovieWBMode == NULL||
        sdk_setMovieWBMode == NULL||
        sdk_getMovieWBMode == NULL||
        sdk_capMovieWBColorTemp == NULL||
        sdk_setMovieWBColorTemp == NULL||
        sdk_getMovieWBColorTemp == NULL||
        sdk_capMediaRecord == NULL||
        sdk_setMediaRecord == NULL||
        sdk_getMediaRecord == NULL||
        sdk_capForceMode == NULL||
        sdk_setForceMode == NULL||
        sdk_capDriveMode == NULL||
        sdk_setDriveMode == NULL||
        sdk_getDriveMode == NULL||
        sdk_capMode == NULL||
        sdk_setMode == NULL||
        sdk_getMode == NULL||
        sdk_setBackupSettings == NULL||
        sdk_getBackupSettings == NULL||
        sdk_capProp == NULL||
        sdk_setProp == NULL||
        sdk_getProp == NULL
    ) {
        const char* dlsym_error = dlerror();
        dlclose(handle);
        return XSDK_APP_ERROR;
    }
    return XSDK_SUCCESS;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1Init(JNIEnv *env, jobject thiz) {
    long res = 0;
    try{
        res = sdk_init(0);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1Exit(JNIEnv *env, jobject thiz) {
    long res = 0;
    try{
        res = sdk_exit();
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetUSBDeviceHandle(JNIEnv *env, jobject thiz, jlong l_file_descriptor,
                                                                       jbyteArray pRawDescriptors, jobject ph_camera) {
    XSDK_HANDLE hCamera = 0;
    long res = 0;
    jboolean isCopy;
    try{
        jbyte* bufferPtr = env->GetByteArrayElements(pRawDescriptors, &isCopy);
        res = sdk_setUSBDeviceHandle(l_file_descriptor,
                                      reinterpret_cast<unsigned char *>(bufferPtr),
                                      &hCamera);
        env->ReleaseByteArrayElements(pRawDescriptors, bufferPtr, JNI_ABORT);
        if (res == XSDK_COMPLETE){
            long lCamera = 0;
            lCamera = (long)hCamera;
            jclass parentClass = env->GetObjectClass(ph_camera);
            Set_longTojlongFld(env, ph_camera, parentClass, "long", lCamera);
            env->DeleteLocalRef(parentClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1Close(JNIEnv *env, jobject thiz, jlong h_camera) {
    long res = 0;
    try{
        res = sdk_close((XSDK_HANDLE)h_camera);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1PowerOFF(JNIEnv *env, jobject thiz, jlong h_camera) {
    long res = 0;
    try{
        res = sdk_powerOFF((XSDK_HANDLE)h_camera);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetErrorNumber(JNIEnv *env, jobject thiz, jlong h_camera,
                                                                   jobject pl_apicode, jobject pl_errcode) {
    long lApiCode = 0;
    long lErrCode = 0;
    long res = 0;
    try{
        res = sdk_getErrorNumber((XSDK_HANDLE)h_camera, &lApiCode , &lErrCode);

        if (res == XSDK_COMPLETE){
            jclass apicodeClass = env->GetObjectClass(pl_apicode);
            Set_longTojlongFld(env, pl_apicode, apicodeClass, "long", lApiCode);
            env->DeleteLocalRef(apicodeClass);
            jclass errcodeClass = env->GetObjectClass(pl_errcode);
            Set_longTojlongFld(env, pl_errcode, errcodeClass, "long", lErrCode);
            env->DeleteLocalRef(errcodeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetErrorDetails(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_errcode) {
    long plError = 0;
    long res = 0;
    try{
        res = sdk_getErrorDetails((XSDK_HANDLE)h_camera, &plError);
        if (res == XSDK_COMPLETE){
            jclass errorClass = env->GetObjectClass(pl_errcode);
            Set_longTojlongFld(env, pl_errcode, errorClass, "long", plError);
            env->DeleteLocalRef(errorClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetVersionString(JNIEnv *env, jobject thiz,
                                                           jobject p_version_string) {
    char pVerStr[256];
    long res = 0;
    try{
        res = sdk_getVersionString(pVerStr);
        if (res == XSDK_COMPLETE){
            jclass versionClass = env->GetObjectClass(p_version_string);
            jfieldID strVendor = env->GetFieldID(versionClass, "string", "Ljava/lang/String;");
            jstring jStr = env->NewStringUTF(pVerStr);
            env->SetObjectField(p_version_string, strVendor, jStr);
            env->DeleteLocalRef(versionClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetDeviceInfo(JNIEnv *env, jobject thiz, jlong h_camera,
                                                   jobject p_devInfo) {
    XSDK_DeviceInformation pDevInfo;
    long res = 0;
    try{
        res = sdk_getDeviceInfo((XSDK_HANDLE)h_camera, &pDevInfo);
        if (res == XSDK_COMPLETE){
            jclass devInfoClass = env->GetObjectClass(p_devInfo);

            jfieldID strVendor = env->GetFieldID(devInfoClass, "strVendor", "Ljava/lang/String;");
            jfieldID strManufacturer = env->GetFieldID(devInfoClass, "strManufacturer", "Ljava/lang/String;");
            jfieldID strProduct = env->GetFieldID(devInfoClass, "strProduct", "Ljava/lang/String;");
            jfieldID strFirmware = env->GetFieldID(devInfoClass, "strFirmware", "Ljava/lang/String;");
            jfieldID strDeviceType = env->GetFieldID(devInfoClass, "strDeviceType", "Ljava/lang/String;");
            jfieldID strSerialNo = env->GetFieldID(devInfoClass, "strSerialNo", "Ljava/lang/String;");
            jfieldID strFramework = env->GetFieldID(devInfoClass, "strFramework", "Ljava/lang/String;");
            jfieldID bDeviceId = env->GetFieldID(devInfoClass, "bDeviceId", "B");
            jfieldID strDeviceName = env->GetFieldID(devInfoClass, "strDeviceName", "Ljava/lang/String;");
            jfieldID strYNo = env->GetFieldID(devInfoClass, "strYNo", "Ljava/lang/String;");

            jstring jstrVendor = env->NewStringUTF(pDevInfo.strVendor);
            jstring jstrManufacturer = env->NewStringUTF(pDevInfo.strManufacturer);
            jstring jstrProduct = env->NewStringUTF(pDevInfo.strProduct);
            jstring jstrFirmware = env->NewStringUTF(pDevInfo.strFirmware);
            jstring jstrDeviceType = env->NewStringUTF(pDevInfo.strDeviceType);
            jstring jstrSerialNo = env->NewStringUTF(pDevInfo.strSerialNo);
            jstring jstrFramework = env->NewStringUTF(pDevInfo.strFramework);
            jstring jstrDeviceName = env->NewStringUTF(pDevInfo.strDeviceName);
            jstring jstrYNo = env->NewStringUTF(pDevInfo.strYNo);

            env->SetObjectField(p_devInfo, strVendor, jstrVendor);
            env->SetObjectField(p_devInfo, strManufacturer, jstrManufacturer);
            env->SetObjectField(p_devInfo, strProduct, jstrProduct);
            env->SetObjectField(p_devInfo, strFirmware, jstrFirmware);
            env->SetObjectField(p_devInfo, strDeviceType, jstrDeviceType);
            env->SetObjectField(p_devInfo, strSerialNo, jstrSerialNo);
            env->SetObjectField(p_devInfo, strFramework, jstrFramework);
            env->SetByteField(p_devInfo, bDeviceId, (jbyte)pDevInfo.bDeviceId);
            env->SetObjectField(p_devInfo, strDeviceName, jstrDeviceName);
            env->SetObjectField(p_devInfo, strYNo, jstrYNo);

            env->DeleteLocalRef(jstrVendor);
            env->DeleteLocalRef(jstrManufacturer);
            env->DeleteLocalRef(jstrProduct);
            env->DeleteLocalRef(jstrFirmware);
            env->DeleteLocalRef(jstrDeviceType);
            env->DeleteLocalRef(jstrSerialNo);
            env->DeleteLocalRef(jstrFramework);
            env->DeleteLocalRef(jstrDeviceName);
            env->DeleteLocalRef(jstrYNo);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetDeviceInfoEx(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject p_dev_info,
                                                          jobject pl_num_apicode,
                                                          jlongArray pl_apicode) {
    XSDK_DeviceInformation pDevInfo;
    long numApi = 0;
    long res = 0;
    try{
        if (pl_apicode == NULL){
            res = sdk_getDeviceInfoEx((XSDK_HANDLE)h_camera, &pDevInfo, &numApi, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_apicode);
                Set_longTojlongFld(env, pl_num_apicode, numClass, "long", numApi);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_apicode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_apicode,lNum);
            long plApicode[num];
            long pNum = num;
            res = sdk_getDeviceInfoEx((XSDK_HANDLE)h_camera, &pDevInfo, &pNum, plApicode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_apicode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_apicode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plApicode[i];
                }
                env->ReleaseLongArrayElements(pl_apicode,jlongArray,0);

                jclass devInfoClass = env->GetObjectClass(p_dev_info);

                jfieldID strVendor = env->GetFieldID(devInfoClass, "strVendor", "Ljava/lang/String;");
                jfieldID strManufacturer = env->GetFieldID(devInfoClass, "strManufacturer", "Ljava/lang/String;");
                jfieldID strProduct = env->GetFieldID(devInfoClass, "strProduct", "Ljava/lang/String;");
                jfieldID strFirmware = env->GetFieldID(devInfoClass, "strFirmware", "Ljava/lang/String;");
                jfieldID strDeviceType = env->GetFieldID(devInfoClass, "strDeviceType", "Ljava/lang/String;");
                jfieldID strSerialNo = env->GetFieldID(devInfoClass, "strSerialNo", "Ljava/lang/String;");
                jfieldID strFramework = env->GetFieldID(devInfoClass, "strFramework", "Ljava/lang/String;");
                jfieldID bDeviceId = env->GetFieldID(devInfoClass, "bDeviceId", "B");
                jfieldID strDeviceName = env->GetFieldID(devInfoClass, "strDeviceName", "Ljava/lang/String;");
                jfieldID strYNo = env->GetFieldID(devInfoClass, "strYNo", "Ljava/lang/String;");

                jstring jstrVendor = env->NewStringUTF(pDevInfo.strVendor);
                jstring jstrManufacturer = env->NewStringUTF(pDevInfo.strManufacturer);
                jstring jstrProduct = env->NewStringUTF(pDevInfo.strProduct);
                jstring jstrFirmware = env->NewStringUTF(pDevInfo.strFirmware);
                jstring jstrDeviceType = env->NewStringUTF(pDevInfo.strDeviceType);
                jstring jstrSerialNo = env->NewStringUTF(pDevInfo.strSerialNo);
                jstring jstrFramework = env->NewStringUTF(pDevInfo.strFramework);
                jstring jstrDeviceName = env->NewStringUTF(pDevInfo.strDeviceName);
                jstring jstrYNo = env->NewStringUTF(pDevInfo.strYNo);

                env->SetObjectField(p_dev_info, strVendor, jstrVendor);
                env->SetObjectField(p_dev_info, strManufacturer, jstrManufacturer);
                env->SetObjectField(p_dev_info, strProduct, jstrProduct);
                env->SetObjectField(p_dev_info, strFirmware, jstrFirmware);
                env->SetObjectField(p_dev_info, strDeviceType, jstrDeviceType);
                env->SetObjectField(p_dev_info, strSerialNo, jstrSerialNo);
                env->SetObjectField(p_dev_info, strFramework, jstrFramework);
                env->SetByteField(p_dev_info, bDeviceId, (jbyte)pDevInfo.bDeviceId);
                env->SetObjectField(p_dev_info, strDeviceName, jstrDeviceName);
                env->SetObjectField(p_dev_info, strYNo, jstrYNo);

                env->DeleteLocalRef(jstrVendor);
                env->DeleteLocalRef(jstrManufacturer);
                env->DeleteLocalRef(jstrProduct);
                env->DeleteLocalRef(jstrFirmware);
                env->DeleteLocalRef(jstrDeviceType);
                env->DeleteLocalRef(jstrSerialNo);
                env->DeleteLocalRef(jstrFramework);
                env->DeleteLocalRef(jstrDeviceName);
                env->DeleteLocalRef(jstrYNo);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1WriteDeviceName(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jstring p_device_name) {
    long res = 0;
    try{
        const char* cstr = env->GetStringUTFChars(p_device_name, nullptr);
        res = sdk_writeDeviceName((XSDK_HANDLE)h_camera, const_cast<char*>(cstr));
        env->ReleaseStringUTFChars(p_device_name, cstr);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetFirmwareVersion(JNIEnv *env, jobject thiz,
                                                             jlong h_camera,
                                                             jobject p_firmware_version) {
    char pFirmwareStr[256];
    long res = 0;
    try{
        res = sdk_getFirmwareVersion((XSDK_HANDLE)h_camera, pFirmwareStr);
        if (res == XSDK_COMPLETE){
            jclass firmwareClass = env->GetObjectClass(p_firmware_version);
            jfieldID strVendor = env->GetFieldID(firmwareClass, "string", "Ljava/lang/String;");
            jstring jStr = env->NewStringUTF(pFirmwareStr);
            env->SetObjectField(p_firmware_version, strVendor, jStr);
            env->DeleteLocalRef(firmwareClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetLensInfo(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jobject p_lens_info) {
    XSDK_LensInformation pLensInfo;
    long res = 0;
    try{
        res = sdk_getLensInfo((XSDK_HANDLE)h_camera, &pLensInfo);
        if (res == XSDK_COMPLETE){
            jclass devInfoClass = env->GetObjectClass(p_lens_info);

            jfieldID strModel = env->GetFieldID(devInfoClass, "strModel", "Ljava/lang/String;");
            jfieldID strProductName = env->GetFieldID(devInfoClass, "strProductName", "Ljava/lang/String;");
            jfieldID strSerialNo = env->GetFieldID(devInfoClass, "strSerialNo", "Ljava/lang/String;");
            jfieldID lISCapability = env->GetFieldID(devInfoClass, "lISCapability", "J");
            jfieldID lMFCapability = env->GetFieldID(devInfoClass, "lMFCapability", "J");
            jfieldID lZoomPosCapability = env->GetFieldID(devInfoClass, "lZoomPosCapability", "J");

            jstring jstrModel = env->NewStringUTF(pLensInfo.strModel);
            jstring jstrProductName = env->NewStringUTF(pLensInfo.strProductName);
            jstring jstrSerialNo = env->NewStringUTF(pLensInfo.strSerialNo);

            env->SetObjectField(p_lens_info, strModel, jstrModel);
            env->SetObjectField(p_lens_info, strProductName, jstrProductName);
            env->SetObjectField(p_lens_info, strSerialNo, jstrSerialNo);
            env->SetLongField(p_lens_info, lISCapability, (jlong)pLensInfo.lISCapability);
            env->SetLongField(p_lens_info, lMFCapability, (jlong)pLensInfo.lMFCapability);
            env->SetLongField(p_lens_info, lZoomPosCapability, (jlong)pLensInfo.lZoomPosCapability);

            env->DeleteLocalRef(jstrModel);
            env->DeleteLocalRef(jstrProductName);
            env->DeleteLocalRef(jstrSerialNo);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetLensVersion(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject p_lens_version) {
    char pLensVer[256];
    long res = 0;
    try{
        res = sdk_getLensVersion((XSDK_HANDLE)h_camera, pLensVer);
        if (res == XSDK_COMPLETE){
            jclass lensVerClass = env->GetObjectClass(p_lens_version);
            jfieldID strVendor = env->GetFieldID(lensVerClass, "string", "Ljava/lang/String;");
            jstring jStr = env->NewStringUTF(pLensVer);
            env->SetObjectField(p_lens_version, strVendor, jStr);
            env->DeleteLocalRef(lensVerClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapPriorityMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_num_priority_mode,
                                                          jlongArray pl_priority_mode) {
    long plNumPriorityMode = 0;
    long res = 0;
    try{
        if (pl_priority_mode == NULL){
            res = sdk_capPriorityMode((XSDK_HANDLE)h_camera, &plNumPriorityMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_priority_mode);
                Set_longTojlongFld(env, pl_num_priority_mode, numClass, "long", plNumPriorityMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_priority_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_priority_mode,lNum);
            long plPriorityMode[num];
            long pNum = num;
            res = sdk_capPriorityMode((XSDK_HANDLE)h_camera, &pNum, plPriorityMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_priority_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_priority_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plPriorityMode[i];
                }
                env->ReleaseLongArrayElements(pl_priority_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetPriorityMode(JNIEnv *env, jobject thiz,
                                                     jlong h_camera,
                                                     jlong l_priority_mode) {
    long res = 0;
    try{
        res = sdk_setPriorityMode((XSDK_HANDLE)h_camera, (long)l_priority_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetPriorityMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject p_priority_mode) {
    long plPriority = 0;
    long res = 0;
    try{
        res = sdk_getPriorityMode((XSDK_HANDLE)h_camera, &plPriority);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(p_priority_mode);
            Set_longTojlongFld(env, p_priority_mode, modeClass, "long", plPriority);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapRelease(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jobject pl_num_release_mode,
                                                     jlongArray pl_release_mode) {
    long plNumReleaseMode = 0;
    long res = 0;
    try{
        if (pl_release_mode == NULL){
            res = sdk_capRelease((XSDK_HANDLE)h_camera, &plNumReleaseMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_release_mode);
                Set_longTojlongFld(env, pl_num_release_mode, numClass, "long", plNumReleaseMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_release_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_release_mode,lNum);
            long plReleaseMode[num];
            long pNum = num;
            res = sdk_capRelease((XSDK_HANDLE)h_camera, &pNum, plReleaseMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_release_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_release_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plReleaseMode[i];
                }
                env->ReleaseLongArrayElements(pl_release_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1Release(JNIEnv *env, jobject thiz, jlong h_camera,
                                                  jlong l_release_mode, jobject p_shot_opt,
                                                  jobject p_status) {
    long pShotOpt = 0;
    long pStatus = 0;
    long res = 0;
    try{
        res = sdk_release((XSDK_HANDLE)h_camera, (long)l_release_mode, &pShotOpt, &pStatus);
        if (res == XSDK_COMPLETE){
            jclass shotClass = env->GetObjectClass(p_shot_opt);
            Set_longTojlongFld(env, p_shot_opt, shotClass, "long", pShotOpt);
            env->DeleteLocalRef(shotClass);
            jclass statusClass = env->GetObjectClass(p_status);
            Set_longTojlongFld(env, p_status, statusClass, "long", pStatus);
            env->DeleteLocalRef(statusClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapReleaseEx(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jobject pl_num_release_mode,
                                                       jlongArray pl_release_mode) {
    long plNumReleaseMode = 0;
    long res = 0;
    try{
        if (pl_release_mode == NULL){
            res = sdk_capReleaseEx((XSDK_HANDLE)h_camera, &plNumReleaseMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_release_mode);
                Set_longTojlongFld(env, pl_num_release_mode, numClass, "long", plNumReleaseMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_release_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_release_mode,lNum);
            long plReleaseMode[num];
            long pNum = num;
            res = sdk_capReleaseEx((XSDK_HANDLE)h_camera, &pNum, plReleaseMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_release_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_release_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plReleaseMode[i];
                }
                env->ReleaseLongArrayElements(pl_release_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1ReleaseEx(JNIEnv *env, jobject thiz, jlong h_camera,
                                                        jlong ul_release_mode, jobject p_shot_opt,
                                                        jobject p_status) {
    long pShotOpt = 0;
    long pStatus = 0;
    long res = 0;
    try{
        res = sdk_releaseEx((XSDK_HANDLE)h_camera, (long)ul_release_mode, &pShotOpt, &pStatus);
        if (res == XSDK_COMPLETE){
            jclass shotClass = env->GetObjectClass(p_shot_opt);
            Set_longTojlongFld(env, p_shot_opt, shotClass, "long", pShotOpt);
            env->DeleteLocalRef(shotClass);
            jclass statusClass = env->GetObjectClass(p_status);
            Set_longTojlongFld(env, p_status, statusClass, "long", pStatus);
            env->DeleteLocalRef(statusClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetReleaseStatus(JNIEnv *env, jobject thiz,
                                                           jlong h_camera,
                                                           jobject pl_release_status) {
    long plReleaseStatus = 0;
    long res = 0;
    try{
        res = sdk_getReleaseStatus((XSDK_HANDLE)h_camera, &plReleaseStatus);
        if (res == XSDK_COMPLETE){
            jclass releaseStatusClass = env->GetObjectClass(pl_release_status);
            Set_longTojlongFld(env, pl_release_status, releaseStatusClass, "long", plReleaseStatus);
            env->DeleteLocalRef(releaseStatusClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetRecordingStatus(JNIEnv *env, jobject thiz,
                                                             jlong h_camera, jobject pl_status) {
    long plStatus = 0;
    long res = 0;
    try{
        res = sdk_getRecordingStatus((XSDK_HANDLE)h_camera, &plStatus);
        if (res == XSDK_COMPLETE){
            jclass statusClass = env->GetObjectClass(pl_status);
            Set_longTojlongFld(env, pl_status, statusClass, "long", plStatus);
            env->DeleteLocalRef(statusClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1ReadImageInfo(JNIEnv *env, jobject thiz, jlong h_camera,
                                                                  jobject p_img_info_array) {
    XSDK_ImageInformation pImageInfo;
    long res = 0;
    try{
        res = sdk_readImageInfo((XSDK_HANDLE)h_camera, &pImageInfo);
        if (res == XSDK_COMPLETE){
            jclass imgInfoClass = env->GetObjectClass(p_img_info_array);

            jfieldID strInternalName = env->GetFieldID(imgInfoClass, "strInternalName", "Ljava/lang/String;");
            jfieldID lFormat = env->GetFieldID(imgInfoClass, "lFormat", "J");
            jfieldID lDataSize = env->GetFieldID(imgInfoClass, "lDataSize", "J");
            jfieldID lImagePixHeight = env->GetFieldID(imgInfoClass, "lImagePixHeight", "J");
            jfieldID lImagePixWidth = env->GetFieldID(imgInfoClass, "lImagePixWidth", "J");
            jfieldID lImageBitDepth = env->GetFieldID(imgInfoClass, "lImageBitDepth", "J");
            jfieldID lPreviewSize = env->GetFieldID(imgInfoClass, "lPreviewSize", "J");
            jfieldID hImage = env->GetFieldID(imgInfoClass, "hImage", "J");

            jstring jstrBufInt = env->NewStringUTF(pImageInfo.strInternalName);

            env->SetObjectField(p_img_info_array, strInternalName, jstrBufInt);
            env->SetLongField(p_img_info_array, lFormat, (jlong)pImageInfo.lFormat);
            env->SetLongField(p_img_info_array, lDataSize, (jlong)pImageInfo.lDataSize);
            env->SetLongField(p_img_info_array, lImagePixWidth, (jlong)pImageInfo.lImagePixWidth);
            env->SetLongField(p_img_info_array, lImagePixHeight, (jlong)pImageInfo.lImagePixHeight);
            env->SetLongField(p_img_info_array, lImageBitDepth, (jlong)pImageInfo.lImageBitDepth);
            env->SetLongField(p_img_info_array, lPreviewSize, (jlong)pImageInfo.lPreviewSize);
            env->SetLongField(p_img_info_array, hImage, reinterpret_cast<jlong>(pImageInfo.hImage));

            env->DeleteLocalRef(jstrBufInt);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }

    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1ReadPreview(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jbyteArray p_data, jlong data_size) {
    long res = 0;
    try{
        unsigned char* pImageData = new unsigned char[data_size];
        res = sdk_readPreview((XSDK_HANDLE)h_camera, pImageData, data_size);
        if (res == XSDK_COMPLETE) {
            jbyte *jbyteArray = env->GetByteArrayElements(p_data,0);
            for (int i = 0; i < data_size; i++) {
                jbyteArray[i] = (jbyte)pImageData[i];
            }
            env->ReleaseByteArrayElements(p_data, jbyteArray, 0);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1ReadImage(JNIEnv *env, jobject thiz,
                                                              jlong h_camera, jbyteArray p_data,
                                                              jlong data_size) {
    long res = 0;
    try{
        unsigned char* pImageData = new unsigned char[data_size];
        res = sdk_readImage((XSDK_HANDLE)h_camera, pImageData, data_size);
        if (res == XSDK_COMPLETE) {
            jbyte *jbyteArray = env->GetByteArrayElements(p_data,0);
            for (int i = 0; i < data_size; i++) {
                jbyteArray[i] = (jbyte)pImageData[i];
            }
            env->ReleaseByteArrayElements(p_data, jbyteArray, 0);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1DeleteImage(JNIEnv *env, jobject thiz,
                                                                jlong h_camera) {
    long res = 0;
    try{
        res = sdk_deleteImage((XSDK_HANDLE)h_camera);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetBufferCapacity(JNIEnv *env, jobject thiz,
                                                            jlong h_camera,
                                                            jobject p_shoot_frame_num,
                                                            jobject pl_total_frame_num) {
    long plShoot = 0;
    long plTotal = 0;
    long res = 0;
    try{
        res = sdk_getBufferCapacity((XSDK_HANDLE)h_camera, &plShoot, &plTotal);
        if (res == XSDK_COMPLETE){
            jclass shootClass = env->GetObjectClass(p_shoot_frame_num);
            Set_longTojlongFld(env, p_shoot_frame_num, shootClass, "long", plShoot);
            env->DeleteLocalRef(shootClass);
            jclass totalClass = env->GetObjectClass(pl_total_frame_num);
            Set_longTojlongFld(env, pl_total_frame_num, totalClass, "long", plTotal);
            env->DeleteLocalRef(totalClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapAEMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_num_aemode, jlongArray pl_aemode) {
    long plNum = 0;
    long res = 0;
    try{
        if (pl_aemode == NULL){
            res = sdk_capAEMode((XSDK_HANDLE)h_camera, &plNum, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_aemode);
                Set_longTojlongFld(env, pl_num_aemode, numClass, "long", plNum);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_aemode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_aemode,lNum);
            long plAEMode[num];
            long pNum = num;
            res = sdk_capAEMode((XSDK_HANDLE)h_camera, &pNum, plAEMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_aemode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_aemode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plAEMode[i];
                }
                env->ReleaseLongArrayElements(pl_aemode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetAEMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jlong l_aemode) {
    long res = 0;
    try{
        res = sdk_setAEMode((XSDK_HANDLE)h_camera, (long)l_aemode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetAEMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_aemode) {
    long plAEMode = 0;
    long res = 0;
    try{
        res = sdk_getAEMode((XSDK_HANDLE)h_camera, &plAEMode);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_aemode);
            Set_longTojlongFld(env, pl_aemode, modeClass, "long", plAEMode);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapShutterSpeed(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_num_shutter_speed,
                                                          jlongArray pl_shutter_speed,
                                                          jobject pl_bulb_capable) {
    long plNum = 0;
    long plBulb = 0;
    long res = 0;
    try{
        if (pl_shutter_speed == NULL){
            res = sdk_capShutterSpeed((XSDK_HANDLE)h_camera, &plNum, NULL, &plBulb);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_shutter_speed);
                Set_longTojlongFld(env, pl_num_shutter_speed, numClass, "long", plNum);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_shutter_speed);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_shutter_speed,lNum);
            jlong bulb = env->GetLongField(pl_bulb_capable,lNum);
            long plShutter[num];
            long pNum = num;
            long pBulb = bulb;
            res = sdk_capShutterSpeed((XSDK_HANDLE)h_camera, &pNum, plShutter, &pBulb);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_shutter_speed, numClass, "long", num);
                Set_longTojlongFld(env, pl_bulb_capable, numClass, "long", bulb);
                env->DeleteLocalRef(numClass);
                jlong *shutterArray = env->GetLongArrayElements(pl_shutter_speed,0);
                for (int i = 0; i < pNum; i++) {
                    shutterArray[i] = (jlong) plShutter[i];
                }
                env->ReleaseLongArrayElements(pl_shutter_speed,shutterArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetShutterSpeed(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jlong l_shutter_speed, jlong l_bulb) {
    long res = 0;
    try{
        res = sdk_setShutterSpeed((XSDK_HANDLE)h_camera, (long)l_shutter_speed, (long)l_bulb);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetShutterSpeed(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_shutter_speed,
                                                          jobject pl_bulb) {
    long plShutter = 0;
    long plBulb = 0;
    long res = 0;
    try{
        res = sdk_getShutterSpeed((XSDK_HANDLE)h_camera, &plShutter ,&plBulb);
        if (res == XSDK_COMPLETE){
            jclass shutterClass = env->GetObjectClass(pl_shutter_speed);
            Set_longTojlongFld(env, pl_shutter_speed, shutterClass, "long", plShutter);
            env->DeleteLocalRef(shutterClass);
            jclass bulbClass = env->GetObjectClass(pl_bulb);
            Set_longTojlongFld(env, pl_bulb, bulbClass, "long", plBulb);
            env->DeleteLocalRef(bulbClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapExposureBias(JNIEnv *env, jobject thiz,
                                                                    jlong h_camera,
                                                                    jobject pl_num_exposure_bias,
                                                                    jlongArray pl_exposure_bias) {
    long plNumExposure = 0;
    long res = 0;
    try{
        if (pl_exposure_bias == NULL){
            res = sdk_capExposureBias((XSDK_HANDLE)h_camera, &plNumExposure, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_exposure_bias);
                Set_longTojlongFld(env, pl_num_exposure_bias, numClass, "long", plNumExposure);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_exposure_bias);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_exposure_bias,lNum);
            long plExposure[num];
            long pNum = num;
            res = sdk_capExposureBias((XSDK_HANDLE)h_camera, &pNum, plExposure);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_exposure_bias, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_exposure_bias,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plExposure[i];
                }
                env->ReleaseLongArrayElements(pl_exposure_bias,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetExposureBias(JNIEnv *env, jobject thiz,
                                                                    jlong h_camera,
                                                                    jlong l_exposure_bias) {
    long res = 0;
    try{
        res = sdk_setExposureBias((XSDK_HANDLE)h_camera, (long)l_exposure_bias);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetExposureBias(JNIEnv *env, jobject thiz,
                                                                    jlong h_camera,
                                                                    jobject pl_exposure_bias) {
    long plExposure = 0;
    long res = 0;
    try{
        res = sdk_getExposureBias((XSDK_HANDLE)h_camera, &plExposure);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_exposure_bias);
            Set_longTojlongFld(env, pl_exposure_bias, modeClass, "long", plExposure);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapDynamicRange(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_num_dynamic_range,
                                                          jlongArray pl_dynamic_range) {
    long plNumRange = 0;
    long res = 0;
    try{
        if (pl_dynamic_range == NULL){
            res = sdk_capDynamicRange((XSDK_HANDLE)h_camera, &plNumRange, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_dynamic_range);
                Set_longTojlongFld(env, pl_num_dynamic_range, numClass, "long", plNumRange);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_dynamic_range);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_dynamic_range,lNum);
            long plRange[num];
            long pNum = num;
            res = sdk_capDynamicRange((XSDK_HANDLE)h_camera, &pNum, plRange);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_dynamic_range, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_dynamic_range,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plRange[i];
                }
                env->ReleaseLongArrayElements(pl_dynamic_range,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetDynamicRange(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jlong l_dynamic_range) {
    long res = 0;
    try{
        res = sdk_setDynamicRange((XSDK_HANDLE)h_camera, (long)l_dynamic_range);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetDynamicRange(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_dynamic_range) {
    long plRange = 0;
    long res = 0;
    try{
        res = sdk_getDynamicRange((XSDK_HANDLE)h_camera, &plRange);
        if (res == XSDK_COMPLETE){
            jclass rangeClass = env->GetObjectClass(pl_dynamic_range);
            Set_longTojlongFld(env, pl_dynamic_range, rangeClass, "long", plRange);
            env->DeleteLocalRef(rangeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapSensitivity(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_num_sensitivity,
                                                         jlongArray pl_sensitivity) {
    long plNumSensitivity = 0;
    long res = 0;
    try{
        if (pl_sensitivity == NULL){
            res = sdk_capSensitivity((XSDK_HANDLE)h_camera, &plNumSensitivity, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_sensitivity);
                Set_longTojlongFld(env, pl_num_sensitivity, numClass, "long", plNumSensitivity);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_sensitivity);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_sensitivity,lNum);
            long plSensitivity[num];
            long pNum = num;
            res = sdk_capSensitivity((XSDK_HANDLE)h_camera, &pNum, plSensitivity);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_sensitivity, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_sensitivity,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plSensitivity[i];
                }
                env->ReleaseLongArrayElements(pl_sensitivity,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetSensitivity(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_sensitivity) {
    long res = 0;
    try{
        res = sdk_setSensitivity((XSDK_HANDLE)h_camera, (long)l_sensitivity);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetSensitivity(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_sensitivity) {
    long plSensitivity = 0;
    long res = 0;
    try{
        res = sdk_getSensitivity((XSDK_HANDLE)h_camera, &plSensitivity);
        if (res == XSDK_COMPLETE){
            jclass rangeClass = env->GetObjectClass(pl_sensitivity);
            Set_longTojlongFld(env, pl_sensitivity, rangeClass, "long", plSensitivity);
            env->DeleteLocalRef(rangeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMeteringMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_num_metering_mode,
                                                          jlongArray pl_metering_mode) {
    long plNumMeteringMode = 0;
    long res = 0;
    try{
        if (pl_metering_mode == NULL){
            res = sdk_capMeteringMode((XSDK_HANDLE)h_camera, &plNumMeteringMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_metering_mode);
                Set_longTojlongFld(env, pl_num_metering_mode, numClass, "long", plNumMeteringMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_metering_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_metering_mode,lNum);
            long plMeteringMode[num];
            long pNum = num;
            res = sdk_capMeteringMode((XSDK_HANDLE)h_camera, &pNum, plMeteringMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_metering_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_metering_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMeteringMode[i];
                }
                env->ReleaseLongArrayElements(pl_metering_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMeteringMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jlong l_metering_mode) {
    long res = 0;
    try{
        res = sdk_setMeteringMode((XSDK_HANDLE)h_camera, (long)l_metering_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMeteringMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                          jobject pl_metering_mode) {
    long plMeteringMode = 0;
    long res = 0;
    try{
        res = sdk_getMeteringMode((XSDK_HANDLE)h_camera, &plMeteringMode);
        if (res == XSDK_COMPLETE){
            jclass rangeClass = env->GetObjectClass(pl_metering_mode);
            Set_longTojlongFld(env, pl_metering_mode, rangeClass, "long", plMeteringMode);
            env->DeleteLocalRef(rangeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapLensZoomPos(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_num_zoom_pos, jlongArray pl_zoom_pos,
                                                    jlongArray pl_focus_length,
                                                    jlongArray pl35mm_focus_length) {
    long plNumZoomPos = 0;
    long res = 0;
    try{
        if (pl_zoom_pos == NULL || pl_focus_length == NULL || pl35mm_focus_length == NULL){
            res = sdk_capLensZoomPos((XSDK_HANDLE)h_camera, &plNumZoomPos, NULL, NULL, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_zoom_pos);
                Set_longTojlongFld(env, pl_num_zoom_pos, numClass, "long", plNumZoomPos);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_zoom_pos);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_zoom_pos,lNum);
            long plZoomPos[num];
            long plFocusLength[num];
            long pl35mmFocusLength[num];
            long pNum = num;
            res = sdk_capLensZoomPos((XSDK_HANDLE)h_camera, &pNum, plZoomPos, plFocusLength, pl35mmFocusLength);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_zoom_pos, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jZoomPosArray = env->GetLongArrayElements(pl_zoom_pos,0);
                for (int i = 0; i < pNum; i++) {
                    jZoomPosArray[i] = (jlong)plZoomPos[i];
                }
                jlong *jFocusLengthArray = env->GetLongArrayElements(pl_focus_length,0);
                for (int i = 0; i < pNum; i++) {
                    jFocusLengthArray[i] = (jlong)plFocusLength[i];
                }
                jlong *j35mmFocusLength = env->GetLongArrayElements(pl35mm_focus_length,0);
                for (int i = 0; i < pNum; i++) {
                    j35mmFocusLength[i] = (jlong)pl35mmFocusLength[i];
                }
                env->ReleaseLongArrayElements(pl_zoom_pos,jZoomPosArray,0);
                env->ReleaseLongArrayElements(pl_focus_length,jFocusLengthArray,0);
                env->ReleaseLongArrayElements(pl35mm_focus_length,j35mmFocusLength,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetLensZoomPos(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_zoom_pos) {
    long res = 0;
    try{
        res = sdk_setLensZoomPos((XSDK_HANDLE)h_camera, (long)l_zoom_pos);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetLensZoomPos(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_zoom_pos) {
    long plZoomPos = 0;
    long res = 0;
    try{
        res = sdk_getLensZoomPos((XSDK_HANDLE)h_camera, &plZoomPos);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_zoom_pos);
            Set_longTojlongFld(env, pl_zoom_pos, modeClass, "long", plZoomPos);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapAperture(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jlong l_zoom_pos, jobject pl_num_aperture,
                                                      jlongArray pl_fnumber) {
    long plNumAperture = 0;
    long res = 0;
    try{
        if (pl_fnumber == NULL){
            res = sdk_capAperture((XSDK_HANDLE)h_camera, (long)l_zoom_pos, &plNumAperture, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_aperture);
                Set_longTojlongFld(env, pl_num_aperture, numClass, "long", plNumAperture);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_aperture);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_aperture,lNum);
            long plFNumber[num];
            long pNum = num;
            res = sdk_capAperture((XSDK_HANDLE)h_camera, (long)l_zoom_pos, &pNum, plFNumber);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_aperture, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_fnumber,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plFNumber[i];
                }
                env->ReleaseLongArrayElements(pl_fnumber,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetAperture(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jlong l_fnumber) {
    long res = 0;
    try{
        res = sdk_setAperture((XSDK_HANDLE)h_camera, (long)l_fnumber);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetAperture(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jobject pl_fnumber) {
    long plFNumber = 0;
    long res = 0;
    try{
        res = sdk_getAperture((XSDK_HANDLE)h_camera, &plFNumber);
        if (res == XSDK_COMPLETE){
            jclass fnumberClass = env->GetObjectClass(pl_fnumber);
            Set_longTojlongFld(env, pl_fnumber, fnumberClass, "long", plFNumber);
            env->DeleteLocalRef(fnumberClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_num_wbmode, jlongArray pl_wbmode) {
    long plNumWBMode = 0;
    long res = 0;
    try{
        if (pl_wbmode == NULL){
            res = sdk_capWBMode((XSDK_HANDLE)h_camera, &plNumWBMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_wbmode);
                Set_longTojlongFld(env, pl_num_wbmode, numClass, "long", plNumWBMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_wbmode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_wbmode,lNum);
            long plWBMode[num];
            long pNum = num;
            res = sdk_capWBMode((XSDK_HANDLE)h_camera, &pNum, plWBMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_wbmode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_wbmode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plWBMode[i];
                }
                env->ReleaseLongArrayElements(pl_wbmode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jlong l_wbmode) {
    long res = 0;
    try{
        res = sdk_setWBMode((XSDK_HANDLE)h_camera, (long)l_wbmode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                    jobject pl_wbmode) {
    long plWBMode = 0;
    long res = 0;
    try{
        res = sdk_getWBMode((XSDK_HANDLE)h_camera, &plWBMode);
        if (res == XSDK_COMPLETE){
            jclass wbmodeClass = env->GetObjectClass(pl_wbmode);
            Set_longTojlongFld(env, pl_wbmode, wbmodeClass, "long", plWBMode);
            env->DeleteLocalRef(wbmodeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapWBColorTemp(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_num_wbcolor_temp,
                                                         jlongArray pl_wbcolor_temp) {
    long plNumWBColorTemp = 0;
    long res = 0;
    try{
        if (pl_wbcolor_temp == NULL){
            res = sdk_capWBColorTemp((XSDK_HANDLE)h_camera, &plNumWBColorTemp, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_wbcolor_temp);
                Set_longTojlongFld(env, pl_num_wbcolor_temp, numClass, "long", plNumWBColorTemp);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_wbcolor_temp);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_wbcolor_temp,lNum);
            long plWBColorTemp[num];
            long pNum = num;
            res = sdk_capWBColorTemp((XSDK_HANDLE)h_camera, &pNum, plWBColorTemp);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_wbcolor_temp, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_wbcolor_temp,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plWBColorTemp[i];
                }
                env->ReleaseLongArrayElements(pl_wbcolor_temp,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetWBColorTemp(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_color_temp) {
    long res = 0;
    try{
        res = sdk_setWBColorTemp((XSDK_HANDLE)h_camera, (long)l_color_temp);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetWBColorTemp(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_color_temp) {
    long plWBColorTemp = 0;
    long res = 0;
    try{
        res = sdk_getWBColorTemp((XSDK_HANDLE)h_camera, &plWBColorTemp);
        if (res == XSDK_COMPLETE){
            jclass colorTempClass = env->GetObjectClass(pl_color_temp);
            Set_longTojlongFld(env, pl_color_temp, colorTempClass, "long", plWBColorTemp);
            env->DeleteLocalRef(colorTempClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieShutterSpeed(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_num_shutter_speed,
                                                               jlongArray pll_shutter_speed) {
    long plNumMovieShutterSpeed = 0;
    long res = 0;
    try{
        if (pll_shutter_speed == NULL){
            res = sdk_capMovieShutterSpeed((XSDK_HANDLE)h_camera, &plNumMovieShutterSpeed, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_shutter_speed);
                Set_longTojlongFld(env, pl_num_shutter_speed, numClass, "long", plNumMovieShutterSpeed);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_shutter_speed);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_shutter_speed,lNum);
            long long plWBColorTemp[num];
            long pNum = num;
            res = sdk_capMovieShutterSpeed((XSDK_HANDLE)h_camera, &pNum, plWBColorTemp);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_shutter_speed, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pll_shutter_speed,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plWBColorTemp[i];
                }
                env->ReleaseLongArrayElements(pll_shutter_speed,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieShutterSpeed(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jlong ll_shutter_speed) {
    long res = 0;
    try{
        res = sdk_setMovieShutterSpeed((XSDK_HANDLE)h_camera, (long long)ll_shutter_speed);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieShutterSpeed(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pll_shutter_speed) {
    long long plMovieShutterSpeed = 0;
    long res = 0;
    try{
        res = sdk_getMovieShutterSpeed((XSDK_HANDLE)h_camera, &plMovieShutterSpeed);
        if (res == XSDK_COMPLETE){
            jclass shutterClass = env->GetObjectClass(pll_shutter_speed);
            Set_longTojlongFld(env, pll_shutter_speed, shutterClass, "long", plMovieShutterSpeed);
            env->DeleteLocalRef(shutterClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieExposureBias(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_num_exposure_bias,
                                                               jlongArray pl_exposure_bias) {
    long plNumMovieExposureBias = 0;
    long res = 0;
    try{
        if (pl_exposure_bias == NULL){
            res = sdk_capMovieExposureBias((XSDK_HANDLE)h_camera, &plNumMovieExposureBias, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_exposure_bias);
                Set_longTojlongFld(env, pl_num_exposure_bias, numClass, "long", plNumMovieExposureBias);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_exposure_bias);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_exposure_bias,lNum);
            long plMovieExposureBias[num];
            long pNum = num;
            res = sdk_capMovieExposureBias((XSDK_HANDLE)h_camera, &pNum, plMovieExposureBias);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_exposure_bias, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_exposure_bias,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieExposureBias[i];
                }
                env->ReleaseLongArrayElements(pl_exposure_bias,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieExposureBias(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jlong l_exposure_bias) {
    long res = 0;
    try{
        res = sdk_setMovieExposureBias((XSDK_HANDLE)h_camera, (long)l_exposure_bias);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieExposureBias(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_exposure_bias) {
    long plMovieExposureBias = 0;
    long res = 0;
    try{
        res = sdk_getMovieExposureBias((XSDK_HANDLE)h_camera, &plMovieExposureBias);
        if (res == XSDK_COMPLETE){
            jclass exposureClass = env->GetObjectClass(pl_exposure_bias);
            Set_longTojlongFld(env, pl_exposure_bias, exposureClass, "long", plMovieExposureBias);
            env->DeleteLocalRef(exposureClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieSensitivity(JNIEnv *env, jobject thiz,
                                                              jlong h_camera,
                                                              jobject pl_num_sensitivity,
                                                              jlongArray pl_sensitivity) {
    long plNumMovieSensitivity = 0;
    long res = 0;
    try{
        if (pl_sensitivity == NULL){
            res = sdk_capMovieSensitivity((XSDK_HANDLE)h_camera, &plNumMovieSensitivity, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_sensitivity);
                Set_longTojlongFld(env, pl_num_sensitivity, numClass, "long", plNumMovieSensitivity);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_sensitivity);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_sensitivity,lNum);
            long plMovieSensitivity[num];
            long pNum = num;
            res = sdk_capMovieSensitivity((XSDK_HANDLE)h_camera, &pNum, plMovieSensitivity);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_sensitivity, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_sensitivity,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieSensitivity[i];
                }
                env->ReleaseLongArrayElements(pl_sensitivity,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieSensitivity(JNIEnv *env, jobject thiz,
                                                              jlong h_camera, jlong l_sensitivity) {
    long res = 0;
    try{
        res = sdk_setMovieSensitivity((XSDK_HANDLE)h_camera, (long)l_sensitivity);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieSensitivity(JNIEnv *env, jobject thiz,
                                                              jlong h_camera,
                                                              jobject pl_sensitivity) {
    long plMovieSensitivity = 0;
    long res = 0;
    try{
        res = sdk_getMovieSensitivity((XSDK_HANDLE)h_camera, &plMovieSensitivity);
        if (res == XSDK_COMPLETE){
            jclass sensitivityClass = env->GetObjectClass(pl_sensitivity);
            Set_longTojlongFld(env, pl_sensitivity, sensitivityClass, "long", plMovieSensitivity);
            env->DeleteLocalRef(sensitivityClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieAperture(JNIEnv *env, jobject thiz,
                                                           jlong h_camera, jobject pl_num_aperture,
                                                           jlongArray pl_fnumber) {
    long plNumMovieAperture = 0;
    long res = 0;
    try{
        if (pl_fnumber == NULL){
            res = sdk_capMovieAperture((XSDK_HANDLE)h_camera, &plNumMovieAperture, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_aperture);
                Set_longTojlongFld(env, pl_num_aperture, numClass, "long", plNumMovieAperture);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_aperture);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_aperture,lNum);
            long plMovieFNumber[num];
            long pNum = num;
            res = sdk_capMovieAperture((XSDK_HANDLE)h_camera, &pNum, plMovieFNumber);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_aperture, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_fnumber,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieFNumber[i];
                }
                env->ReleaseLongArrayElements(pl_fnumber,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieAperture(JNIEnv *env, jobject thiz,
                                                           jlong h_camera, jlong l_fnumber) {
    long res = 0;
    try{
        res = sdk_setMovieAperture((XSDK_HANDLE)h_camera, (long)l_fnumber);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieAperture(JNIEnv *env, jobject thiz,
                                                           jlong h_camera, jobject pl_fnumber) {
    long plMovieFNumber = 0;
    long res = 0;
    try{
        res = sdk_getMovieAperture((XSDK_HANDLE)h_camera, &plMovieFNumber);
        if (res == XSDK_COMPLETE){
            jclass fnumberClass = env->GetObjectClass(pl_fnumber);
            Set_longTojlongFld(env, pl_fnumber, fnumberClass, "long", plMovieFNumber);
            env->DeleteLocalRef(fnumberClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieDynamicRange(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_num_dynamic_range,
                                                               jlongArray pl_dynamic_range) {
    long plNumMovieDynamicRange = 0;
    long res = 0;
    try{
        if (pl_dynamic_range == NULL){
            res = sdk_capMovieDynamicRange((XSDK_HANDLE)h_camera, &plNumMovieDynamicRange, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_dynamic_range);
                Set_longTojlongFld(env, pl_num_dynamic_range, numClass, "long", plNumMovieDynamicRange);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_dynamic_range);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_dynamic_range,lNum);
            long plMovieDynamicRange[num];
            long pNum = num;
            res = sdk_capMovieDynamicRange((XSDK_HANDLE)h_camera, &pNum, plMovieDynamicRange);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_dynamic_range, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_dynamic_range,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieDynamicRange[i];
                }
                env->ReleaseLongArrayElements(pl_dynamic_range,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieDynamicRange(JNIEnv *env, jobject thiz,
                                                               jlong h_camera, jlong l_dynamic_range) {
    long res = 0;
    try{
        res = sdk_setMovieDynamicRange((XSDK_HANDLE)h_camera, (long)l_dynamic_range);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieDynamicRange(JNIEnv *env, jobject thiz,
                                                               jlong h_camera, jobject pl_dynamic_range) {
    long plMovieDynamicRange = 0;
    long res = 0;
    try{
        res = sdk_getMovieDynamicRange((XSDK_HANDLE)h_camera, &plMovieDynamicRange);
        if (res == XSDK_COMPLETE){
            jclass rangeClass = env->GetObjectClass(pl_dynamic_range);
            Set_longTojlongFld(env, pl_dynamic_range, rangeClass, "long", plMovieDynamicRange);
            env->DeleteLocalRef(rangeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieMeteringMode(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_num_metering_mode,
                                                               jlongArray pl_metering_mode) {
    long plNumMovieMeteringMode = 0;
    long res = 0;
    try{
        if (pl_metering_mode == NULL){
            res = sdk_capMovieMeteringMode((XSDK_HANDLE)h_camera, &plNumMovieMeteringMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_metering_mode);
                Set_longTojlongFld(env, pl_num_metering_mode, numClass, "long", plNumMovieMeteringMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_metering_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_metering_mode,lNum);
            long plMovieMeteringMode[num];
            long pNum = num;
            res = sdk_capMovieMeteringMode((XSDK_HANDLE)h_camera, &pNum, plMovieMeteringMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_metering_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_metering_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieMeteringMode[i];
                }
                env->ReleaseLongArrayElements(pl_metering_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieMeteringMode(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jlong l_metering_mode) {
    long res = 0;
    try{
        res = sdk_setMovieMeteringMode((XSDK_HANDLE)h_camera, (long)l_metering_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieMeteringMode(JNIEnv *env, jobject thiz,
                                                               jlong h_camera,
                                                               jobject pl_metering_mode) {
    long plMovieMeteringMode = 0;
    long res = 0;
    try{
        res = sdk_getMovieMeteringMode((XSDK_HANDLE)h_camera, &plMovieMeteringMode);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_metering_mode);
            Set_longTojlongFld(env, pl_metering_mode, modeClass, "long", plMovieMeteringMode);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_num_wbmode,
                                                         jlongArray pl_wbmode) {
    long plNumMovieWBMode = 0;
    long res = 0;
    try{
        if (pl_wbmode == NULL){
            res = sdk_capMovieWBMode((XSDK_HANDLE)h_camera, &plNumMovieWBMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_wbmode);
                Set_longTojlongFld(env, pl_num_wbmode, numClass, "long", plNumMovieWBMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_wbmode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_wbmode,lNum);
            long plMovieWBMode[num];
            long pNum = num;
            res = sdk_capMovieWBMode((XSDK_HANDLE)h_camera, &pNum, plMovieWBMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_wbmode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_wbmode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieWBMode[i];
                }
                env->ReleaseLongArrayElements(pl_wbmode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_wbmode) {
    long res = 0;
    try{
        res = sdk_setMovieWBMode((XSDK_HANDLE)h_camera, (long)l_wbmode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieWBMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_wbmode) {
    long plMovieWBMode = 0;
    long res = 0;
    try{
        res = sdk_getMovieWBMode((XSDK_HANDLE)h_camera, &plMovieWBMode);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_wbmode);
            Set_longTojlongFld(env, pl_wbmode, modeClass, "long", plMovieWBMode);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMovieWBColorTemp(JNIEnv *env, jobject thiz,
                                                              jlong h_camera,
                                                              jobject pl_num_wbcolor_temp,
                                                              jlongArray pl_wbcolor_temp) {
    long plNumMovieWBColorTemp = 0;
    long res = 0;
    try{
        if (pl_wbcolor_temp == NULL){
            res = sdk_capMovieWBColorTemp((XSDK_HANDLE)h_camera, &plNumMovieWBColorTemp, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_wbcolor_temp);
                Set_longTojlongFld(env, pl_num_wbcolor_temp, numClass, "long", plNumMovieWBColorTemp);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_wbcolor_temp);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_wbcolor_temp,lNum);
            long plMovieWBColorTemp[num];
            long pNum = num;
            res = sdk_capMovieWBColorTemp((XSDK_HANDLE)h_camera, &pNum, plMovieWBColorTemp);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_wbcolor_temp, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_wbcolor_temp,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMovieWBColorTemp[i];
                }
                env->ReleaseLongArrayElements(pl_wbcolor_temp,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMovieWBColorTemp(JNIEnv *env, jobject thiz,
                                                              jlong h_camera, jlong l_color_temp) {
    long res = 0;
    try{
        res = sdk_setMovieWBColorTemp((XSDK_HANDLE)h_camera, (long)l_color_temp);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMovieWBColorTemp(JNIEnv *env, jobject thiz,
                                                              jlong h_camera,
                                                              jobject pl_color_temp) {
    long plMovieWBColorTemp = 0;
    long res = 0;
    try{
        res = sdk_getMovieWBColorTemp((XSDK_HANDLE)h_camera, &plMovieWBColorTemp);
        if (res == XSDK_COMPLETE){
            jclass colorClass = env->GetObjectClass(pl_color_temp);
            Set_longTojlongFld(env, pl_color_temp, colorClass, "long", plMovieWBColorTemp);
            env->DeleteLocalRef(colorClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMediaRecord(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_num_media_record,
                                                         jlongArray pl_media_record) {
    long plNumMediaRecord = 0;
    long res = 0;
    try{
        if (pl_media_record == NULL){
            res = sdk_capMediaRecord((XSDK_HANDLE)h_camera, &plNumMediaRecord, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_media_record);
                Set_longTojlongFld(env, pl_num_media_record, numClass, "long", plNumMediaRecord);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_media_record);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_media_record,lNum);
            long plMediaRecord[num];
            long pNum = num;
            res = sdk_capMediaRecord((XSDK_HANDLE)h_camera, &pNum, plMediaRecord);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_media_record, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_media_record,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMediaRecord[i];
                }
                env->ReleaseLongArrayElements(pl_media_record,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMediaRecord(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_media_record) {
    long res = 0;
    try{
        res = sdk_setMediaRecord((XSDK_HANDLE)h_camera, (long)l_media_record);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMediaRecord(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jobject pl_media_record) {
    long plMediaRecord = 0;
    long res = 0;
    try{
        res = sdk_getMediaRecord((XSDK_HANDLE)h_camera, &plMediaRecord);
        if (res == XSDK_COMPLETE){
            jclass recordClass = env->GetObjectClass(pl_media_record);
            Set_longTojlongFld(env, pl_media_record, recordClass, "long", plMediaRecord);
            env->DeleteLocalRef(recordClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapForceMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jobject pl_num_standby_mode,
                                                       jlongArray pl_force_shoot_standby) {
    long plNumForceMode = 0;
    long res = 0;
    try{
        if (pl_force_shoot_standby == NULL){
            res = sdk_capForceMode((XSDK_HANDLE)h_camera, &plNumForceMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num_standby_mode);
                Set_longTojlongFld(env, pl_num_standby_mode, numClass, "long", plNumForceMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num_standby_mode);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num_standby_mode,lNum);
            long plForceMode[num];
            long pNum = num;
            res = sdk_capForceMode((XSDK_HANDLE)h_camera, &pNum, plForceMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num_standby_mode, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_force_shoot_standby,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plForceMode[i];
                }
                env->ReleaseLongArrayElements(pl_force_shoot_standby,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetForceMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong pl_mode) {
    long res = 0;
    try{
        res = sdk_setForceMode((XSDK_HANDLE)h_camera, (long)pl_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapDriveMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jobject pl_num, jlongArray pl_drive_mode) {
    long plNumDriveMode = 0;
    long res = 0;
    try{
        if (pl_drive_mode == NULL){
            res = sdk_capDriveMode((XSDK_HANDLE)h_camera, &plNumDriveMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num);
                Set_longTojlongFld(env, pl_num, numClass, "long", plNumDriveMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num,lNum);
            long plDriveMode[num];
            long pNum = num;
            res = sdk_capDriveMode((XSDK_HANDLE)h_camera, &pNum, plDriveMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_drive_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plDriveMode[i];
                }
                env->ReleaseLongArrayElements(pl_drive_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetDriveMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong l_drive_mode) {
    long res = 0;
    try{
        res = sdk_setDriveMode((XSDK_HANDLE)h_camera, (long)l_drive_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetDriveMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                  jobject pl_drive_mode) {
    long plDriveMode = 0;
    long res = 0;
    try{
        res = sdk_getDriveMode((XSDK_HANDLE)h_camera, &plDriveMode);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_drive_mode);
            Set_longTojlongFld(env, pl_drive_mode, modeClass, "long", plDriveMode);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                  jobject pl_num, jlongArray pl_mode) {
    long plNumMode = 0;
    long res = 0;
    try{
        if (pl_mode == NULL){
            res = sdk_capMode((XSDK_HANDLE)h_camera, &plNumMode, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_num);
                Set_longTojlongFld(env, pl_num, numClass, "long", plNumMode);
                env->DeleteLocalRef(numClass);
            }
        } else {
            jclass numClass = env->GetObjectClass(pl_num);
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_num,lNum);
            long plMode[num];
            long pNum = num;
            res = sdk_capMode((XSDK_HANDLE)h_camera, &pNum, plMode);
            if (res == XSDK_COMPLETE){
                Set_longTojlongFld(env, pl_num, numClass, "long", num);
                env->DeleteLocalRef(numClass);
                jlong *jlongArray = env->GetLongArrayElements(pl_mode,0);
                for (int i = 0; i < pNum; i++) {
                    jlongArray[i] = (jlong) plMode[i];
                }
                env->ReleaseLongArrayElements(pl_mode,jlongArray,0);
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                  jlong l_mode) {
    long res = 0;
    try{
        res = sdk_setMode((XSDK_HANDLE)h_camera, (long)l_mode);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetMode(JNIEnv *env, jobject thiz, jlong h_camera,
                                                  jobject pl_mode) {
    long plMode = 0;
    long res = 0;
    try{
        res = sdk_getDriveMode((XSDK_HANDLE)h_camera, &plMode);
        if (res == XSDK_COMPLETE){
            jclass modeClass = env->GetObjectClass(pl_mode);
            Set_longTojlongFld(env, pl_mode, modeClass, "long", plMode);
            env->DeleteLocalRef(modeClass);
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetBackupSettings(JNIEnv *env, jobject thiz,
                                                            jlong h_camera, jlong l_size,
                                                            jbyteArray p_backup) {
    long res = 0;
    try{
        jbyte* byteArray = env->GetByteArrayElements(p_backup, NULL);
        res = sdk_setBackupSettings((XSDK_HANDLE)h_camera, (long)l_size, reinterpret_cast<unsigned char*>(byteArray));
        env->ReleaseByteArrayElements(p_backup, byteArray, 0);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetBackupSettings(JNIEnv *env, jobject thiz,
                                                            jlong h_camera, jobject pl_size,
                                                            jbyteArray p_backup) {
    long pSize = 0;
    long res = 0;
    try{
        if (p_backup == NULL) {
            res = sdk_getBackupSettings((XSDK_HANDLE)h_camera, &pSize, NULL);
            if (res == XSDK_COMPLETE){
                jclass numClass = env->GetObjectClass(pl_size);
                Set_longTojlongFld(env, pl_size, numClass, "long", pSize);
                env->DeleteLocalRef(numClass);
            }
        }else{
            jclass numClass = env->GetObjectClass(pl_size);
            if (env->IsInstanceOf(pl_size, numClass) == JNI_FALSE) {
                return XSDK_APP_ERROR;
            }
            jfieldID lNum = env->GetFieldID(numClass, "long", "J");
            jlong num = env->GetLongField(pl_size,lNum);
            long pNum = num;
            unsigned char* pBackup = new unsigned char[num];
            res = sdk_getBackupSettings((XSDK_HANDLE)h_camera, &pNum, pBackup);
            if (res == XSDK_COMPLETE) {
                jbyte *jbyteArray = env->GetByteArrayElements(p_backup,0);
                for (int i = 0; i < pNum; i++) {
                    jbyteArray[i] = (jbyte)pBackup[i];
                }
                env->ReleaseByteArrayElements(p_backup, jbyteArray, 0);
                Set_longTojlongFld(env, pl_size, numClass, "long", pNum);
                env->DeleteLocalRef(numClass);
            }
            delete[] pBackup;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp(JNIEnv *env, jobject thiz,
                                                      jlong h_camera, jlong l_apicode,
                                                      jlong l_apiparam) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1L(JNIEnv *env, jobject thiz,
                                                         jlong h_camera, jlong l_apicode,
                                                         jlong l_apiparam, jlong param1) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, param1);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LL(JNIEnv *env, jobject thiz,
                                                          jlong h_camera, jlong l_apicode,
                                                          jlong l_apiparam, jlong param1, jlong param2) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LLL(JNIEnv *env, jobject thiz,
                                                      jlong h_camera, jlong l_apicode,
                                                      jlong l_apiparam, jlong param1, jlong param2, jlong param3) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2, (long)param3);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LLLLL(JNIEnv *env, jobject thiz,
                                                       jlong h_camera, jlong l_apicode,
                                                       jlong l_apiparam, jlong param1, jlong param2,
                                                       jlong param3, jlong param4, jlong param5) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2, (long)param3, (long)param4, (long)param5);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LLLLLL(JNIEnv *env, jobject thiz,
                                                         jlong h_camera, jlong l_apicode,
                                                         jlong l_apiparam, jlong param1, jlong param2,
                                                         jlong param3, jlong param4, jlong param5, jlong param6) {
    long res = 0;
    try{
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2, (long)param3, (long)param4, (long)param5, (long)param6);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1P(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jobject param1) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2167:{
                SDK_FaceFrameInfo pVoid;

                jclass faceFrameInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FaceFrameInfo");
                if (env->IsInstanceOf(param1, faceFrameInfoClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }

                jfieldID lID = env->GetFieldID(faceFrameInfoClass, "lID", "J");
                jfieldID lTime = env->GetFieldID(faceFrameInfoClass, "lTime", "J");
                jfieldID lX = env->GetFieldID(faceFrameInfoClass, "lX", "J");
                jfieldID lY = env->GetFieldID(faceFrameInfoClass, "lY", "J");
                jfieldID lLength_H = env->GetFieldID(faceFrameInfoClass, "lLength_H", "J");
                jfieldID lLength_V = env->GetFieldID(faceFrameInfoClass, "lLength_V", "J");
                jfieldID lColorR = env->GetFieldID(faceFrameInfoClass, "lColorR", "J");
                jfieldID lColorG = env->GetFieldID(faceFrameInfoClass, "lColorG", "J");
                jfieldID lColorB = env->GetFieldID(faceFrameInfoClass, "lColorB", "J");
                jfieldID lAlpha = env->GetFieldID(faceFrameInfoClass, "lAlpha", "J");
                jfieldID lType = env->GetFieldID(faceFrameInfoClass, "lType", "J");
                jfieldID lLikeness = env->GetFieldID(faceFrameInfoClass, "lLikeness", "J");
                jfieldID lDisp = env->GetFieldID(faceFrameInfoClass, "lDisp", "J");
                jfieldID lSelected = env->GetFieldID(faceFrameInfoClass, "lSelected", "J");

                pVoid.lID = env->GetLongField(param1, lID);
                pVoid.lTime = env->GetLongField(param1, lTime);
                pVoid.lX = env->GetLongField(param1, lX);
                pVoid.lY = env->GetLongField(param1, lY);
                pVoid.lLength_H = env->GetLongField(param1, lLength_H);
                pVoid.lLength_V = env->GetLongField(param1, lLength_V);
                pVoid.lColorR = env->GetLongField(param1, lColorR);
                pVoid.lColorG = env->GetLongField(param1, lColorG);
                pVoid.lColorB = env->GetLongField(param1, lColorB);
                pVoid.lAlpha = env->GetLongField(param1, lAlpha);
                pVoid.lType = env->GetLongField(param1, lType);
                pVoid.lLikeness = env->GetLongField(param1, lLikeness);
                pVoid.lDisp = env->GetLongField(param1, lDisp);
                pVoid.lSelected = env->GetLongField(param1, lSelected);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, pVoid);
                break;
            }
            case 0x362C:{
                SDK_MOVIE_AFC_CUSTOM pVoid;
                jclass afcClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_MOVIE_AFC_CUSTOM");
                if (env->IsInstanceOf(param1, afcClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                jfieldID lTracking = env->GetFieldID(afcClass, "lTracking", "J");
                jfieldID lSpeed = env->GetFieldID(afcClass, "lSpeed", "J");
                pVoid.lTracking = env->GetLongField(param1, lTracking);
                pVoid.lSpeed = env->GetLongField(param1, lSpeed);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, pVoid);
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}


extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jlong param1,jobject param2) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2205:
            case 0x2214:{
                SDK_FocusArea pVoid;
                jclass focusAreaClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FocusArea");
                if (env->IsInstanceOf(param2, focusAreaClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                jfieldID h = env->GetFieldID(focusAreaClass, "h", "J");
                jfieldID v = env->GetFieldID(focusAreaClass, "v", "J");
                jfieldID size = env->GetFieldID(focusAreaClass, "size", "J");
                pVoid.h = env->GetLongField(param2, h);
                pVoid.v = env->GetLongField(param2, v);
                pVoid.size = env->GetLongField(param2, size);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, pVoid);
                break;
            }
            case 0x2288:{
                SDK_AFZoneCustomCapablity pVoid;
                jclass zoneCapablityClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustomCapablity");
                jclass zoneClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom");
                if (env->IsInstanceOf(param2, zoneCapablityClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                jfieldID mode = env->GetFieldID(zoneCapablityClass, "mode", "J");
                jfieldID min = env->GetFieldID(zoneCapablityClass, "min", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");
                jfieldID max = env->GetFieldID(zoneCapablityClass, "max", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");
                jfieldID h = env->GetFieldID(zoneClass, "h", "J");
                jfieldID v = env->GetFieldID(zoneClass, "v", "J");

                jobject minObject = env->GetObjectField(param2, min);
                jobject maxObject = env->GetObjectField(param2, max);

                pVoid.mode = env->GetLongField(param2, mode);
                pVoid.min.h = env->GetLongField(minObject, h);
                pVoid.min.v = env->GetLongField(minObject, v);
                pVoid.max.h = env->GetLongField(maxObject, h);
                pVoid.min.v = env->GetLongField(maxObject, v);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, pVoid);
                break;
            }
            case 0x2353:
            case 0x2357:{
                SDK_CustomWBArea pVoid;
                jclass customWBAreaClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_CustomWBArea");
                if (env->IsInstanceOf(param2, customWBAreaClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                jfieldID lX = env->GetFieldID(customWBAreaClass, "lX", "J");
                jfieldID lY = env->GetFieldID(customWBAreaClass, "lY", "J");
                jfieldID lSize = env->GetFieldID(customWBAreaClass, "lSize", "J");
                jfieldID lMode = env->GetFieldID(customWBAreaClass, "lMode", "J");

                pVoid.lX = env->GetLongField(param2, lX);
                pVoid.lY = env->GetLongField(param2, lY);
                pVoid.lSize = env->GetLongField(param2, lSize);
                pVoid.lMode = env->GetLongField(param2, lMode);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, pVoid);
                break;
            }
            case 0x4211:{
                SDK_FrameGuideGridInfo pVoid;
                jclass frameGuideGridInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FrameGuideGridInfo");
                if (env->IsInstanceOf(param2, frameGuideGridInfoClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                jfieldID lGridH = env->GetFieldID(frameGuideGridInfoClass, "lGridH", "[J");
                jfieldID lGridV = env->GetFieldID(frameGuideGridInfoClass, "lGridV", "[J");
                jfieldID lLineWidthH = env->GetFieldID(frameGuideGridInfoClass, "lLineWidthH", "J");
                jfieldID lLineWidthV = env->GetFieldID(frameGuideGridInfoClass, "lLineWidthV", "J");
                jfieldID lLineColorIndex = env->GetFieldID(frameGuideGridInfoClass, "lLineColorIndex", "J");
                jfieldID lLineAlpha = env->GetFieldID(frameGuideGridInfoClass, "lLineAlpha", "J");

                jlongArray jlGridH = (jlongArray)env->GetObjectField(param2, lGridH);
                jlongArray jlGridV = (jlongArray)env->GetObjectField(param2, lGridV);
                jlong *clGridH = env->GetLongArrayElements(jlGridH, nullptr);
                jlong *clGridV = env->GetLongArrayElements(jlGridV, nullptr);

                for(jsize i = 0; i < 5; i++){
                    pVoid.lGridH[i] = clGridH[i];
                    pVoid.lGridV[i] = clGridV[i];
                }

                pVoid.lLineWidthH = env->GetLongField(param2, lLineWidthH);
                pVoid.lLineWidthV = env->GetLongField(param2, lLineWidthV);
                pVoid.lLineColorIndex = env->GetLongField(param2, lLineColorIndex);
                pVoid.lLineAlpha = env->GetLongField(param2, lLineAlpha);

                res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, pVoid);

                env->ReleaseLongArrayElements(jlGridH,clGridH,0);
                env->ReleaseLongArrayElements(jlGridV,clGridV,0);

                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LS(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jlong l_apicode, jlong l_apiparam,
                                                      jlong param1, jstring param2) {
    long res = XSDK_APP_ERROR;
    try{
        const char* cstr2 = env->GetStringUTFChars(param2, nullptr);
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, const_cast<char*>(cstr2));
        env->ReleaseStringUTFChars(param2, cstr2);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1LSL(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jlong l_apicode, jlong l_apiparam,
                                                      jlong param1, jstring param2, jlong param3) {
    long res = XSDK_APP_ERROR;
    try{
        const char* cstr2 = env->GetStringUTFChars(param2, nullptr);
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, const_cast<char*>(cstr2), (long)param3);
        env->ReleaseStringUTFChars(param2, cstr2);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1S(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jstring param1) {
    long res = XSDK_APP_ERROR;
    try{
        const char* cstr = env->GetStringUTFChars(param1, nullptr);
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, const_cast<char*>(cstr));
        env->ReleaseStringUTFChars(param1, cstr);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1SetProp_1SS(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jstring param1, jstring param2) {
    long res = XSDK_APP_ERROR;
    try{
        const char* cstr1 = env->GetStringUTFChars(param1, nullptr);
        const char* cstr2 = env->GetStringUTFChars(param2, nullptr);
        res = sdk_setProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, const_cast<char*>(cstr1), const_cast<char*>(cstr2));
        env->ReleaseStringUTFChars(param1, cstr1);
        env->ReleaseStringUTFChars(param2, cstr2);
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1P(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jobject param1) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2269: {
                SDK_CropAreaFrameInfo par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass cropAreaFrameInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_CropAreaFrameInfo");
                    if (env->IsInstanceOf(param1, cropAreaFrameInfoClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lX", par1.lX);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lY", par1.lY);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lLength_H", par1.lLength_H);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lLength_V", par1.lLength_V);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lColorR", par1.lColorR);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lColorG", par1.lColorG);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lColorB", par1.lColorB);
                    Set_longTojlongFld(env, param1, cropAreaFrameInfoClass, "lAlpha", par1.lAlpha);
                }
                break;
            }
            case 0x226B: {
                SDK_FOCUS_LIMITER_INDICATOR par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass focusIndicatorInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FOCUS_LIMITER_INDICATOR");
                    if (env->IsInstanceOf(param1, focusIndicatorInfoClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lCurrent", par1.lCurrent);
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lDOF_Near", par1.lDOF_Near);
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lDOF_Far", par1.lDOF_Far);
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lPos_A", par1.lPos_A);
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lPos_B", par1.lPos_B);
                    Set_longTojlongFld(env, param1, focusIndicatorInfoClass, "lStatus", par1.lStatus);
                }
                break;
            }
            case 0x228A: {
                SDK_TrackingAfFrameInfo par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass trackingAfFrameInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_TrackingAfFrameInfo");
                    if (env->IsInstanceOf(param1, trackingAfFrameInfoClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lX", par1.lX);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lY", par1.lY);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lLength_H", par1.lLength_H);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lLength_V", par1.lLength_V);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lColorR", par1.lColorR);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lColorG", par1.lColorG);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lColorB", par1.lColorB);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lAlpha", par1.lAlpha);
                }
                break;
            }
            case 0x357B: {
                SDK_MovieTransparentFrameInfo par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass trackingAfFrameInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_MovieTransparentFrameInfo");
                    if (env->IsInstanceOf(param1, trackingAfFrameInfoClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lX", par1.lX);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lY", par1.lY);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lLength_H", par1.lLength_H);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lLength_V", par1.lLength_V);
                    Set_longTojlongFld(env, param1, trackingAfFrameInfoClass, "lAlpha", par1.lAlpha);
                }
                break;
            }
            case 0x362D: {
                SDK_MOVIE_AFC_CUSTOM par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass afcClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_MOVIE_AFC_CUSTOM");
                    if (env->IsInstanceOf(param1, afcClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, afcClass, "lTracking", par1.lTracking);
                    Set_longTojlongFld(env, param1, afcClass, "lSpeed", par1.lSpeed);
                }
                break;
            }
            case 0x3922: {
                SDK_MICLEVEL_INDICATOR par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass afcClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_MICLEVEL_INDICATOR");
                    if (env->IsInstanceOf(param1, afcClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, afcClass, "lDSC_L_Peak", par1.lDSC_L_Peak);
                    Set_longTojlongFld(env, param1, afcClass, "lDSC_L_PeakHold", par1.lDSC_L_PeakHold);
                    Set_longTojlongFld(env, param1, afcClass, "lDSC_R_Peak", par1.lDSC_R_Peak);
                    Set_longTojlongFld(env, param1, afcClass, "lDSC_R_PeakHold", par1.lDSC_R_PeakHold);
                    Set_longTojlongFld(env, param1, afcClass, "lXLR_1_Peak", par1.lXLR_1_Peak);
                    Set_longTojlongFld(env, param1, afcClass, "lXLR_1_PeakHold", par1.lXLR_1_PeakHold);
                    Set_longTojlongFld(env, param1, afcClass, "lXLR_2_Peak", par1.lXLR_2_Peak);
                    Set_longTojlongFld(env, param1, afcClass, "lXLR_2_PeakHold", par1.lXLR_2_PeakHold);
                    Set_longTojlongFld(env, param1, afcClass, "lWarning1", par1.lWarning1);
                    Set_longTojlongFld(env, param1, afcClass, "lWarning2", par1.lWarning2);
                    Set_longTojlongFld(env, param1, afcClass, "lMicLine", par1.lMicLine);
                }
                break;
            }
            case 0x4044:
            case 0x407E:{
                char par1[256];
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass strClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKString");
                    if (env->IsInstanceOf(param1, strClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jstringID = env->GetFieldID(strClass, "string", "Ljava/lang/String;");
                    jstring jStr = env->NewStringUTF(par1);
                    env->SetObjectField(param1, jstringID, jStr);
                    env->DeleteLocalRef(strClass);
                }
                break;
            }
            default :{
                long par1;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, &par1);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1LP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                     jlong l_apicode, jlong l_apiparam,
                                                     jlong param1, jobject param2) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2206:
            case 0x2215: {
                SDK_FocusArea par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass focusAreaClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FocusArea");
                    if (env->IsInstanceOf(param2, focusAreaClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, focusAreaClass, "h", par2.h);
                    Set_longTojlongFld(env, param2, focusAreaClass, "v", par2.v);
                    Set_longTojlongFld(env, param2, focusAreaClass, "size", par2.size);
                }
                break;
            }
            case 0x2289: {
                SDK_AFZoneCustomCapablity par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass capablityClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustomCapablity");
                    jclass zoneClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom");
                    if (env->IsInstanceOf(param2, capablityClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID min = env->GetFieldID(capablityClass, "min", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");
                    jfieldID max = env->GetFieldID(capablityClass, "max", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");

                    jobject minObject = env->GetObjectField(param2, min);
                    jobject maxObject = env->GetObjectField(param2, max);

                    Set_longTojlongFld(env, param2, capablityClass, "mode", par2.mode);
                    Set_longTojlongFld(env, minObject, zoneClass, "h", par2.min.h);
                    Set_longTojlongFld(env, minObject, zoneClass, "v", par2.min.v);
                    Set_longTojlongFld(env, maxObject, zoneClass, "h", par2.max.h);
                    Set_longTojlongFld(env, maxObject, zoneClass, "v", par2.max.v);

                    env->DeleteLocalRef(minObject);
                    env->DeleteLocalRef(maxObject);
                }
                break;
            }
            case 0x2354:
            case 0x2358: {
                SDK_CustomWBArea par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass customWBAreaClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_CustomWBArea");
                    if (env->IsInstanceOf(param2, customWBAreaClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }

                    Set_longTojlongFld(env, param2, customWBAreaClass, "lX", par2.lX);
                    Set_longTojlongFld(env, param2, customWBAreaClass, "lY", par2.lY);
                    Set_longTojlongFld(env, param2, customWBAreaClass, "lSize", par2.lSize);
                    Set_longTojlongFld(env, param2, customWBAreaClass, "lMode", par2.lMode);
                }
                break;
            }
            case 0x4048: {
                char par2[256];
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass strClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKString");
                    if (env->IsInstanceOf(param2, strClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jstringID = env->GetFieldID(strClass, "string", "Ljava/lang/String;");
                    jstring jStr = env->NewStringUTF(par2);
                    env->SetObjectField(param2, jstringID, jStr);
                    env->DeleteLocalRef(strClass);
                }
                break;
            }
            case 0x4212: {
                SDK_FrameGuideGridInfo par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass frameGuideGridInfoClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FrameGuideGridInfo");
                    if (env->IsInstanceOf(param2, frameGuideGridInfoClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }

                    jfieldID lGridH = env->GetFieldID(frameGuideGridInfoClass, "lGridH", "[J");
                    jfieldID lGridV = env->GetFieldID(frameGuideGridInfoClass, "lGridV", "[J");

                    jlongArray jlGridH = (jlongArray)env->GetObjectField(param2, lGridH);
                    jlongArray jlGridV = (jlongArray)env->GetObjectField(param2, lGridV);
                    jlong *clGridH = env->GetLongArrayElements(jlGridH, nullptr);
                    jlong *clGridV = env->GetLongArrayElements(jlGridV, nullptr);

                    for(jsize i = 0; i < 5; i++){
                        clGridH[i] = par2.lGridH[i];
                        clGridV[i] = par2.lGridV[i];
                    }
                    Set_longTojlongFld(env, param2, frameGuideGridInfoClass, "lLineWidthH", par2.lLineWidthH);
                    Set_longTojlongFld(env, param2, frameGuideGridInfoClass, "lLineWidthV", par2.lLineWidthV);
                    Set_longTojlongFld(env, param2, frameGuideGridInfoClass, "lLineColorIndex", par2.lLineColorIndex);
                    Set_longTojlongFld(env, param2, frameGuideGridInfoClass, "lLineAlpha", par2.lLineAlpha);

                    env->ReleaseLongArrayElements(jlGridH,clGridH,0);
                    env->ReleaseLongArrayElements(jlGridV,clGridV,0);
                }
                break;
            }
            case 0x427A: {
                SDK_PlayBackObjectInformation par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass playBackObjectClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_PlayBackObjectInformation");
                    if (env->IsInstanceOf(param2, playBackObjectClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }

                    jfieldID strFileName = env->GetFieldID(playBackObjectClass, "strFileName", "Ljava/lang/String;");
                    jfieldID strcapturedata = env->GetFieldID(playBackObjectClass, "strcapturedata", "Ljava/lang/String;");

                    Set_longTojlongFld(env, param2, playBackObjectClass, "lFormat", par2.lFormat);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "llDataSize", par2.llDataSize);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "lThumbSize", par2.lThumbSize);
                    env->SetObjectField(param2, strFileName, (jstring)par2.strFileName);
                    env->SetObjectField(param2, strcapturedata, (jstring)par2.strcapturedata);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "lImagePixHeight", par2.lImagePixHeight);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "lImagePixWidth", par2.lImagePixWidth);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "lImageBitDepth", par2.lImageBitDepth);
                    Set_longTojlongFld(env, param2, playBackObjectClass, "Duration", par2.Duration);
                }
                break;
            }
            default : {
                long par2;
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1LLP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                      jlong l_apicode, jlong l_apiparam,
                                                      jlong param1, jlong param2, jobject param3) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x427B: {
                jbyte* byteBuffer = env->GetByteArrayElements((jbyteArray)param3, nullptr);
                if (byteBuffer == nullptr) {
                    return XSDK_APP_ERROR;
                }
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2, &byteBuffer);
                if (res == XSDK_COMPLETE){
                    env->ReleaseByteArrayElements((jbyteArray)param3, byteBuffer, 0);
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1LLLPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_apicode, jlong l_apiparam,
                                                         jlong param1, jlong param2, jlong param3, jobject param4, jobject param5) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x427C: {
                jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                if (env->IsInstanceOf(param4, longClass) == JNI_FALSE) {
                    return XSDK_APP_ERROR;
                }
                long par4 = env->GetLongField(param4, jlong);
                jbyte* byteBuffer = env->GetByteArrayElements((jbyteArray)param5, nullptr);
                if (byteBuffer == nullptr) {
                    return XSDK_APP_ERROR;
                }
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, (long)param1, (long)param2, (long)param3, &par4, &byteBuffer);
                if (res == XSDK_COMPLETE){
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                    env->ReleaseByteArrayElements((jbyteArray)param5, byteBuffer, 0);
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1LPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong l_apicode, jlong l_apiparam,
                                                       jlong param1, jobject param2, jobject param3) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2305:
            case 0x3603: {
                long par2;
                long par3;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, &par3);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE || env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                }
                break;
            }
            case 0x4075: {
                char par2[256];
                long par3;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, &par3);
                if (res == XSDK_COMPLETE){
                    jclass strClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKString");
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, strClass) == JNI_FALSE || env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jstringID = env->GetFieldID(strClass, "string", "Ljava/lang/String;");
                    jstring jStr = env->NewStringUTF(par2);
                    env->SetObjectField(param2, jstringID, jStr);
                    env->DeleteLocalRef(strClass);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                }
                break;
            }
            case 0x4279: {
                if (param3 == NULL){
                    long par2 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num = env->GetLongField(param2,lNum);
                    long plArray[num];
                    long pNum = num;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &pNum, &plArray);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param2, longClass, "long", pNum);
                        jlong* jlArray = env->GetLongArrayElements((jlongArray)param3,0);
                        for (int i = 0; i < pNum; i++) {
                            jlArray[i] = (jlong)plArray[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param3,jlArray,0);
                    }
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1LPPPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong l_apicode, jlong l_apiparam,
                                                       jlong param1, jobject param2,
                                                       jobject param3, jobject param4, jobject param5) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x4068: {
                long par2;
                long par3;
                long par4;
                long par5;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, &par3, &par4, &par5);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param4, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param5, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                    Set_longTojlongFld(env, param5, longClass, "long", par5);
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}


extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PP(JNIEnv *env, jobject thiz,
                                                      jlong h_camera, jlong l_apicode,
                                                      jlong l_apiparam, jobject param1,
                                                      jobject param2) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x355A:
            case 0x355B:
            case 0x355C: {
                if (param2 == NULL) {
                    long par1 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass byteArrayClass = env->FindClass("[B");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, byteArrayClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    long pNum = par1;
                    unsigned char* pByteBuffer = new unsigned char[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, pByteBuffer);
                    if (res == XSDK_COMPLETE) {
                        jbyte* byteBuffer = env->GetByteArrayElements((jbyteArray)param2, nullptr);
                        for (int i = 0; i < pNum; i++) {
                            byteBuffer[i] = (jbyte)pByteBuffer[i];
                        }
                        env->ReleaseByteArrayElements((jbyteArray)param2, byteBuffer, 0);
                        Set_longTojlongFld(env, param1, longClass, "long", pNum);
                        env->DeleteLocalRef(longClass);
                    }
                    delete[] pByteBuffer;
                }
                break;
            }
            case 0x2166: {
                if (param2 == NULL) {
                    long par1 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass faceFrameInfoClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_FaceFrameInfo;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, faceFrameInfoClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    SDK_FaceFrameInfo par2[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, par2);
                    if (res == XSDK_COMPLETE) {
                        for (jsize i = 0; i < par1; i++) {
                            jobject faceFrameInfo = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass faceFrameInfoClass = env->GetObjectClass(faceFrameInfo);

                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lID", par2[i].lID);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lTime", par2[i].lTime);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lX", par2[i].lX);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lY", par2[i].lY);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lLength_H", par2[i].lLength_H);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lLength_V", par2[i].lLength_V);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lColorR", par2[i].lColorR);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lColorG", par2[i].lColorG);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lColorB", par2[i].lColorB);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lAlpha", par2[i].lAlpha);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lType", par2[i].lType);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lLikeness", par2[i].lLikeness);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lDisp", par2[i].lDisp);
                            Set_longTojlongFld(env, faceFrameInfo, faceFrameInfoClass, "lSelected", par2[i].lSelected);

                            env->DeleteLocalRef(faceFrameInfoClass);
                            env->DeleteLocalRef(faceFrameInfo);
                        }

                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                }
                break;
            }
            case 0x226C: {
                if (param2 == NULL) {
                    long par1 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass faceLimiterClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_FOCUS_LIMITER;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, faceLimiterClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    SDK_FOCUS_LIMITER par2[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, par2);
                    if (res == XSDK_COMPLETE) {
                        for (jsize i = 0; i < par1; i++) {
                            jobject faceLimiter = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass faceLimiterClass = env->GetObjectClass(faceLimiter);

                            Set_longTojlongFld(env, faceLimiter, faceLimiterClass, "lPos_A", par2[i].lPos_A);
                            Set_longTojlongFld(env, faceLimiter, faceLimiterClass, "lPos_B", par2[i].lPos_B);

                            env->DeleteLocalRef(faceLimiterClass);
                            env->DeleteLocalRef(faceLimiter);
                        }

                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                }
                break;
            }
            case 0x3555: {
                if (param2 == NULL) {
                    long par1 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam,&par1, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass histogramDataClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_HistogramData;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, histogramDataClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    SDK_HistogramData par2[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, par2);
                    if (res == XSDK_COMPLETE) {
                        for (jsize i = 0; i < par1; i++) {
                            jobject histogramData = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass histogramDataClass = env->GetObjectClass(histogramData);

                            Set_longTojlongFld(env, histogramData, histogramDataClass, "lLuminance", par2[i].lLuminance);
                            Set_longTojlongFld(env, histogramData, histogramDataClass, "lColorR", par2[i].lColorR);
                            Set_longTojlongFld(env, histogramData, histogramDataClass, "lColorG", par2[i].lColorG);
                            Set_longTojlongFld(env, histogramData, histogramDataClass, "lColorB", par2[i].lColorB);

                            env->DeleteLocalRef(histogramDataClass);
                            env->DeleteLocalRef(histogramData);
                        }

                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                }
                break;
            }
            case 0x3556: {
                if (param2 == NULL) {
                    long par1 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass focusMapDataClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_FocusMapData;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, focusMapDataClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    SDK_FocusMapData par2[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, par2);
                    if (res == XSDK_COMPLETE) {
                        for (jsize i = 0; i < par1; i++) {
                            jobject focusMapData = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass focusMapDataClass = env->GetObjectClass(focusMapData);

                            Set_longTojlongFld(env, focusMapData, focusMapDataClass, "lDistance", par2[i].lDistance);
                            Set_longTojlongFld(env, focusMapData, focusMapDataClass, "lColorR", par2[i].lColorR);
                            Set_longTojlongFld(env, focusMapData, focusMapDataClass, "lColorG", par2[i].lColorG);
                            Set_longTojlongFld(env, focusMapData, focusMapDataClass, "lColorB", par2[i].lColorB);
                            Set_longTojlongFld(env, focusMapData, focusMapDataClass, "lAlpha", par2[i].lAlpha);

                            env->DeleteLocalRef(focusMapDataClass);
                            env->DeleteLocalRef(focusMapData);
                        }

                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                }
                break;
            }
            case 0x4046:{
                char par1[256];
                char par2[256];
                res = sdk_getProp((XSDK_HANDLE)h_camera, (long)l_apicode, (long)l_apiparam, par1, par2);
                if (res == XSDK_COMPLETE){
                    jclass strClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKString");
                    if (env->IsInstanceOf(param1, strClass) == JNI_FALSE || env->IsInstanceOf(param2, strClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jstringID = env->GetFieldID(strClass, "string", "Ljava/lang/String;");
                    jstring jStr1 = env->NewStringUTF(par1);
                    jstring jStr2 = env->NewStringUTF(par2);
                    env->SetObjectField(param1, jstringID, jStr1);
                    env->SetObjectField(param2, jstringID, jStr2);
                    env->DeleteLocalRef(strClass);
                }
                break;
            }
            default : {
                long par1 = 0;
                long par2 = 0;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2);
                if (res == XSDK_COMPLETE) {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PPLP(JNIEnv *env, jobject thiz,
                                                      jlong h_camera, jlong l_apicode,
                                                      jlong l_apiparam, jobject param1,
                                                      jobject param2, jlong param3, jobject param4) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x4076: {
                if (param4 == NULL) {
                    long par1 = 0;
                    long par2 = 0;
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, (long) param3, NULL);
                    if (res == XSDK_COMPLETE) {
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass folderInfoClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_FOLDER_INFO;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param4, folderInfoClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID jlong = env->GetFieldID(longClass, "long", "J");
                    long par1 = env->GetLongField(param1, jlong);
                    long par2 = env->GetLongField(param2, jlong);
                    SDK_FOLDER_INFO par4[par1];
                    res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, (long) param3, &par4);
                    if (res == XSDK_COMPLETE) {
                        for (jsize i = 0; i < par1; i++) {
                            jobject folderInfo = env->GetObjectArrayElement((jobjectArray) param4, i);
                            jclass folderInfoClass = env->GetObjectClass(folderInfo);

                            jfieldID pFoldernameSuffix = env->GetFieldID(folderInfoClass, "pFoldernameSuffix", "Ljava/lang/String;");

                            jstring getStr = env->NewStringUTF(par4[i].pFoldernameSuffix);

                            env->SetObjectField(folderInfo, pFoldernameSuffix, getStr);
                            Set_longTojlongFld(env, folderInfo, folderInfoClass, "lFolderNumber", par4[i].lFolderNumber);
                            Set_longTojlongFld(env, folderInfo, folderInfoClass, "lMaxFrameNumber", par4[i].lMaxFrameNumber);
                            Set_longTojlongFld(env, folderInfo, folderInfoClass, "lStatus", par4[i].lStatus);

                            env->DeleteLocalRef(getStr);
                            env->DeleteLocalRef(folderInfoClass);
                            env->DeleteLocalRef(folderInfo);
                        }

                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                    }
                }
                break;
            }

            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PPP(JNIEnv *env, jobject thiz,
                                                        jlong h_camera, jlong l_apicode,
                                                        jlong l_apiparam, jobject param1,
                                                        jobject param2, jobject param3) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            default: {
                long par1 = 0;
                long par2 = 0;
                long par3 = 0;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, &par3);
                if (res == XSDK_COMPLETE) {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PPPP(JNIEnv *env, jobject thiz,
                                                       jlong h_camera, jlong l_apicode,
                                                       jlong l_apiparam, jobject param1,
                                                       jobject param2, jobject param3, jobject param4) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            default: {
                long par1 = 0;
                long par2 = 0;
                long par3 = 0;
                long par4 = 0;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, &par3, &par4);
                if (res == XSDK_COMPLETE) {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param4, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PPPPPP(JNIEnv *env, jobject thiz,
                                                        jlong h_camera, jlong l_apicode,
                                                        jlong l_apiparam, jobject param1,
                                                        jobject param2, jobject param3,
                                                        jobject param4, jobject param5, jobject param6) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            default: {
                long par1 = 0;
                long par2 = 0;
                long par3 = 0;
                long par4 = 0;
                long par5 = 0;
                long par6 = 0;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, &par3, &par4, &par5, &par6);
                if (res == XSDK_COMPLETE) {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param4, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param5, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param6, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                    Set_longTojlongFld(env, param5, longClass, "long", par5);
                    Set_longTojlongFld(env, param6, longClass, "long", par6);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1GetProp_1PPPPPPPP(JNIEnv *env, jobject thiz,
                                                          jlong h_camera, jlong l_apicode,
                                                          jlong l_apiparam, jobject param1,
                                                          jobject param2, jobject param3,
                                                          jobject param4, jobject param5,
                                                          jobject param6, jobject param7, jobject param8) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            default: {
                long par1 = 0;
                long par2 = 0;
                long par3 = 0;
                long par4 = 0;
                long par5 = 0;
                long par6 = 0;
                long par7 = 0;
                long par8 = 0;
                res = sdk_getProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, &par3, &par4, &par5, &par6, &par7, &par8);
                if (res == XSDK_COMPLETE) {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param4, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param5, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param6, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param7, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param8, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                    Set_longTojlongFld(env, param5, longClass, "long", par5);
                    Set_longTojlongFld(env, param6, longClass, "long", par6);
                    Set_longTojlongFld(env, param7, longClass, "long", par7);
                    Set_longTojlongFld(env, param8, longClass, "long", par8);
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapProp_1PP(JNIEnv *env, jobject thiz,
                                                      jlong h_camera, jlong l_apicode,
                                                      jlong l_apiparam, jobject param1,
                                                      jobject param2) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x4237:
            case 0x4238:{
                long par1 = 0;
                long par2 = 0;
                res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, longClass, "long", par1);
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                }
                break;
            }
            case 0x362B:{
                SDK_MOVIE_AFC_CUSTOM par1;
                SDK_MOVIE_AFC_CUSTOM par2;
                res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2);
                if (res == XSDK_COMPLETE){
                    jclass afcClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_MOVIE_AFC_CUSTOM");
                    if (env->IsInstanceOf(param1, afcClass) == JNI_FALSE || env->IsInstanceOf(param2, afcClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param1, afcClass, "lTracking", par1.lTracking);
                    Set_longTojlongFld(env, param1, afcClass, "lSpeed", par1.lSpeed);
                    Set_longTojlongFld(env, param2, afcClass, "lTracking", par2.lTracking);
                    Set_longTojlongFld(env, param2, afcClass, "lSpeed", par2.lSpeed);
                }
                break;
            }
            case 0x2259:{
                if (param2 == NULL){
                    long par1 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass focusPosCapClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_FOCUS_POS_CAP;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, focusPosCapClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num = env->GetLongField(param1,lNum);
                    SDK_FOCUS_POS_CAP plArray[num];
                    long pNum = num;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum, &plArray);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", num);
                        for (jsize i = 0; i < pNum; i++) {
                            jobject focusPosCap = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass focusPosCapClass = env->GetObjectClass(focusPosCap);

                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lSizeFocusPosCap", plArray[i].lSizeFocusPosCap);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lStructVer", plArray[i].lStructVer);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lFocusPlsINF", plArray[i].lFocusPlsINF);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lFocusPlsMOD", plArray[i].lFocusPlsMOD);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lFocusOverSearchPlsINF", plArray[i].lFocusOverSearchPlsINF);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lFocusOverSearchPlsMOD", plArray[i].lFocusOverSearchPlsMOD);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lFocusPlsFCSDepthCap", plArray[i].lFocusPlsFCSDepthCap);
                            Set_longTojlongFld(env, focusPosCap, focusPosCapClass, "lMinDriveStepMFDriveEndThresh", plArray[i].lMinDriveStepMFDriveEndThresh);

                            env->DeleteLocalRef(focusPosCapClass);
                            env->DeleteLocalRef(focusPosCap);
                        }
                    }
                }
                break;
            }
            case 0x2287:{
                if (param2 == NULL){
                    long par1 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    jclass AFZoneClassArray = env->FindClass("[Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustomCapablity;");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, AFZoneClassArray) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num = env->GetLongField(param1,lNum);
                    SDK_AFZoneCustomCapablity plArray[num];
                    long pNum = num;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum, &plArray);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", num);
                        for (jsize i = 0; i < pNum; i++) {
                            jobject AFZoneCustom = env->GetObjectArrayElement((jobjectArray) param2, i);
                            jclass AFZoneCustomClass= env->GetObjectClass(AFZoneCustom);
                            jclass AFZoneClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom");

                            jfieldID min = env->GetFieldID(AFZoneCustomClass, "min", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");
                            jfieldID max = env->GetFieldID(AFZoneCustomClass, "max", "Lcom/fujifilm/zoompos/xsdk/XSDK$SDK_AFZoneCustom;");

                            jobject minObject = env->GetObjectField(AFZoneCustom, min);
                            jobject maxObject = env->GetObjectField(AFZoneCustom, max);

                            Set_longTojlongFld(env, AFZoneCustom, AFZoneCustomClass, "mode", plArray[i].mode);
                            Set_longTojlongFld(env, minObject, AFZoneClass, "h", plArray[i].min.h);
                            Set_longTojlongFld(env, minObject, AFZoneClass, "v", plArray[i].min.v);
                            Set_longTojlongFld(env, maxObject, AFZoneClass, "h", plArray[i].max.h);
                            Set_longTojlongFld(env, maxObject, AFZoneClass, "v", plArray[i].max.v);

                            env->DeleteLocalRef(minObject);
                            env->DeleteLocalRef(maxObject);
                            env->DeleteLocalRef(AFZoneCustomClass);
                            env->DeleteLocalRef(AFZoneCustom);
                        }
                    }
                }
                break;
            }
            default :{
                if (param2 == NULL){
                    long par1 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num = env->GetLongField(param1,lNum);
                    long plArray[num];
                    long pNum = num;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum, &plArray);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", pNum);
                        jlong* jlArray = env->GetLongArrayElements((jlongArray)param2,0);
                        for (int i = 0; i < pNum; i++) {
                            jlArray[i] = (jlong)plArray[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param2,jlArray,0);
                    }
                }
                break;
            }
        }

    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapProp_1LPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong l_apicode, jlong l_apiparam,
                                                       jlong param1, jobject param2, jobject param3) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2213:
            case 0x2235:{
                SDK_FocusArea par2;
                SDK_FocusArea par3;
                res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, &par3);
                if (res == XSDK_COMPLETE){
                    jclass focusAreaClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDK_FocusArea");
                    if (env->IsInstanceOf(param2, focusAreaClass) == JNI_FALSE || env->IsInstanceOf(param3, focusAreaClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, focusAreaClass, "h", par2.h);
                    Set_longTojlongFld(env, param2, focusAreaClass, "v", par2.v);
                    Set_longTojlongFld(env, param2, focusAreaClass, "size", par2.size);
                    Set_longTojlongFld(env, param3, focusAreaClass, "h", par2.h);
                    Set_longTojlongFld(env, param3, focusAreaClass, "v", par2.v);
                    Set_longTojlongFld(env, param3, focusAreaClass, "size", par2.size);
                }
                break;
            }
            default : {
                if (param3 == NULL){
                    long par2 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num = env->GetLongField(param2,lNum);
                    long plArray[num];
                    long pNum = num;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &pNum, &plArray);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param2, longClass, "long", pNum);
                        jlong* jlArray = env->GetLongArrayElements((jlongArray)param3,0);
                        for (int i = 0; i < pNum; i++) {
                            jlArray[i] = (jlong)plArray[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param3,jlArray,0);
                    }
                }
                break;
            }
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapProp_1LPPPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                       jlong l_apicode, jlong l_apiparam,
                                                       jlong param1, jobject param2, jobject param3,
                                                       jobject param4, jobject param5) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2324:
            case 0x3601:{
                long par2;
                long par3;
                long par4;
                long par5;
                res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, (long)param1, &par2, &par3, &par4, &par5);
                if (res == XSDK_COMPLETE){
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param2, longClass) == JNI_FALSE || env->IsInstanceOf(param3, longClass) == JNI_FALSE ||
                            env->IsInstanceOf(param4, longClass) == JNI_FALSE || env->IsInstanceOf(param5, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    Set_longTojlongFld(env, param2, longClass, "long", par2);
                    Set_longTojlongFld(env, param3, longClass, "long", par3);
                    Set_longTojlongFld(env, param4, longClass, "long", par4);
                    Set_longTojlongFld(env, param5, longClass, "long", par5);
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapProp_1PPPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                         jlong l_apicode, jlong l_apiparam,
                                                         jobject param1, jobject param2,
                                                         jobject param3, jobject param4) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x2196:
            case 0x2243:
            case 0x3607:
            case 0x4012:
            case 0x423A:{
                if (param3 == NULL || param4 == NULL){
                    long par1 = 0;
                    long par2 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, NULL, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param2, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num1 = env->GetLongField(param1,lNum);
                    jlong num2 = env->GetLongField(param2,lNum);
                    long plArray3[num1];
                    long plArray4[num2];
                    long pNum1 = num1;
                    long pNum2 = num2;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum1, &pNum2, plArray3, plArray4);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", pNum1);
                        Set_longTojlongFld(env, param2, longClass, "long", pNum2);
                        jlong* jlArray3 = env->GetLongArrayElements((jlongArray)param3,0);
                        jlong* jlArray4 = env->GetLongArrayElements((jlongArray)param4,0);
                        for (int i = 0; i < pNum1; i++) {
                            jlArray3[i] = (jlong)plArray3[i];
                        }
                        for (int i = 0; i < pNum2; i++) {
                            jlArray4[i] = (jlong)plArray4[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param3,jlArray3,0);
                        env->ReleaseLongArrayElements((jlongArray)param4,jlArray4,0);
                    }
                }
                break;
            }
            case 0x2272:
            case 0x2274:{
                if (param2 == NULL || param4 == NULL){
                    long par1 = 0;
                    long par3 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, NULL, &par3, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                        Set_longTojlongFld(env, param3, longClass, "long", par3);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE || env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num1 = env->GetLongField(param1,lNum);
                    jlong num3 = env->GetLongField(param3,lNum);
                    long plArray2[num1];
                    long plArray4[num3];
                    long pNum1 = num1;
                    long pNum3 = num3;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum1, plArray2, &pNum3, plArray4);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", pNum1);
                        Set_longTojlongFld(env, param3, longClass, "long", pNum3);
                        jlong* jlArray2 = env->GetLongArrayElements((jlongArray)param2,0);
                        jlong* jlArray4 = env->GetLongArrayElements((jlongArray)param4,0);
                        for (int i = 0; i < pNum1; i++) {
                            jlArray2[i] = (jlong)plArray2[i];
                        }
                        for (int i = 0; i < pNum3; i++) {
                            jlArray4[i] = (jlong)plArray4[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param2,jlArray2,0);
                        env->ReleaseLongArrayElements((jlongArray)param4,jlArray4,0);
                    }
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}

extern "C"
JNIEXPORT jlong JNICALL
Java_com_fujifilm_zoompos_xsdk_XSDK_XSDK_1CapProp_1PPPPPP(JNIEnv *env, jobject thiz, jlong h_camera,
                                                        jlong l_apicode, jlong l_apiparam,
                                                        jobject param1, jobject param2,
                                                        jobject param3, jobject param4,
                                                        jobject param5, jobject param6) {
    long res = XSDK_APP_ERROR;
    try{
        switch (l_apicode) {
            case 0x4078:{
                if (param4 == NULL || param5 == NULL || param6 == NULL){
                    long par1 = 0;
                    long par2 = 0;
                    long par3 = 0;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &par1, &par2, &par3, NULL, NULL, NULL);
                    if (res == XSDK_COMPLETE){
                        jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                        if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                            env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                            env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                            return XSDK_APP_ERROR;
                        }
                        Set_longTojlongFld(env, param1, longClass, "long", par1);
                        Set_longTojlongFld(env, param2, longClass, "long", par2);
                        Set_longTojlongFld(env, param3, longClass, "long", par3);
                    }
                } else {
                    jclass longClass = env->FindClass("com/fujifilm/zoompos/xsdk/XSDK$SDKLong");
                    if (env->IsInstanceOf(param1, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param2, longClass) == JNI_FALSE ||
                        env->IsInstanceOf(param3, longClass) == JNI_FALSE) {
                        return XSDK_APP_ERROR;
                    }
                    jfieldID lNum = env->GetFieldID(longClass, "long", "J");
                    jlong num1 = env->GetLongField(param1,lNum);
                    jlong num2 = env->GetLongField(param2,lNum);
                    jlong num3 = env->GetLongField(param3,lNum);
                    long plArray4[num1];
                    long plArray5[num2];
                    long plArray6[num3];
                    long pNum1 = num1;
                    long pNum2 = num2;
                    long pNum3 = num3;
                    res = sdk_capProp((XSDK_HANDLE) h_camera, (long) l_apicode, (long) l_apiparam, &pNum1, &pNum2, &pNum3, plArray4 , plArray5, plArray6);
                    if (res == XSDK_COMPLETE){
                        Set_longTojlongFld(env, param1, longClass, "long", pNum1);
                        Set_longTojlongFld(env, param2, longClass, "long", pNum2);
                        Set_longTojlongFld(env, param3, longClass, "long", pNum3);
                        jlong* jlArray4 = env->GetLongArrayElements((jlongArray)param4,0);
                        jlong* jlArray5 = env->GetLongArrayElements((jlongArray)param5,0);
                        jlong* jlArray6 = env->GetLongArrayElements((jlongArray)param6,0);
                        for (int i = 0; i < pNum1; i++) {
                            jlArray4[i] = (jlong)plArray4[i];
                        }
                        for (int i = 0; i < pNum2; i++) {
                            jlArray5[i] = (jlong)plArray5[i];
                        }
                        for (int i = 0; i < pNum3; i++) {
                            jlArray6[i] = (jlong)plArray6[i];
                        }
                        env->ReleaseLongArrayElements((jlongArray)param4,jlArray4,0);
                        env->ReleaseLongArrayElements((jlongArray)param5,jlArray5,0);
                        env->ReleaseLongArrayElements((jlongArray)param6,jlArray6,0);
                    }
                }
                break;
            }
            default :
                res = XSDK_APP_ERROR;
                break;
        }
    }
    catch (...){
        res = XSDK_APP_ERROR;
    }
    return res;
}
