package com.fujifilm.hotfolder

import android.graphics.BitmapFactory
import android.os.Environment
import androidx.lifecycle.lifecycleScope
import com.fujifilm.hotfolder.xsdk.XSDK
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.io.File
import java.io.FileOutputStream
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter

class ReadImageClass (private val activity: MainActivity) {

    fun startReadImage(hCamera: Long){
        activity.lifecycleScope.launch {
            withContext(Dispatchers.IO) {
                while (HotFolderState.isStartReadImage){
                    val imageInfo = XSDK.XSDK_ImageInformation()
                    var res = CameraControl.readImageInfo(hCamera, imageInfo)
                    if (res != SDKResult.XSDK_COMPLETE) {
                        val error = CameraControl.getError(hCamera)
                        if (!error.contains("XSDK_ERRCODE_BUSY") &&
                            !error.contains("XSDK_ERRCODE_FORCEMODE_BUSY") &&
                            !error.contains("XSDK_ERRCODE_RUNNING_OTHER_FUNCTION")) {
                            withContext(Dispatchers.Default){
                                delay(500)
                                activity.initialize()
                            }
                            HotFolderState.isStartReadImage = false
                            break
                        }
                        continue
                    }
                    when(val type = imageInfo.lFormat.toInt() and 0x1F){
                        Constants.XSDK_IMAGEFORMAT_NONE -> continue
                        else -> {
                            val imageData = ByteArray(imageInfo.lDataSize.toInt())
                            res = CameraControl.readImage(hCamera, imageData, imageInfo.lDataSize)
                            if (res != SDKResult.XSDK_COMPLETE) {
                                val error = CameraControl.getError(hCamera)
                                if (!error.contains("XSDK_ERRCODE_BUSY") &&
                                    !error.contains("XSDK_ERRCODE_FORCEMODE_BUSY") &&
                                    !error.contains("XSDK_ERRCODE_RUNNING_OTHER_FUNCTION")) {
                                    withContext(Dispatchers.Default){
                                        delay(500)
                                        activity.initialize()
                                    }
                                    HotFolderState.isStartReadImage = false
                                    break
                                }
                                continue
                            }
                            val externalStorageDir = Environment.getExternalStoragePublicDirectory(
                                Environment.DIRECTORY_PICTURES)
                            val currentDateTime = LocalDateTime.now()
                            val formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS")
                            val imageName = when(type){
                                Constants.XSDK_IMAGEFORMAT_RAW -> {
                                    currentDateTime.format(formatter) + ".RAF"
                                }
                                Constants.XSDK_IMAGEFORMAT_JPEG -> {
                                    currentDateTime.format(formatter) + ".JPG"
                                }
                                Constants.XSDK_IMAGEFORMAT_HEIF -> {
                                    currentDateTime.format(formatter) + ".HEIC"
                                }
                                else -> continue
                            }
                            val folderName = "HotFolderSample"
                            val folder = File(externalStorageDir, folderName)
                            val path = if (!folder.exists()) {
                                val isCreated = folder.mkdirs()
                                if (isCreated) {
                                    externalStorageDir.path + "/HotFolderSample"
                                } else {
                                    externalStorageDir.path
                                }
                            } else {
                                externalStorageDir.path + "/HotFolderSample"
                            }

                            val file = File(path, imageName)
                            val fos = FileOutputStream(file)
                            fos.write(imageData)
                            fos.close()
                        }
                    }
                }
            }
        }
    }
}