package com.fujifilm.hotfolder

import android.annotation.SuppressLint
import android.app.PendingIntent
import android.content.Intent
import android.hardware.usb.UsbDevice
import android.hardware.usb.UsbDeviceConnection
import android.hardware.usb.UsbManager
import android.os.Build
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.TextView
import com.fujifilm.hotfolder.xsdk.XSDK
import java.util.Timer
import java.util.TimerTask

class MainActivity : AppCompatActivity() {

    object AndroidSDKResult{
        const val COMPLETE              = 0L
        const val ERROR                 = -1L
    }
    object AndroidSDKErrorNumber{
        const val ERRCODE_NOERR                = 0x00000000L
        const val ERRCODE_SEQUENCE             = 0x00001001L
        const val ERRCODE_PERMISSION           = 0x00001002L
        const val ERRCODE_UNKNOWN              = 0x00009100L
    }

    private lateinit var permissionIntent: PendingIntent
    private lateinit var usbManager: UsbManager
    private var device: UsbDevice? = null
    private var detectedDevice: UsbDevice? = null
    private var usbDeviceConnection: UsbDeviceConnection? = null
    private val timer = Timer()

    private lateinit var connectText: TextView

    private lateinit var readImageClass:ReadImageClass

    private var isRunning = false

    private var detectedcount: Long = 0
    private var errordetails: Long = AndroidSDKErrorNumber.ERRCODE_NOERR

    private val hCamera: XSDK.SDKLong = XSDK.SDKLong(long = 0)

    @SuppressLint("MissingInflatedId")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        permissionIntent = PendingIntent.getBroadcast(
            this,
            0,
            Intent("com.fujifilm.hotfolder.USB_PERMISSION").apply {
                this.`package` = packageName
            },
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) PendingIntent.FLAG_MUTABLE else 0
        )

        if (savedInstanceState == null) {
            usbManager = getSystemService(USB_SERVICE) as UsbManager

            if (usbManager.deviceList.size == 1) {
                device = usbManager.deviceList.values.toList()[0]
            }
        }

        readImageClass = ReadImageClass(this)

        connectText = findViewById(R.id.connect_textView)

        timer.schedule(object : TimerTask() {
            override fun run() {
                if (HotFolderState.connectState) {
                    if (!HotFolderState.isStartReadImage) {
                        HotFolderState.isStartReadImage = true
                        readImageClass.startReadImage(hCamera.long)
                    }
                }else{
                    initialize()
                }
            }
        }, 0, 500)
    }

    override fun onDestroy() {
        super.onDestroy()
        timer.cancel()
        close()
    }

    @Synchronized
    fun initialize() {
        isRunning = true
        usbDeviceConnection = null
        runOnUiThread {
            connectText.text = getString(R.string.waiting_connect_text)
        }

        var ret = detect()
        if(ret != AndroidSDKResult.COMPLETE){
            isRunning = false
        }else if(detectedcount == 0L){
            isRunning = false
        }

        if(isRunning){
            ret = CameraControl.init()
            if (ret != SDKResult.XSDK_COMPLETE) {
                isRunning = false
            }
        }

        if(isRunning){
            ret = open()
            if(ret != AndroidSDKResult.COMPLETE){
                isRunning = false
            }
        }

        if (isRunning) {
            runOnUiThread {
                connectText.text = getString(R.string.connect_text)
            }
            HotFolderState.connectState = true
        }else{
            if (HotFolderState.connectState) {
                HotFolderState.connectState = false
                close()
            }
        }
    }

    private fun detect():Long {
        var result:Long = AndroidSDKResult.COMPLETE
        errordetails = AndroidSDKErrorNumber.ERRCODE_NOERR

        if (usbManager.deviceList.size == 1) {
            device = usbManager.deviceList.values.toList()[0]
        }else{
            device = null
            detectedDevice = null
            usbDeviceConnection = null
        }
        if (device != null) {
            if (usbManager.hasPermission(device)) {
                detectedDevice = device
                detectedcount = 1
            }else{
                usbManager.requestPermission(device, permissionIntent)
                if (usbManager.hasPermission(device)) {
                    detectedDevice = device
                    detectedcount = 1
                }else{
                    errordetails = AndroidSDKErrorNumber.ERRCODE_PERMISSION
                    result = AndroidSDKResult.ERROR
                }
            }
        }else{
            detectedcount = 0
        }
        return result
    }

    private fun open(): Long {
        errordetails = AndroidSDKErrorNumber.ERRCODE_NOERR

        try {
            if (usbDeviceConnection != null) {
                errordetails = AndroidSDKErrorNumber.ERRCODE_SEQUENCE
                return AndroidSDKResult.ERROR
            }
            if (detectedDevice == null) {
                errordetails = AndroidSDKErrorNumber.ERRCODE_SEQUENCE
                return AndroidSDKResult.ERROR
            }
            val requiredDevice = detectedDevice!!
            if (!usbManager.hasPermission(requiredDevice)) {
                errordetails = AndroidSDKErrorNumber.ERRCODE_PERMISSION
                return AndroidSDKResult.ERROR
            }

            //Open a session and pass the file descriptor to the SDK.
            usbDeviceConnection = usbManager.openDevice(requiredDevice)
            val fd = usbDeviceConnection!!.fileDescriptor
            val descriptors = usbDeviceConnection!!.rawDescriptors
            return CameraControl.setUSBDeviceHandle(fd.toLong(), descriptors, hCamera)
        } catch (e: Exception) {
            errordetails = AndroidSDKErrorNumber.ERRCODE_UNKNOWN
            return AndroidSDKResult.ERROR
        }
    }

    private fun close(){
        CameraControl.close(hCamera.long)
        CameraControl.exit()
    }
}