//
//  FujiSDK.h
//  FujiSDK
//
//  Created by DVN405 on 2024/10/07.
//

#import <Foundation/Foundation.h>
#include "../SDK/XAPI.H"
#include "../SDK/XAPI_MOV.H"
#include "../SDK/XAPIOpt.H"
#include "../SDK/XAPIOpt_MOV.H"


@interface CameraList : NSObject {
    NSString* strProduct;
    NSString* strSerialNo;
    NSString* strIPAddress;
    NSString* strFramework;
    bool bValid;
}
@property(nonatomic, retain)NSString* strProduct;
@property(nonatomic, retain)NSString* strSerialNo;
@property(nonatomic, retain)NSString* strIPAddress;
@property(nonatomic, retain)NSString* strFramework;
@property(nonatomic)bool bValid;
@end

@interface DeviceInformation : NSObject {
    NSString* strVendor;
    NSString* strManufacturer;
    NSString* strProduct;
    NSString* strFirmware;
    NSString* strDeviceType;
    NSString* strSerialNo;
    NSString* strFramework;
    uint8_t bDeviceId;
    NSString* strDeviceName;
    NSString* strYNo;
}
@property(nonatomic, retain)NSString* strVendor;
@property(nonatomic, retain)NSString* strManufacturer;
@property(nonatomic, retain)NSString* strProduct;
@property(nonatomic, retain)NSString* strFirmware;
@property(nonatomic, retain)NSString* strDeviceType;
@property(nonatomic, retain)NSString* strSerialNo;
@property(nonatomic, retain)NSString* strFramework;
@property(nonatomic)uint8_t bDeviceId;
@property(nonatomic, retain)NSString* strDeviceName;
@property(nonatomic, retain)NSString* strYNo;
@end

@interface LensInformation : NSObject {
    NSString* strModel;
    NSString* strProductName;
    NSString* strSerialNo;
    long lISCapability;
    long lMFCapability;
    long lZoomPosCapability;
}
@property(nonatomic, retain)NSString* strModel;
@property(nonatomic, retain)NSString* strProductName;
@property(nonatomic, retain)NSString* strSerialNo;
@property(nonatomic)long lISCapability;
@property(nonatomic)long lMFCapability;
@property(nonatomic)long lZoomPosCapability;
@end

@interface ImageInformation : NSObject {
    NSString* strInternalName;
    long lFormat;
    long lDataSize;
    long lImagePixHeight;
    long lImagePixWidth;
    long lImageBitDepth;
    long lPreviewSize;
    XSDK_HANDLE hImage;
}
@property(nonatomic, retain)NSString* strInternalName;
@property(nonatomic)long lFormat;
@property(nonatomic)long lDataSize;
@property(nonatomic)long lImagePixHeight;
@property(nonatomic)long lImagePixWidth;
@property(nonatomic)long lImageBitDepth;
@property(nonatomic)long lPreviewSize;
@property(nonatomic)XSDK_HANDLE hImage;
@end


@interface FujiSDK : NSObject

-(instancetype)init;
-(void)dealloc;
-(bool)LoadLibrary;
-(void*)GetProcAddress:(LIB_HANDLE) hLib
             pProcName:(const char*) pProcName;

-(long) XSDK_Init;

-(long) XSDK_Exit;

-(long) XSDK_Detect:(long) lInterface
         pInterface:(NSString*) pInterface
        pDeviceName:(NSString*) pDeviceName
            plCount:(long*) plCount;

-(long) XSDK_Append:(long) lInterface
         pInterface:(NSString*) pInterface
        pDeviceName:(NSString*) pDeviceName
            plCount:(long*) plCount
        pCameraList:(NSArray<CameraList*>*) pCameraList;

-(long) XSDK_Close:(XSDK_HANDLE) hCamera;

-(long) XSDK_PowerOFF:(XSDK_HANDLE) hCamera;

-(long) XSDK_OpenEx:(NSString*) pDevice
           phCamera:(XSDK_HANDLE*) phCamera
       plCameraMode:(long*) plCameraMode
            pOption:(void*) pOption;

-(long) XSDK_GetErrorNumber:(XSDK_HANDLE) hCamera
                  plAPICode:(long*) plAPICode
                  plERRCode:(long*) plERRCode;

-(long) XSDK_GetVersionString:(NSString*) pVersionString;

-(long) XSDK_GetErrorDetails:(XSDK_HANDLE) hCamera
                   plERRCode:(long*) plERRCode;

-(long) XSDK_GetDeviceInfo:(XSDK_HANDLE) hCamera
                  pDevInfo:(DeviceInformation*) pDevInfo;

-(long) XSDK_WriteDeviceName:(XSDK_HANDLE) hCamera
                 pDeviceName:(NSString*) pDeviceName;

-(long) XSDK_GetFirmwareVersion:(XSDK_HANDLE) hCamera
               pFirmwareVersion:(NSString*) pFirmwareVersion;

-(long) XSDK_GetLensInfo:(XSDK_HANDLE) hCamera
               pLensInfo:(LensInformation*) pLensInfo;

-(long) XSDK_GetLensVersion:(XSDK_HANDLE) hCamera
                pLensVersion:(NSString*) pLensVersion;

-(long) XSDK_GetDeviceInfoEx:(XSDK_HANDLE) hCamera
                    pDevInfo:(DeviceInformation*) pDevInfo
                plNumAPICode:(long*) plNumAPICode
                   plAPICode:(long*) plAPICode;

-(long) XSDK_CapPriorityMode:(XSDK_HANDLE) hCamera
           plNumPriorityMode:(long*) plNumPriorityMode
              plPriorityMode:(long*) plPriorityMode;

-(long) XSDK_SetPriorityMode:(XSDK_HANDLE) hCamera
               lPriorityMode:(long) lPriorityMode;

-(long) XSDK_GetPriorityMode:(XSDK_HANDLE) hCamera
              plPriorityMode:(long*) plPriorityMode;

-(long) XSDK_CapRelease:(XSDK_HANDLE) hCamera
       plNumReleaseMode:(long*) plNumReleaseMode
          plReleaseMode:(long*) plReleaseMode;

-(long) XSDK_Release:(XSDK_HANDLE) hCamera
        lReleaseMode:(long) lReleaseMode
           plShotOpt:(long*) plShotOpt
          plAfStatus:(long*) plAfStatus;

-(long) XSDK_CapReleaseEx:(XSDK_HANDLE) hCamera
         plNumReleaseMode:(long*) plNumReleaseMode
            plReleaseMode:(long*) plReleaseMode;

-(long) XSDK_ReleaseEx:(XSDK_HANDLE) hCamera
          lReleaseMode:(long) lReleaseMode
             plShotOpt:(long*) plShotOpt
            plAfStatus:(long*) plAfStatus;

-(long) XSDK_GetReleaseStatus:(XSDK_HANDLE) hCamera
              plReleaseStatus:(long*) plReleaseStatus;

-(long) XSDK_GetBufferCapacity:(XSDK_HANDLE) hCamera
               plShootFrameNum:(long*) plShootFrameNum
               plTotalFrameNum:(long*) plTotalFrameNum;

-(long) XSDK_ReadImageInfo:(XSDK_HANDLE) hCamera
                  pImgInfo:(ImageInformation*) pImgInfo;

-(long) XSDK_ReadPreview:(XSDK_HANDLE) hCamera
                   pData:(unsigned char*) pData
               lDataSize:(unsigned long) lDataSize;

-(long) XSDK_ReadImage:(XSDK_HANDLE) hCamera
                 pData:(unsigned char*) pData
             lDataSize:(unsigned long) lDataSize;

-(long) XSDK_DeleteImage:(XSDK_HANDLE) hCamera;


-(long) XSDK_CapAEMode:(XSDK_HANDLE) hCamera
           plNumAEMode:(long*) plNumAEMode
              plAEMode:(long*) plAEMode;

-(long) XSDK_SetAEMode:(XSDK_HANDLE) hCamera
               lAEMode:(long) lAEMode;

-(long) XSDK_GetAEMode:(XSDK_HANDLE) hCamera
              plAEMode:(long*) plAEMode;

-(long) XSDK_CapShutterSpeed:(XSDK_HANDLE) hCamera
           plNumShutterSpeed:(long*) plNumShutterSpeed
              plShutterSpeed:(long*) plShutterSpeed
               plBulbCapable:(long*) plBulbCapable;

-(long) XSDK_SetShutterSpeed:(XSDK_HANDLE) hCamera
               lShutterSpeed:(long) lShutterSpeed
                       lBulb:(long) lBulb;

-(long) XSDK_GetShutterSpeed:(XSDK_HANDLE) hCamera
              plShutterSpeed:(long*) plShutterSpeed
                      plBulb:(long*) plBulb;

-(long) XSDK_CapExposureBias:(XSDK_HANDLE) hCamera
           plNumExposureBias:(long*) plNumExposureBias
              plExposureBias:(long*) plExposureBias;

-(long) XSDK_SetExposureBias:(XSDK_HANDLE) hCamera
               lExposureBias:(long) lExposureBias;

-(long) XSDK_GetExposureBias:(XSDK_HANDLE) hCamera
              plExposureBias:(long*)  plExposureBias;

-(long) XSDK_CapSensitivity:(XSDK_HANDLE) hCamera
           plNumSensitivity:(long*) plNumSensitivity
              plSensitivity:(long*) plSensitivity;

-(long) XSDK_SetSensitivity:(XSDK_HANDLE) hCamera
               lSensitivity:(long) lSensitivity;

-(long) XSDK_GetSensitivity:(XSDK_HANDLE) hCamera
              plSensitivity:(long*) plSensitivity;

-(long) XSDK_CapDynamicRange:(XSDK_HANDLE) hCamera
           plNumDynamicRange:(long*) plNumDynamicRange
              plDynamicRange:(long*) plDynamicRange;

-(long) XSDK_SetDynamicRange:(XSDK_HANDLE) hCamera
               lDynamicRange:(long) lDynamicRange;

-(long) XSDK_GetDynamicRange:(XSDK_HANDLE) hCamera
              plDynamicRange:(long*) plDynamicRange;

-(long) XSDK_CapMeteringMode:(XSDK_HANDLE) hCamera
           plNumMeteringMode:(long*) plNumMeteringMode
              plMeteringMode:(long*) plMeteringMode;

-(long) XSDK_SetMeteringMode:(XSDK_HANDLE) hCamera
               lMeteringMode:(long) lMeteringMode;

-(long) XSDK_GetMeteringMode:(XSDK_HANDLE) hCamera
              plMeteringMode:(long*) plMeteringMode;

-(long) XSDK_CapLensZoomPos:(XSDK_HANDLE) hCamera
               plNumZoomPos:(long*) plNumZoomPos
                  plZoomPos:(long*) plZoomPos
              plFocusLength:(long*) plFocusLength
          pl35mmFocusLength:(long*) pl35mmFocusLength;

-(long) XSDK_SetLensZoomPos:(XSDK_HANDLE) hCamera
                   lZoomPos:(long) lZoomPos;

-(long) XSDK_GetLensZoomPos:(XSDK_HANDLE) hCamera
                  plZoomPos:(long*) plZoomPos;

-(long) XSDK_CapAperture:(XSDK_HANDLE) hCamera
                lZoomPos:(long) lZoomPos
           plNumAperture:(long*) plNumAperture
               plFNumber:(long*) plFNumber;

-(long) XSDK_SetAperture:(XSDK_HANDLE) hCamera
                lFNumber:(long) lFNumber;

-(long) XSDK_GetAperture:(XSDK_HANDLE) hCamera
               plFNumber:(long*) plFNumber;

-(long) XSDK_CapWBMode:(XSDK_HANDLE) hCamera
           plNumWBMode:(long*) plNumWBMode
              plWBMode:(long*) plWBMode;

-(long) XSDK_SetWBMode:(XSDK_HANDLE) hCamera
               lWBMode:(long) lWBMode;

-(long) XSDK_GetWBMode:(XSDK_HANDLE) hCamera
              plWBMode:(long*) plWBMode;

-(long) XSDK_CapWBColorTemp:(XSDK_HANDLE) hCamera
           plNumWBColorTemp:(long*) plNumWBColorTemp
              plWBColorTemp:(long*) plWBColorTemp;

-(long) XSDK_SetWBColorTemp:(XSDK_HANDLE) hCamera
                 lColorTemp:(long) lColorTemp;

-(long) XSDK_GetWBColorTemp:(XSDK_HANDLE) hCamera
                plColorTemp:(long*) plColorTemp;

-(long) XSDK_CapMediaRecord:(XSDK_HANDLE) hCamera
           plNumMediaRecord:(long*) plNumMediaRecord
              plMediaRecord:(long*) plMediaRecord;

-(long) XSDK_SetMediaRecord:(XSDK_HANDLE) hCamera
               lMediaRecord:(long) lMediaRecord;

-(long) XSDK_GetMediaRecord:(XSDK_HANDLE) hCamera
              plMediaRecord:(long*) plMediaRecord;

-(long) XSDK_CapForceMode:(XSDK_HANDLE) hCamera
           plNumForceMode:(long*) plNumForceMode
              plForceMode:(long*) plForceMode;

-(long) XSDK_SetForceMode:(XSDK_HANDLE) hCamera
               lForceMode:(long) lForceMode;

-(long) XSDK_CapDriveMode:(XSDK_HANDLE) hCamera
                    plNum:(long*) plNum
            pFunctionMode:(long*) pFunctionMode;

-(long) XSDK_SetDriveMode:(XSDK_HANDLE) hCamera
             functionMode:(long) functionMode;

-(long) XSDK_GetDriveMode:(XSDK_HANDLE) hCamera
            pFunctionMode:(long*) pFunctionMode;

-(long) XSDK_CapMode:(XSDK_HANDLE) hCamera
               plNum:(long*) plNum
              plMode:(long*) plMode;

-(long) XSDK_SetMode:(XSDK_HANDLE) hCamera
               lMode:(long) lMode;

-(long) XSDK_GetMode:(XSDK_HANDLE) hCamera
              plMode:(long*) plMode;

-(long) XSDK_SetBackupSettings:(XSDK_HANDLE) hCamera
                         lSize:(long) lSize
                       pBackup:(unsigned char*) pBackup;

-(long) XSDK_GetBackupSettings:(XSDK_HANDLE) hCamera
                        plSize:(long*) plSize
                       pBackup:(unsigned char*) pBackup;

-(long) XSDK_GetRecordingStatus:(XSDK_HANDLE) hCamera
                       plStatus:(long*) plStatus;

-(long) XSDK_CapMovieShutterSpeed:(XSDK_HANDLE) hCamera
                plNumShutterSpeed:(long*) plNumShutterSpeed
                  pllShutterSpeed:(long long*) pllShutterSpeed;

-(long) XSDK_SetMovieShutterSpeed:(XSDK_HANDLE) hCamera
                   llShutterSpeed:(long long) llShutterSpeed;

-(long) XSDK_GetMovieShutterSpeed:(XSDK_HANDLE) hCamera
                  pllShutterSpeed:(long long*) pllShutterSpeed;

-(long) XSDK_CapMovieExposureBias:(XSDK_HANDLE) hCamera
                plNumExposureBias:(long*) plNumExposureBias
                   plExposureBias:(long*) plExposureBias;

-(long) XSDK_SetMovieExposureBias:(XSDK_HANDLE) hCamera
                    lExposureBias:(long) lExposureBias;

-(long) XSDK_GetMovieExposureBias:(XSDK_HANDLE) hCamera
                   plExposureBias:(long*) plExposureBias;

-(long) XSDK_CapMovieSensitivity:(XSDK_HANDLE) hCamera
                plNumSensitivity:(long*) plNumSensitivity
                   plSensitivity:(long*) plSensitivity;

-(long) XSDK_SetMovieSensitivity:(XSDK_HANDLE) hCamera
                    lSensitivity:(long) lSensitivity;

-(long) XSDK_GetMovieSensitivity:(XSDK_HANDLE) hCamera
                   plSensitivity:(long*) plSensitivity;

-(long) XSDK_CapMovieAperture:(XSDK_HANDLE) hCamera
                plNumAperture:(long*) plNumAperture
                    plFNumber:(long*) plFNumber;

-(long) XSDK_SetMovieAperture:(XSDK_HANDLE) hCamera
                     lFNumber:(long) lFNumber;

-(long) XSDK_GetMovieAperture:(XSDK_HANDLE) hCamera
                    plFNumber:(long*) plFNumber;

-(long) XSDK_CapMovieDynamicRange:(XSDK_HANDLE) hCamera
                plNumDynamicRange:(long*) plNumDynamicRange
                   plDynamicRange:(long*) plDynamicRange;

-(long) XSDK_SetMovieDynamicRange:(XSDK_HANDLE) hCamera
                    lDynamicRange:(long) lDynamicRange;

-(long) XSDK_GetMovieDynamicRange:(XSDK_HANDLE) hCamera
                   plDynamicRange:(long*) plDynamicRange;

-(long) XSDK_CapMovieMeteringMode:(XSDK_HANDLE) hCamera
                plNumMeteringMode:(long*) plNumMeteringMode
                   plMeteringMode:(long*) plMeteringMode;

-(long) XSDK_SetMovieMeteringMode:(XSDK_HANDLE) hCamera
                    lMeteringMode:(long) lMeteringMode;

-(long) XSDK_GetMovieMeteringMode:(XSDK_HANDLE) hCamera
                   plMeteringMode:(long*) plMeteringMode;

-(long) XSDK_CapMovieWBMode:(XSDK_HANDLE) hCamera
                plNumWBMode:(long*) plNumWBMode
                   plWBMode:(long*) plWBMode;

-(long) XSDK_SetMovieWBMode:(XSDK_HANDLE) hCamera
                    lWBMode:(long) lWBMode;

-(long) XSDK_GetMovieWBMode:(XSDK_HANDLE) hCamera
                   plWBMode:(long*) plWBMode;

-(long) XSDK_CapMovieWBColorTemp:(XSDK_HANDLE) hCamera
                plNumWBColorTemp:(long*) plNumWBColorTemp
                   plWBColorTemp:(long*) plWBColorTemp;

-(long) XSDK_SetMovieWBColorTemp:(XSDK_HANDLE) hCamera
                      lColorTemp:(long) lColorTemp;

-(long) XSDK_GetMovieWBColorTemp:(XSDK_HANDLE) hCamera
                     plColorTemp:(long*) plColorTemp;

-(long) XSDK_CapProp_PP:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(void*) param1
                 param2:(void*) param2;

-(long) XSDK_CapProp_LPP:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(long) param1
                  param2:(void*) param2
                  param3:(void*) param3;

-(long) XSDK_CapProp_PPPP:(XSDK_HANDLE) hCamera
                 lAPICode:(long) lAPICode
                lAPIParam:(long) lAPIParam
                   param1:(void*) param1
                   param2:(void*) param2
                   param3:(void*) param3
                   param4:(void*) param4;

-(long) XSDK_CapProp_LPPPP:(XSDK_HANDLE) hCamera
                  lAPICode:(long) lAPICode
                 lAPIParam:(long) lAPIParam
                    param1:(long) param1
                    param2:(void*) param2
                    param3:(void*) param3
                    param4:(void*) param4
                    param5:(void*) param5;

-(long) XSDK_CapProp_PPPPPP:(XSDK_HANDLE) hCamera
                   lAPICode:(long) lAPICode
                  lAPIParam:(long) lAPIParam
                     param1:(void*) param1
                     param2:(void*) param2
                     param3:(void*) param3
                     param4:(void*) param4
                     param5:(void*) param5
                     param6:(void*) param6;

-(long) XSDK_SetProp:(XSDK_HANDLE) hCamera
            lAPICode:(long) lAPICode
           lAPIParam:(long) lAPIParam;

-(long) XSDK_SetProp_L:(XSDK_HANDLE) hCamera
              lAPICode:(long) lAPICode
             lAPIParam:(long) lAPIParam
                param1:(long) param1;

-(long) XSDK_SetProp_P:(XSDK_HANDLE) hCamera
              lAPICode:(long) lAPICode
             lAPIParam:(long) lAPIParam
                param1:(void*) param1;

-(long) XSDK_SetProp_S:(XSDK_HANDLE) hCamera
              lAPICode:(long) lAPICode
             lAPIParam:(long) lAPIParam
                param1:(NSString*) param1;

-(long) XSDK_SetProp_LL:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(long) param1
                 param2:(long) param2;

-(long) XSDK_SetProp_LP:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(long) param1
                 param2:(void*) param2;

-(long) XSDK_SetProp_LS:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(long) param1
                 param2:(NSString*) param2;

-(long) XSDK_SetProp_SS:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(NSString*) param1
                 param2:(NSString*) param2;

-(long) XSDK_SetProp_LLL:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(long) param1
                  param2:(long) param2
                  param3:(long) param3;

-(long) XSDK_SetProp_LSL:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(long) param1
                  param2:(NSString*) param2
                  param3:(long) param3;

-(long) XSDK_SetProp_LLLLL:(XSDK_HANDLE) hCamera
                  lAPICode:(long) lAPICode
                 lAPIParam:(long) lAPIParam
                    param1:(long) param1
                    param2:(long) param2
                    param3:(long) param3
                    param4:(long) param4
                    param5:(long) param5;

-(long) XSDK_SetProp_LLLLLL:(XSDK_HANDLE) hCamera
                   lAPICode:(long) lAPICode
                  lAPIParam:(long) lAPIParam
                     param1:(long) param1
                     param2:(long) param2
                     param3:(long) param3
                     param4:(long) param4
                     param5:(long) param5
                     param6:(long) param6;

-(long) XSDK_GetProp_P:(XSDK_HANDLE) hCamera
              lAPICode:(long) lAPICode
             lAPIParam:(long) lAPIParam
                param1:(void*) param1;

-(long) XSDK_GetProp_PP:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(void*) param1
                 param2:(void*) param2;

-(long) XSDK_GetProp_LP:(XSDK_HANDLE) hCamera
               lAPICode:(long) lAPICode
              lAPIParam:(long) lAPIParam
                 param1:(long) param1
                 param2:(void*) param2;

-(long) XSDK_GetProp_PPP:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(void*) param1
                  param2:(void*) param2
                  param3:(void*) param3;

-(long) XSDK_GetProp_LPP:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(long) param1
                  param2:(void*) param2
                  param3:(void*) param3;

-(long) XSDK_GetProp_LLP:(XSDK_HANDLE) hCamera
                lAPICode:(long) lAPICode
               lAPIParam:(long) lAPIParam
                  param1:(long) param1
                  param2:(long) param2
                  param3:(void*) param3;

-(long) XSDK_GetProp_PPPP:(XSDK_HANDLE) hCamera
                 lAPICode:(long) lAPICode
                lAPIParam:(long) lAPIParam
                   param1:(void*) param1
                   param2:(void*) param2
                   param3:(void*) param3
                   param4:(void*) param4;

-(long) XSDK_GetProp_PPLP:(XSDK_HANDLE) hCamera
                 lAPICode:(long) lAPICode
                lAPIParam:(long) lAPIParam
                   param1:(void*) param1
                   param2:(void*) param2
                   param3:(long) param3
                   param4:(void*) param4;

-(long) XSDK_GetProp_LPPPP:(XSDK_HANDLE) hCamera
                  lAPICode:(long) lAPICode
                 lAPIParam:(long) lAPIParam
                    param1:(long) param1
                    param2:(void*) param2
                    param3:(void*) param3
                    param4:(void*) param4
                    param5:(void*) param5;

-(long) XSDK_GetProp_LLLPP:(XSDK_HANDLE) hCamera
                  lAPICode:(long) lAPICode
                 lAPIParam:(long) lAPIParam
                    param1:(long) param1
                    param2:(long) param2
                    param3:(long) param3
                    param4:(void*) param4
                    param5:(void*) param5;

-(long) XSDK_GetProp_PPPPPP:(XSDK_HANDLE) hCamera
                   lAPICode:(long) lAPICode
                  lAPIParam:(long) lAPIParam
                     param1:(void*) param1
                     param2:(void*) param2
                     param3:(void*) param3
                     param4:(void*) param4
                     param5:(void*) param5
                     param6:(void*) param6;

-(long) XSDK_GetProp_PPPPPPPP:(XSDK_HANDLE) hCamera
                     lAPICode:(long) lAPICode
                    lAPIParam:(long) lAPIParam
                       param1:(void*) param1
                       param2:(void*) param2
                       param3:(void*) param3
                       param4:(void*) param4
                       param5:(void*) param5
                       param6:(void*) param6
                       param7:(void*) param7
                       param8:(void*) param8;

@end
