///////////////////////////////////////////////////
//  GFXETERNA55_MOV.h
//     Version 1.0.0.0
//
//     Copyright (C) 2025 FUJIFILM Corporation.
//

#ifndef _XAPIOPT_MOV_H
#include "XAPIOpt_MOV.h"
#define _XAPIOPT_MOV_H
#endif
//
// Structure defines
//

// Movie AFC Custom
//typedef struct SDK_MOVIE_AFC_CUSTOM {
//	long lTracking;
//	long lSpeed;
//} SDK_MOVIE_AFC_CUSTOM;
typedef  SDK_MOVIE_AFC_CUSTOM     GFXETERNA55_SDK_MOVIE_AFC_CUSTOM, *PGFXETERNA55_SDK_MOVIE_AFC_CUSTOM;

// Mic Level Indicator
//typedef    struct SDK_MICLEVEL_INDICATOR{
//	long lDSC_L_Peak;
//	long lDSC_L_PeakHold;
//	long lDSC_R_Peak;
//	long lDSC_R_PeakHold;
//	long lXLR_1_Peak;
//	long lXLR_1_PeakHold;
//	long lXLR_2_Peak;
//	long lXLR_2_PeakHold;
//	long lWarning1;
//	long lWarning2;
//	long lMicLine;
//} SDK_MICLEVEL_INDICATOR;
typedef  SDK_MICLEVEL_INDICATOR     GFXETERNA55_SDK_MICLEVEL_INDICATOR, *PGFXETERNA55_SDK_MICLEVEL_INDICATOR;

// PlayBack Object Info
//typedef    struct SDK_PlayBackObjectInformation{
//	long lFormat;
//	long long llDataSize;
//	long lThumbSize;
//	char strFileName[32];
//	char strcapturedata[20];
//	long lImagePixHeight;
//	long lImagePixWidth;
//	long lImageBitDepth;
//	long Duration;
//} SDK_PlayBackObjectInformation;
typedef  SDK_PlayBackObjectInformation     GFXETERNA55_SDK_PlayBackObjectInformation, *PGFXETERNA55_SDK_PlayBackObjectInformation;

// Focus Map Data
//typedef	struct _SDK_FocusMapData {
//	long lDistance;
//  long lColorR;
//	long lColorG;
//	long lColorB;
//	long lAlpha;
//} SDK_FocusMapData;
typedef  SDK_FocusMapData     GFXETERNA55_SDK_FocusMapData, *PGFXETERNA55_SDK_FocusMapData;

// Tracking Af Frame Info
//typedef struct SDK_TrackingAfFrameInfo {
//	long lX;
//	long lY;
//	long lLength_H;
//	long lLength_V;
//	long lColorR;
//	long lColorG;
//	long lColorB;
//	long lAlpha;
//} SDK_TrackingAfFrameInfo;
typedef  SDK_TrackingAfFrameInfo     GFXETERNA55_SDK_TrackingAfFrameInfo, *PGFXETERNA55_SDK_TrackingAfFrameInfo;

// Histogram Data
//typedef struct SDK_HistogramData {
//	long lLuminance;
//	long lColorR;
//	long lColorG;
//	long lColorB;
//} SDK_HistogramData;
typedef  SDK_HistogramData     GFXETERNA55_SDK_HistogramData, *PGFXETERNA55_SDK_HistogramData;

// Movie WhiteBalance PresetList
//typedef	struct {
//	long lColorTuning;
//	long lCCValue;
//} SDK_MovieWhiteBalancePresetList;
typedef  SDK_MovieWhiteBalancePresetList     GFXETERNA55_SDK_MovieWhiteBalancePresetList, *PGFXETERNA55_SDK_MovieWhiteBalancePresetList;

// Frameio Upload Status
//typedef struct {
//	long    lNetwork;
//	char    strProject[64];
//	char    strUser[32];
//	long    lRemainingFile;
//	long    lRemainingTime;
//	long    lRemainingData;
//	long    lTransferSpeed;
//	long    lCompleteFile;
//	long	lSkipFile;
//	long	lFailureFile;
//} SDK_FrameioUploadStatus;
typedef  SDK_FrameioUploadStatus     GFXETERNA55_SDK_FrameioUploadStatus, *PGFXETERNA55_SDK_FrameioUploadStatus;

// Frameio Transfer Queue
//typedef struct {
//	char    strFileName[255];
//	long	lSlotNumber;
//	long    lTransferStatus;
//	long	lTransferredByte;
//	long	lTotalByte;
//} SDK_FrameioTransferQueue;
typedef  SDK_FrameioTransferQueue     GFXETERNA55_SDK_FrameioTransferQueue, *PGFXETERNA55_SDK_FrameioTransferQueue;

// Movie Frame GuideInfo
//typedef struct SDK_MovieFrameGuideInfo {
//	long lFrameHomePosition1;
//	long lFrameHomePosition2;
//	long lLineLength1;
//	long lLineLength2;
//	long lColorR;
//	long lColorG;
//	long lColorB;
//	long lFrameThickness;
//	long lHorizontalPixel;
//	long lVerticalPixel;
//} SDK_MovieFrameGuideInfo;
typedef  SDK_MovieFrameGuideInfo     GFXETERNA55_SDK_MovieFrameGuideInfo, *PGFXETERNA55_SDK_MovieFrameGuideInfo;

// LUT List
//typedef	struct {
//	char strFlogSetting[255];
//	char strLUTFileName[255];
//} SDK_LUTList;
typedef  SDK_LUTList     GFXETERNA55_SDK_LUTList, *PGFXETERNA55_SDK_LUTList;

// LUT Settings UserFileList
//typedef struct SDK_LUTSettingsUserFileList {
//	char strUserLUT1[256];
//	char strUserLUT2[256];
//	char strUserLUT3[256];
//	char strUserLUT4[256];
//	char strUserLUT5[256];
//	char strUserLUT6[256];
//	char strUserLUT7[256];
//	char strUserLUT8[256];
//	char strUserLUT9[256];
//	char strUserLUT10[256];
//	char strUserLUT11[256];
//	char strUserLUT12[256];
//	char strUserLUT13[256];
//	char strUserLUT14[256];
//	char strUserLUT15[256];
//	char strUserLUT16[256];
//} SDK_LUTSettingsUserFileList;
typedef  SDK_LUTSettingsUserFileList     GFXETERNA55_SDK_LUTSettingsUserFileList, *PGFXETERNA55_SDK_LUTSettingsUserFileList;


//
// API_PARAM for GFXETERNA55
//
enum {
	GFXETERNA55_API_PARAM_CapMovieHighFrequencyFlickerlessMode = 2,
	GFXETERNA55_API_PARAM_SetMovieHighFrequencyFlickerlessMode = 1,
	GFXETERNA55_API_PARAM_GetMovieHighFrequencyFlickerlessMode = 1,
	GFXETERNA55_API_PARAM_CapMovieAFMode                       = 2,
	GFXETERNA55_API_PARAM_SetMovieAFMode                       = 1,
	GFXETERNA55_API_PARAM_GetMovieAFMode                       = 1,
	GFXETERNA55_API_PARAM_CapMovieFocusArea                    = 3,
	GFXETERNA55_API_PARAM_SetMovieFocusArea                    = 2,
	GFXETERNA55_API_PARAM_GetMovieFocusArea                    = 2,
	GFXETERNA55_API_PARAM_GetTrackingAfFrameInfo               = 1,
	GFXETERNA55_API_PARAM_CapMovieResolution                   = 2,
	GFXETERNA55_API_PARAM_SetMovieResolution                   = 1,
	GFXETERNA55_API_PARAM_GetMovieResolution                   = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameRate                    = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameRate                    = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameRate                    = 1,
	GFXETERNA55_API_PARAM_CapMovieBitRate                      = 2,
	GFXETERNA55_API_PARAM_SetMovieBitRate                      = 1,
	GFXETERNA55_API_PARAM_GetMovieBitRate                      = 1,
	GFXETERNA55_API_PARAM_CapMovieFileFormat                   = 2,
	GFXETERNA55_API_PARAM_SetMovieFileFormat                   = 1,
	GFXETERNA55_API_PARAM_GetMovieFileFormat                   = 1,
	GFXETERNA55_API_PARAM_CapHighSpeedRecMode                  = -1,
	GFXETERNA55_API_PARAM_SetHighSpeedRecMode                  = -1,
	GFXETERNA55_API_PARAM_GetHighSpeedRecMode                  = -1,
	GFXETERNA55_API_PARAM_CapHighSpeedRecResolution            = -1,
	GFXETERNA55_API_PARAM_SetHighSpeedRecResolution            = -1,
	GFXETERNA55_API_PARAM_GetHighSpeedRecResolution            = -1,
	GFXETERNA55_API_PARAM_CapHighSpeedRecFrameRate             = -1,
	GFXETERNA55_API_PARAM_SetHighSpeedRecFrameRate             = -1,
	GFXETERNA55_API_PARAM_GetHighSpeedRecFrameRate             = -1,
	GFXETERNA55_API_PARAM_CapHighSpeedRecPlayBackFrameRate     = -1,
	GFXETERNA55_API_PARAM_SetHighSpeedRecPlayBackFrameRate     = -1,
	GFXETERNA55_API_PARAM_GetHighSpeedRecPlayBackFrameRate     = -1,
	GFXETERNA55_API_PARAM_CapMovieMediaRecord                  = 2,
	GFXETERNA55_API_PARAM_SetMovieMediaRecord                  = 1,
	GFXETERNA55_API_PARAM_GetMovieMediaRecord                  = 1,
	GFXETERNA55_API_PARAM_CapMovieMediaRecordProRes            = 2,
	GFXETERNA55_API_PARAM_SetMovieMediaRecordProRes            = 1,
	GFXETERNA55_API_PARAM_GetMovieMediaRecordProRes            = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIOutputRAW                = 2,
	GFXETERNA55_API_PARAM_SetMovieHDMIOutputRAW                = 1,
	GFXETERNA55_API_PARAM_GetMovieHDMIOutputRAW                = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIOutputRAWResolution      = 2,
	GFXETERNA55_API_PARAM_SetMovieHDMIOutputRAWResolution      = 1,
	GFXETERNA55_API_PARAM_GetMovieHDMIOutputRAWResolution      = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIOutputRAWFrameRate       = -1,
	GFXETERNA55_API_PARAM_SetMovieHDMIOutputRAWFrameRate       = -1,
	GFXETERNA55_API_PARAM_GetMovieHDMIOutputRAWFrameRate       = -1,
	GFXETERNA55_API_PARAM_CapFlogRecording                     = 2,
	GFXETERNA55_API_PARAM_SetFlogRecording                     = 1,
	GFXETERNA55_API_PARAM_GetFlogRecording                     = 1,
	GFXETERNA55_API_PARAM_CapMovieCropMagnification            = 2,
	GFXETERNA55_API_PARAM_SetMovieCropMagnification            = 1,
	GFXETERNA55_API_PARAM_GetMovieCropMagnification            = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIOutputInfoDisplay        = 2,
	GFXETERNA55_API_PARAM_SetMovieHDMIOutputInfoDisplay        = 1,
	GFXETERNA55_API_PARAM_GetMovieHDMIOutputInfoDisplay        = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIRecControl               = 2,
	GFXETERNA55_API_PARAM_SetMovieHDMIRecControl               = 1,
	GFXETERNA55_API_PARAM_GetMovieHDMIRecControl               = 1,
	GFXETERNA55_API_PARAM_CapMovieIsMode                       = 2,
	GFXETERNA55_API_PARAM_SetMovieIsMode                       = 1,
	GFXETERNA55_API_PARAM_GetMovieIsMode                       = 1,
	GFXETERNA55_API_PARAM_CapMovieIsModeBoost                  = 2,
	GFXETERNA55_API_PARAM_SetMovieIsModeBoost                  = 1,
	GFXETERNA55_API_PARAM_GetMovieIsModeBoost                  = 1,
	GFXETERNA55_API_PARAM_CapMovieZebraSetting                 = 2,
	GFXETERNA55_API_PARAM_SetMovieZebraSetting                 = 1,
	GFXETERNA55_API_PARAM_GetMovieZebraSetting                 = 1,
	GFXETERNA55_API_PARAM_CapMovieZebraLevel                   = 2,
	GFXETERNA55_API_PARAM_SetMovieZebraLevel                   = 1,
	GFXETERNA55_API_PARAM_GetMovieZebraLevel                   = 1,
	GFXETERNA55_API_PARAM_CapMovieOptimizedControl             = 2,
	GFXETERNA55_API_PARAM_SetMovieOptimizedControl             = 1,
	GFXETERNA55_API_PARAM_GetMovieOptimizedControl             = 1,
	GFXETERNA55_API_PARAM_CapMovieTallyLight                   = 2,
	GFXETERNA55_API_PARAM_SetMovieTallyLight                   = 1,
	GFXETERNA55_API_PARAM_GetMovieTallyLight                   = 1,
	GFXETERNA55_API_PARAM_GetMediaEjectWarning                 = 1,
	GFXETERNA55_API_PARAM_CapMovieDataLevelSetting             = 2,
	GFXETERNA55_API_PARAM_SetMovieDataLevelSetting             = 1,
	GFXETERNA55_API_PARAM_GetMovieDataLevelSetting             = 1,
	GFXETERNA55_API_PARAM_GetMovieCropMagnificationValue       = 1,
	GFXETERNA55_API_PARAM_CapMovieFullTimeManual               = 2,
	GFXETERNA55_API_PARAM_SetMovieFullTimeManual               = 1,
	GFXETERNA55_API_PARAM_GetMovieFullTimeManual               = 1,
	GFXETERNA55_API_PARAM_CapMovieDigitalZoom                  = 2,
	GFXETERNA55_API_PARAM_SetMovieDigitalZoom                  = 1,
	GFXETERNA55_API_PARAM_GetMovieDigitalZoom                  = 1,
	GFXETERNA55_API_PARAM_GetMovieDigitalZoomRange             = 3,
	GFXETERNA55_API_PARAM_CapMovieImageFormat                  = 2,
	GFXETERNA55_API_PARAM_SetMovieImageFormat                  = 1,
	GFXETERNA55_API_PARAM_GetMovieImageFormat                  = 1,
	GFXETERNA55_API_PARAM_GetHistogramData                     = 2,
	GFXETERNA55_API_PARAM_GetFocusMapData                      = 2,
	GFXETERNA55_API_PARAM_CapWaveFormVectorScope               = 2,
	GFXETERNA55_API_PARAM_SetWaveFormVectorScope               = 1,
	GFXETERNA55_API_PARAM_GetWaveFormVectorScope               = 1,
	GFXETERNA55_API_PARAM_GetWaveFormData                      = 2,
	GFXETERNA55_API_PARAM_GetVectorScopeData                   = 2,
	GFXETERNA55_API_PARAM_GetParadeData                        = 2,
	GFXETERNA55_API_PARAM_CapRecFrameIndicator                 = 2,
	GFXETERNA55_API_PARAM_SetRecFrameIndicator                 = 1,
	GFXETERNA55_API_PARAM_GetRecFrameIndicator                 = 1,
	GFXETERNA55_API_PARAM_CapMovieCaptureDelay                 = 2,
	GFXETERNA55_API_PARAM_SetMovieCaptureDelay                 = 1,
	GFXETERNA55_API_PARAM_GetMovieCaptureDelay                 = 1,
	GFXETERNA55_API_PARAM_CapAnamorphicDesqueezeDisplay        = 2,
	GFXETERNA55_API_PARAM_SetAnamorphicDesqueezeDisplay        = 1,
	GFXETERNA55_API_PARAM_GetAnamorphicDesqueezeDisplay        = 1,
	GFXETERNA55_API_PARAM_CapAnamorphicMagnification           = 2,
	GFXETERNA55_API_PARAM_SetAnamorphicMagnification           = 1,
	GFXETERNA55_API_PARAM_GetAnamorphicMagnification           = 1,
	GFXETERNA55_API_PARAM_CapWaveFormSetting                   = 2,
	GFXETERNA55_API_PARAM_SetWaveFormSetting                   = 1,
	GFXETERNA55_API_PARAM_GetWaveFormSetting                   = 1,
	GFXETERNA55_API_PARAM_CapVectorScopeSetting                = 2,
	GFXETERNA55_API_PARAM_SetVectorScopeSetting                = 1,
	GFXETERNA55_API_PARAM_GetVectorScopeSetting                = 1,
	GFXETERNA55_API_PARAM_CapParadeSettingDisplay              = 2,
	GFXETERNA55_API_PARAM_SetParadeSettingDisplay              = 1,
	GFXETERNA55_API_PARAM_GetParadeSettingDisplay              = 1,
	GFXETERNA55_API_PARAM_CapParadeSettingColor                = 2,
	GFXETERNA55_API_PARAM_SetParadeSettingColor                = 1,
	GFXETERNA55_API_PARAM_GetParadeSettingColor                = 1,
	GFXETERNA55_API_PARAM_CapFlogDRangePriority                = 2,
	GFXETERNA55_API_PARAM_SetFlogDRangePriority                = 1,
	GFXETERNA55_API_PARAM_GetFlogDRangePriority                = 1,
	GFXETERNA55_API_PARAM_CapMovieWhiteBalanceTune             = -1,
	GFXETERNA55_API_PARAM_SetMovieWhiteBalanceTune             = -1,
	GFXETERNA55_API_PARAM_GetMovieWhiteBalanceTune             = -1,
	GFXETERNA55_API_PARAM_CapMovieFilmSimulationMode           = 2,
	GFXETERNA55_API_PARAM_SetMovieFilmSimulationMode           = 1,
	GFXETERNA55_API_PARAM_GetMovieFilmSimulationMode           = 1,
	GFXETERNA55_API_PARAM_CapMovieMonochromaticColor           = 4,
	GFXETERNA55_API_PARAM_SetMovieMonochromaticColor           = 2,
	GFXETERNA55_API_PARAM_GetMovieMonochromaticColor           = 2,
	GFXETERNA55_API_PARAM_CapMovieHighLightTone                = 2,
	GFXETERNA55_API_PARAM_SetMovieHighLightTone                = 1,
	GFXETERNA55_API_PARAM_GetMovieHighLightTone                = 1,
	GFXETERNA55_API_PARAM_CapMovieShadowTone                   = 2,
	GFXETERNA55_API_PARAM_SetMovieShadowTone                   = 1,
	GFXETERNA55_API_PARAM_GetMovieShadowTone                   = 1,
	GFXETERNA55_API_PARAM_CapMovieSharpness                    = 2,
	GFXETERNA55_API_PARAM_SetMovieSharpness                    = 1,
	GFXETERNA55_API_PARAM_GetMovieSharpness                    = 1,
	GFXETERNA55_API_PARAM_CapMovieColorMode                    = 2,
	GFXETERNA55_API_PARAM_SetMovieColorMode                    = 1,
	GFXETERNA55_API_PARAM_GetMovieColorMode                    = 1,
	GFXETERNA55_API_PARAM_CapMovieNoiseReduction               = 2,
	GFXETERNA55_API_PARAM_SetMovieNoiseReduction               = 1,
	GFXETERNA55_API_PARAM_GetMovieNoiseReduction               = 1,
	GFXETERNA55_API_PARAM_CapInterFrameNR                      = 2,
	GFXETERNA55_API_PARAM_SetInterFrameNR                      = 1,
	GFXETERNA55_API_PARAM_GetInterFrameNR                      = 1,
	GFXETERNA55_API_PARAM_CapMoviePeripheralLightCorrection    = 2,
	GFXETERNA55_API_PARAM_SetMoviePeripheralLightCorrection    = 1,
	GFXETERNA55_API_PARAM_GetMoviePeripheralLightCorrection    = 1,
	GFXETERNA55_API_PARAM_CapMovieFaceDetectionMode            = -1,
	GFXETERNA55_API_PARAM_SetMovieFaceDetectionMode            = -1,
	GFXETERNA55_API_PARAM_GetMovieFaceDetectionMode            = -1,
	GFXETERNA55_API_PARAM_CapMovieEyeAFMode                    = -1,
	GFXETERNA55_API_PARAM_SetMovieEyeAFMode                    = -1,
	GFXETERNA55_API_PARAM_GetMovieEyeAFMode                    = -1,
	GFXETERNA55_API_PARAM_CapMovieSubjectDetectionMode         = 2,
	GFXETERNA55_API_PARAM_SetMovieSubjectDetectionMode         = 1,
	GFXETERNA55_API_PARAM_GetMovieSubjectDetectionMode         = 1,
	GFXETERNA55_API_PARAM_CapMovieAFCCustom                    = 2,
	GFXETERNA55_API_PARAM_SetMovieAFCCustom                    = 1,
	GFXETERNA55_API_PARAM_GetMovieAFCCustom                    = 1,
	GFXETERNA55_API_PARAM_CapMovieMFAssistMode                 = 2,
	GFXETERNA55_API_PARAM_SetMovieMFAssistMode                 = 1,
	GFXETERNA55_API_PARAM_GetMovieMFAssistMode                 = 1,
	GFXETERNA55_API_PARAM_GetMovieFocusMeter                   = -1,
	GFXETERNA55_API_PARAM_CapMovieFocusCheckMode               = 2,
	GFXETERNA55_API_PARAM_SetMovieFocusCheckMode               = 1,
	GFXETERNA55_API_PARAM_GetMovieFocusCheckMode               = 1,
	GFXETERNA55_API_PARAM_CapMovieFocusCheckLock               = 2,
	GFXETERNA55_API_PARAM_SetMovieFocusCheckLock               = 1,
	GFXETERNA55_API_PARAM_GetMovieFocusCheckLock               = 1,
	GFXETERNA55_API_PARAM_GetMovieRecordingTime                = 3,
	GFXETERNA55_API_PARAM_GetMovieRemainingTime                = 3,
	GFXETERNA55_API_PARAM_GetTimeCode                          = 4,
	GFXETERNA55_API_PARAM_CapTimeCodeDisplay                   = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeDisplay                   = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeDisplay                   = 1,
	GFXETERNA55_API_PARAM_CapTimeCodeStartSetting              = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeStartSetting              = 5,
	GFXETERNA55_API_PARAM_CapTimeCodeCountUp                   = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeCountUp                   = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeCountUp                   = 1,
	GFXETERNA55_API_PARAM_CapTimeCodeDropFrame                 = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeDropFrame                 = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeDropFrame                 = 1,
	GFXETERNA55_API_PARAM_CapTimeCodeHDMIOutput                = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeHDMIOutput                = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeHDMIOutput                = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeCurrentValue              = 4,
	GFXETERNA55_API_PARAM_CapATOMOSAirGluConnection            = 2,
	GFXETERNA55_API_PARAM_SetATOMOSAirGluConnection            = 1,
	GFXETERNA55_API_PARAM_GetATOMOSAirGluConnection            = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeStatus                    = 1,
	GFXETERNA55_API_PARAM_CapInternalMicLevel                  = 2,
	GFXETERNA55_API_PARAM_SetInternalMicLevel                  = 1,
	GFXETERNA55_API_PARAM_GetInternalMicLevel                  = 1,
	GFXETERNA55_API_PARAM_CapInternalMicLevelManual            = 2,
	GFXETERNA55_API_PARAM_SetInternalMicLevelManual            = 1,
	GFXETERNA55_API_PARAM_GetInternalMicLevelManual            = 1,
	GFXETERNA55_API_PARAM_CapExternalMicLevel                  = 2,
	GFXETERNA55_API_PARAM_SetExternalMicLevel                  = 1,
	GFXETERNA55_API_PARAM_GetExternalMicLevel                  = 1,
	GFXETERNA55_API_PARAM_CapExternalMicLevelManual            = 2,
	GFXETERNA55_API_PARAM_SetExternalMicLevelManual            = 1,
	GFXETERNA55_API_PARAM_GetExternalMicLevelManual            = 1,
	GFXETERNA55_API_PARAM_CapMicLevelLimiter                   = 2,
	GFXETERNA55_API_PARAM_SetMicLevelLimiter                   = 1,
	GFXETERNA55_API_PARAM_GetMicLevelLimiter                   = 1,
	GFXETERNA55_API_PARAM_CapWindFilter                        = 2,
	GFXETERNA55_API_PARAM_SetWindFilter                        = 1,
	GFXETERNA55_API_PARAM_GetWindFilter                        = 1,
	GFXETERNA55_API_PARAM_CapLowCutFilter                      = 2,
	GFXETERNA55_API_PARAM_SetLowCutFilter                      = 1,
	GFXETERNA55_API_PARAM_GetLowCutFilter                      = 1,
	GFXETERNA55_API_PARAM_CapHeadPhonesVolume                  = 2,
	GFXETERNA55_API_PARAM_SetHeadPhonesVolume                  = 1,
	GFXETERNA55_API_PARAM_GetHeadPhonesVolume                  = 1,
	GFXETERNA55_API_PARAM_CapXLRAdapterMicSource               = 2,
	GFXETERNA55_API_PARAM_SetXLRAdapterMicSource               = 1,
	GFXETERNA55_API_PARAM_GetXLRAdapterMicSource               = 1,
	GFXETERNA55_API_PARAM_CapXLRAdapterMoniteringSource        = 2,
	GFXETERNA55_API_PARAM_SetXLRAdapterMoniteringSource        = 1,
	GFXETERNA55_API_PARAM_GetXLRAdapterMoniteringSource        = 1,
	GFXETERNA55_API_PARAM_CapXLRAdapterHDMIOutputSource        = 2,
	GFXETERNA55_API_PARAM_SetXLRAdapterHDMIOutputSource        = 1,
	GFXETERNA55_API_PARAM_GetXLRAdapterHDMIOutputSource        = 1,
	GFXETERNA55_API_PARAM_GetMicLevelIndicator                 = 1,
	GFXETERNA55_API_PARAM_GetMovieTransparentFrameInfo         = -1,
	GFXETERNA55_API_PARAM_CapShortMovieSecond                  = -1,
	GFXETERNA55_API_PARAM_SetShortMovieSecond                  = -1,
	GFXETERNA55_API_PARAM_GetShortMovieSecond                  = -1,
	GFXETERNA55_API_PARAM_CapMoviePortraitEnhancer             = -1,
	GFXETERNA55_API_PARAM_SetMoviePortraitEnhancer             = -1,
	GFXETERNA55_API_PARAM_GetMoviePortraitEnhancer             = -1,
	GFXETERNA55_API_PARAM_CapDirectionalMic                    = -1,
	GFXETERNA55_API_PARAM_SetDirectionalMic                    = -1,
	GFXETERNA55_API_PARAM_GetDirectionalMic                    = -1,
	GFXETERNA55_API_PARAM_CapEnvSoundsNR                       = -1,
	GFXETERNA55_API_PARAM_SetEnvSoundsNR                       = -1,
	GFXETERNA55_API_PARAM_GetEnvSoundsNR                       = -1,
	GFXETERNA55_API_PARAM_GetBodyTemperatureWarning            = 1,
	GFXETERNA55_API_PARAM_GetPlayBackMediaInfo                 = -1,
	GFXETERNA55_API_PARAM_GetPlayBackObjectInfo                = -1,
	GFXETERNA55_API_PARAM_GetPlayBackThumb                     = -1,
	GFXETERNA55_API_PARAM_GetPlayBackPartialObject             = -1,
	GFXETERNA55_API_PARAM_CapMovieRecVolume                    = 2,
	GFXETERNA55_API_PARAM_SetMovieRecVolume                    = 1,
	GFXETERNA55_API_PARAM_GetMovieRecVolume                    = 1,
	GFXETERNA55_API_PARAM_GetMovieExposureIndexCurrentValue    = 1,
	GFXETERNA55_API_PARAM_CapMovieProjectFrameRate             = 2,
	GFXETERNA55_API_PARAM_SetMovieProjectFrameRate             = 1,
	GFXETERNA55_API_PARAM_GetMovieProjectFrameRate             = 1,
	GFXETERNA55_API_PARAM_CapMovieHDMIOutput                   = 2,
	GFXETERNA55_API_PARAM_SetMovieHDMIOutput                   = 1,
	GFXETERNA55_API_PARAM_GetMovieHDMIOutput                   = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideCenterMarkerColor  = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideCenterMarkerColor  = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideCenterMarkerColor  = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideCenterMarkerThickness= 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideCenterMarkerThickness= 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideCenterMarkerThickness= 1,
	GFXETERNA55_API_PARAM_CapLUTSettings                        = 3,
	GFXETERNA55_API_PARAM_SetLUTSettings                        = 2,
	GFXETERNA55_API_PARAM_GetLUTSettings                        = 2,
	GFXETERNA55_API_PARAM_CapMovieMediaRecordContainer          = 2,
	GFXETERNA55_API_PARAM_SetMovieMediaRecordContainer          = 1,
	GFXETERNA55_API_PARAM_GetMovieMediaRecordContainer          = 1,
	GFXETERNA55_API_PARAM_SetClipSetting                        = 1,
	GFXETERNA55_API_PARAM_GetClipSetting                        = 1,
	GFXETERNA55_API_PARAM_CapGenlockSetting                     = 2,
	GFXETERNA55_API_PARAM_SetGenlockSetting                     = 1,
	GFXETERNA55_API_PARAM_GetGenlockSetting                     = 1,
	GFXETERNA55_API_PARAM_CapTimeCodeSyncSetting                = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeSyncSetting                = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeSyncSetting                = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideDisplay             = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideDisplay             = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideDisplay             = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideAspect              = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideAspect              = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideAspect              = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideColor               = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideColor               = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideColor               = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideLineThickness       = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideLineThickness       = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideLineThickness       = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideMask                = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideMask                = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideMask                = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideTransparency        = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideTransparency        = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideTransparency        = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideCenterMarker        = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideCenterMarker        = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideCenterMarker        = 1,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideCustom              = 2,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideCustom              = 2,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideInfo                = 2,
	GFXETERNA55_API_PARAM_CapBatteryWarningPercent              = 2,
	GFXETERNA55_API_PARAM_SetBatteryWarningPercent              = 1,
	GFXETERNA55_API_PARAM_GetBatteryWarningPercent              = 1,
	GFXETERNA55_API_PARAM_CapBatteryWarningVoltage              = 2,
	GFXETERNA55_API_PARAM_SetBatteryWarningVoltage              = 1,
	GFXETERNA55_API_PARAM_GetBatteryWarningVoltage              = 1,
	GFXETERNA55_API_PARAM_GetBatteryVoltageInfo                 = 1,
	GFXETERNA55_API_PARAM_SetMovieWhiteBalancePreset            = 4,
	GFXETERNA55_API_PARAM_CapMovieShutterDisplay                = 2,
	GFXETERNA55_API_PARAM_SetMovieShutterDisplay                = 1,
	GFXETERNA55_API_PARAM_GetMovieShutterDisplay                = 1,
	GFXETERNA55_API_PARAM_CapMovieShutterAngle		            = 2,
	GFXETERNA55_API_PARAM_SetMovieShutterAngle                  = 1,
	GFXETERNA55_API_PARAM_GetMovieShutterAngle                  = 1,
	GFXETERNA55_API_PARAM_CapFanStopDuringRec                   = 2,
	GFXETERNA55_API_PARAM_SetFanStopDuringRec                   = 1,
	GFXETERNA55_API_PARAM_GetFanStopDuringRec                   = 1,
	GFXETERNA55_API_PARAM_GetClipDisplay                        = 1,
	GFXETERNA55_API_PARAM_CapMovieNDMode                        = 2,
	GFXETERNA55_API_PARAM_SetMovieNDMode                        = 1,
	GFXETERNA55_API_PARAM_GetMovieNDMode                        = 1,
	GFXETERNA55_API_PARAM_CapMovieNDDisplay                     = 2,
	GFXETERNA55_API_PARAM_SetMovieNDDisplay                     = 1,
	GFXETERNA55_API_PARAM_GetMovieNDDisplay                     = 1,
	GFXETERNA55_API_PARAM_CapMovieNDDensity                     = 2,
	GFXETERNA55_API_PARAM_SetMovieNDDensity                     = 1,
	GFXETERNA55_API_PARAM_GetMovieNDDensity                     = 1,
	GFXETERNA55_API_PARAM_CapMovieNDFactor                      = 2,
	GFXETERNA55_API_PARAM_SetMovieNDFactor                      = 1,
	GFXETERNA55_API_PARAM_GetMovieNDFactor                      = 1,
	GFXETERNA55_API_PARAM_GetLUTList                            = 3,
	GFXETERNA55_API_PARAM_GetMovieWhiteBalancePresetList        = 3,
	GFXETERNA55_API_PARAM_CapSDIOutput                          = 2,
	GFXETERNA55_API_PARAM_SetSDIOutput                          = 1,
	GFXETERNA55_API_PARAM_GetSDIOutput                          = 1,
	GFXETERNA55_API_PARAM_CapSDIRecControl                      = 2,
	GFXETERNA55_API_PARAM_SetSDIRecControl                      = 1,
	GFXETERNA55_API_PARAM_GetSDIRecControl                      = 1,
	GFXETERNA55_API_PARAM_CapMovieTNumber                       = 2,
	GFXETERNA55_API_PARAM_SetMovieTNumber                       = 1,
	GFXETERNA55_API_PARAM_GetMovieTNumber                       = 1,
	GFXETERNA55_API_PARAM_CapRGBHistogramDisplay                = 2,
	GFXETERNA55_API_PARAM_SetRGBHistogramDisplay                = 1,
	GFXETERNA55_API_PARAM_GetRGBHistogramDisplay                = 1,
	GFXETERNA55_API_PARAM_CapHistogramDisplay                   = 2,
	GFXETERNA55_API_PARAM_SetHistogramDisplay                   = 1,
	GFXETERNA55_API_PARAM_GetHistogramDisplay                   = 1,
	GFXETERNA55_API_PARAM_CapSDIHDMIOutputFps                   = 2,
	GFXETERNA55_API_PARAM_SetSDIHDMIOutputFps                   = 1,
	GFXETERNA55_API_PARAM_GetSDIHDMIOutputFps                   = 1,
	GFXETERNA55_API_PARAM_CapFanHighSpeedOutput                 = 2,
	GFXETERNA55_API_PARAM_SetFanHighSpeedOutput                 = 1,
	GFXETERNA55_API_PARAM_GetFanHighSpeedOutput                 = 1,
	GFXETERNA55_API_PARAM_CapFanLowSpeedOutput                  = 2,
	GFXETERNA55_API_PARAM_SetFanLowSpeedOutput                  = 1,
	GFXETERNA55_API_PARAM_GetFanLowSpeedOutput                  = 1,
	GFXETERNA55_API_PARAM_CapLookMode                           = 2,
	GFXETERNA55_API_PARAM_SetLookMode                           = 1,
	GFXETERNA55_API_PARAM_GetLookMode                           = 1,
	GFXETERNA55_API_PARAM_GetGenlockStatus                      = 1,
	GFXETERNA55_API_PARAM_GetMovieFNumberCurrentValue           = 1,
	GFXETERNA55_API_PARAM_GetMovieTNumberCurrentValue           = 1,
	GFXETERNA55_API_PARAM_CapTimeCodeConnector                  = 2,
	GFXETERNA55_API_PARAM_SetTimeCodeConnector                  = 1,
	GFXETERNA55_API_PARAM_GetTimeCodeConnector                  = 1,
	GFXETERNA55_API_PARAM_GetMovieSensitivityFDGain             = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideMode                = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideMode                = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideMode                = 1,
	GFXETERNA55_API_PARAM_CapMovieFrameGuideScale               = 2,
	GFXETERNA55_API_PARAM_SetMovieFrameGuideScale               = 1,
	GFXETERNA55_API_PARAM_GetMovieFrameGuideScale               = 1,
	GFXETERNA55_API_PARAM_GetLUTSettingsUserFileList            = 2,
	GFXETERNA55_API_PARAM_CapFrameGuideDisplayAll               = 2,
	GFXETERNA55_API_PARAM_SetFrameGuideDisplayAll               = 1,
	GFXETERNA55_API_PARAM_GetFrameGuideDisplayAll               = 1,
	GFXETERNA55_API_PARAM_CapFrameGuideMaskFrame                = 2,
	GFXETERNA55_API_PARAM_SetFrameGuideMaskFrame                = 1,
	GFXETERNA55_API_PARAM_GetFrameGuideMaskFrame                = 1,
	GFXETERNA55_API_PARAM_CapFrameGuideCenterMarkerPattern      = 2,
	GFXETERNA55_API_PARAM_SetFrameGuideCenterMarkerPattern      = 1,
	GFXETERNA55_API_PARAM_GetFrameGuideCenterMarkerPattern      = 1,
	GFXETERNA55_API_PARAM_CapFrameioFunction                    = 2,
	GFXETERNA55_API_PARAM_SetFrameioFunction                    = 1,
	GFXETERNA55_API_PARAM_GetFrameioFunction                    = 1,
	GFXETERNA55_API_PARAM_GetFrameioPairingCode                 = 1,
	GFXETERNA55_API_PARAM_CapFrameioFileType                    = 2,
	GFXETERNA55_API_PARAM_SetFrameioFileType                    = 1,
	GFXETERNA55_API_PARAM_GetFrameioFileType                    = 1,
	GFXETERNA55_API_PARAM_CapFrameioAutoImageTransfer           = 2,
	GFXETERNA55_API_PARAM_SetFrameioAutoImageTransfer           = 1,
	GFXETERNA55_API_PARAM_GetFrameioAutoImageTransfer           = 1,
	GFXETERNA55_API_PARAM_CapFrameioTransferSuspend             = 2,
	GFXETERNA55_API_PARAM_SetFrameioTransferSuspend             = 1,
	GFXETERNA55_API_PARAM_GetFrameioTransferSuspend             = 1,
	GFXETERNA55_API_PARAM_CapFrameioImageTransferWhilePowerOff  = 2,
	GFXETERNA55_API_PARAM_SetFrameioImageTransferWhilePowerOff  = 1,
	GFXETERNA55_API_PARAM_GetFrameioImageTransferWhilePowerOff  = 1,
	GFXETERNA55_API_PARAM_GetFrameioUploadStatus                = 1,
	GFXETERNA55_API_PARAM_GetFrameioTransferQueue               = 2,
	GFXETERNA55_API_PARAM_CapFrameioResetTransferOrder          = 2,
	GFXETERNA55_API_PARAM_SetFrameioResetTransferOrder          = 1,
	GFXETERNA55_API_PARAM_GetFrameioConnectionStatus            = 1,
	GFXETERNA55_API_PARAM_CapPlayBackFileFormat                 = 2,
	GFXETERNA55_API_PARAM_SetPlayBackFileFormat                 = 1,
	GFXETERNA55_API_PARAM_GetPlayBackFileFormat                 = 1,
};

//
// API_CODE for GFXETERNA55
//
enum {
	GFXETERNA55_API_CODE_CapMovieHighFrequencyFlickerlessMode   = API_CODE_CapMovieHighFrequencyFlickerlessMode,
	GFXETERNA55_API_CODE_SetMovieHighFrequencyFlickerlessMode   = API_CODE_SetMovieHighFrequencyFlickerlessMode,
	GFXETERNA55_API_CODE_GetMovieHighFrequencyFlickerlessMode   = API_CODE_GetMovieHighFrequencyFlickerlessMode,
	GFXETERNA55_API_CODE_CapMovieAFMode                         = API_CODE_CapMovieAFMode,
	GFXETERNA55_API_CODE_SetMovieAFMode                         = API_CODE_SetMovieAFMode,
	GFXETERNA55_API_CODE_GetMovieAFMode                         = API_CODE_GetMovieAFMode,
	GFXETERNA55_API_CODE_CapMovieFocusArea                      = API_CODE_CapMovieFocusArea,
	GFXETERNA55_API_CODE_SetMovieFocusArea                      = API_CODE_SetMovieFocusArea,
	GFXETERNA55_API_CODE_GetMovieFocusArea                      = API_CODE_GetMovieFocusArea,
	GFXETERNA55_API_CODE_GetTrackingAfFrameInfo                 = API_CODE_GetTrackingAfFrameInfo,
	GFXETERNA55_API_CODE_CapMovieResolution                     = API_CODE_CapMovieResolution,
	GFXETERNA55_API_CODE_SetMovieResolution                     = API_CODE_SetMovieResolution,
	GFXETERNA55_API_CODE_GetMovieResolution                     = API_CODE_GetMovieResolution,
	GFXETERNA55_API_CODE_CapMovieFrameRate                      = API_CODE_CapMovieFrameRate,
	GFXETERNA55_API_CODE_SetMovieFrameRate                      = API_CODE_SetMovieFrameRate,
	GFXETERNA55_API_CODE_GetMovieFrameRate                      = API_CODE_GetMovieFrameRate,
	GFXETERNA55_API_CODE_CapMovieBitRate                        = API_CODE_CapMovieBitRate,
	GFXETERNA55_API_CODE_SetMovieBitRate                        = API_CODE_SetMovieBitRate,
	GFXETERNA55_API_CODE_GetMovieBitRate                        = API_CODE_GetMovieBitRate,
	GFXETERNA55_API_CODE_CapMovieFileFormat                     = API_CODE_CapMovieFileFormat,
	GFXETERNA55_API_CODE_SetMovieFileFormat                     = API_CODE_SetMovieFileFormat,
	GFXETERNA55_API_CODE_GetMovieFileFormat                     = API_CODE_GetMovieFileFormat,
	GFXETERNA55_API_CODE_CapHighSpeedRecMode                    = API_CODE_CapHighSpeedRecMode,
	GFXETERNA55_API_CODE_SetHighSpeedRecMode                    = API_CODE_SetHighSpeedRecMode,
	GFXETERNA55_API_CODE_GetHighSpeedRecMode                    = API_CODE_GetHighSpeedRecMode,
	GFXETERNA55_API_CODE_CapHighSpeedRecResolution              = API_CODE_CapHighSpeedRecResolution,
	GFXETERNA55_API_CODE_SetHighSpeedRecResolution              = API_CODE_SetHighSpeedRecResolution,
	GFXETERNA55_API_CODE_GetHighSpeedRecResolution              = API_CODE_GetHighSpeedRecResolution,
	GFXETERNA55_API_CODE_CapHighSpeedRecFrameRate               = API_CODE_CapHighSpeedRecFrameRate,
	GFXETERNA55_API_CODE_SetHighSpeedRecFrameRate               = API_CODE_SetHighSpeedRecFrameRate,
	GFXETERNA55_API_CODE_GetHighSpeedRecFrameRate               = API_CODE_GetHighSpeedRecFrameRate,
	GFXETERNA55_API_CODE_CapHighSpeedRecPlayBackFrameRate       = API_CODE_CapHighSpeedRecPlayBackFrameRate,
	GFXETERNA55_API_CODE_SetHighSpeedRecPlayBackFrameRate       = API_CODE_SetHighSpeedRecPlayBackFrameRate,
	GFXETERNA55_API_CODE_GetHighSpeedRecPlayBackFrameRate       = API_CODE_GetHighSpeedRecPlayBackFrameRate,
	GFXETERNA55_API_CODE_CapMovieMediaRecord                    = API_CODE_CapMovieMediaRecord,
	GFXETERNA55_API_CODE_SetMovieMediaRecord                    = API_CODE_SetMovieMediaRecord,
	GFXETERNA55_API_CODE_GetMovieMediaRecord                    = API_CODE_GetMovieMediaRecord,
	GFXETERNA55_API_CODE_CapMovieMediaRecordProRes              = API_CODE_CapMovieMediaRecordProRes,
	GFXETERNA55_API_CODE_SetMovieMediaRecordProRes              = API_CODE_SetMovieMediaRecordProRes,
	GFXETERNA55_API_CODE_GetMovieMediaRecordProRes              = API_CODE_GetMovieMediaRecordProRes,
	GFXETERNA55_API_CODE_CapMovieHDMIOutputRAW                  = API_CODE_CapMovieHDMIOutputRAW,
	GFXETERNA55_API_CODE_SetMovieHDMIOutputRAW                  = API_CODE_SetMovieHDMIOutputRAW,
	GFXETERNA55_API_CODE_GetMovieHDMIOutputRAW                  = API_CODE_GetMovieHDMIOutputRAW,
	GFXETERNA55_API_CODE_CapMovieHDMIOutputRAWResolution        = API_CODE_CapMovieHDMIOutputRAWResolution,
	GFXETERNA55_API_CODE_SetMovieHDMIOutputRAWResolution        = API_CODE_SetMovieHDMIOutputRAWResolution,
	GFXETERNA55_API_CODE_GetMovieHDMIOutputRAWResolution        = API_CODE_GetMovieHDMIOutputRAWResolution,
	GFXETERNA55_API_CODE_CapMovieHDMIOutputRAWFrameRate         = API_CODE_CapMovieHDMIOutputRAWFrameRate,
	GFXETERNA55_API_CODE_SetMovieHDMIOutputRAWFrameRate         = API_CODE_SetMovieHDMIOutputRAWFrameRate,
	GFXETERNA55_API_CODE_GetMovieHDMIOutputRAWFrameRate         = API_CODE_GetMovieHDMIOutputRAWFrameRate,
	GFXETERNA55_API_CODE_CapFlogRecording                       = API_CODE_CapFlogRecording,
	GFXETERNA55_API_CODE_SetFlogRecording                       = API_CODE_SetFlogRecording,
	GFXETERNA55_API_CODE_GetFlogRecording                       = API_CODE_GetFlogRecording,
	GFXETERNA55_API_CODE_CapMovieCropMagnification              = API_CODE_CapMovieCropMagnification,
	GFXETERNA55_API_CODE_SetMovieCropMagnification              = API_CODE_SetMovieCropMagnification,
	GFXETERNA55_API_CODE_GetMovieCropMagnification              = API_CODE_GetMovieCropMagnification,
	GFXETERNA55_API_CODE_CapMovieHDMIOutputInfoDisplay          = API_CODE_CapMovieHDMIOutputInfoDisplay,
	GFXETERNA55_API_CODE_SetMovieHDMIOutputInfoDisplay          = API_CODE_SetMovieHDMIOutputInfoDisplay,
	GFXETERNA55_API_CODE_GetMovieHDMIOutputInfoDisplay          = API_CODE_GetMovieHDMIOutputInfoDisplay,
	GFXETERNA55_API_CODE_CapMovieHDMIRecControl                 = API_CODE_CapMovieHDMIRecControl,
	GFXETERNA55_API_CODE_SetMovieHDMIRecControl                 = API_CODE_SetMovieHDMIRecControl,
	GFXETERNA55_API_CODE_GetMovieHDMIRecControl                 = API_CODE_GetMovieHDMIRecControl,
	GFXETERNA55_API_CODE_CapMovieIsMode                         = API_CODE_CapMovieIsMode,
	GFXETERNA55_API_CODE_SetMovieIsMode                         = API_CODE_SetMovieIsMode,
	GFXETERNA55_API_CODE_GetMovieIsMode                         = API_CODE_GetMovieIsMode,
	GFXETERNA55_API_CODE_CapMovieIsModeBoost                    = API_CODE_CapMovieIsModeBoost,
	GFXETERNA55_API_CODE_SetMovieIsModeBoost                    = API_CODE_SetMovieIsModeBoost,
	GFXETERNA55_API_CODE_GetMovieIsModeBoost                    = API_CODE_GetMovieIsModeBoost,
	GFXETERNA55_API_CODE_CapMovieZebraSetting                   = API_CODE_CapMovieZebraSetting,
	GFXETERNA55_API_CODE_SetMovieZebraSetting                   = API_CODE_SetMovieZebraSetting,
	GFXETERNA55_API_CODE_GetMovieZebraSetting                   = API_CODE_GetMovieZebraSetting,
	GFXETERNA55_API_CODE_CapMovieZebraLevel                     = API_CODE_CapMovieZebraLevel,
	GFXETERNA55_API_CODE_SetMovieZebraLevel                     = API_CODE_SetMovieZebraLevel,
	GFXETERNA55_API_CODE_GetMovieZebraLevel                     = API_CODE_GetMovieZebraLevel,
	GFXETERNA55_API_CODE_CapMovieOptimizedControl               = API_CODE_CapMovieOptimizedControl,
	GFXETERNA55_API_CODE_SetMovieOptimizedControl               = API_CODE_SetMovieOptimizedControl,
	GFXETERNA55_API_CODE_GetMovieOptimizedControl               = API_CODE_GetMovieOptimizedControl,
	GFXETERNA55_API_CODE_CapMovieTallyLight                     = API_CODE_CapMovieTallyLight,
	GFXETERNA55_API_CODE_SetMovieTallyLight                     = API_CODE_SetMovieTallyLight,
	GFXETERNA55_API_CODE_GetMovieTallyLight                     = API_CODE_GetMovieTallyLight,
	GFXETERNA55_API_CODE_GetMediaEjectWarning                   = API_CODE_GetMediaEjectWarning,
	GFXETERNA55_API_CODE_CapMovieDataLevelSetting               = API_CODE_CapMovieDataLevelSetting,
	GFXETERNA55_API_CODE_SetMovieDataLevelSetting               = API_CODE_SetMovieDataLevelSetting,
	GFXETERNA55_API_CODE_GetMovieDataLevelSetting               = API_CODE_GetMovieDataLevelSetting,
	GFXETERNA55_API_CODE_GetMovieCropMagnificationValue         = API_CODE_GetMovieCropMagnificationValue,
	GFXETERNA55_API_CODE_CapMovieFullTimeManual                 = API_CODE_CapMovieFullTimeManual,
	GFXETERNA55_API_CODE_SetMovieFullTimeManual                 = API_CODE_SetMovieFullTimeManual,
	GFXETERNA55_API_CODE_GetMovieFullTimeManual                 = API_CODE_GetMovieFullTimeManual,
	GFXETERNA55_API_CODE_CapMovieDigitalZoom                    = API_CODE_CapMovieDigitalZoom,
	GFXETERNA55_API_CODE_SetMovieDigitalZoom                    = API_CODE_SetMovieDigitalZoom,
	GFXETERNA55_API_CODE_GetMovieDigitalZoom                    = API_CODE_GetMovieDigitalZoom,
	GFXETERNA55_API_CODE_GetMovieDigitalZoomRange               = API_CODE_GetMovieDigitalZoomRange,
	GFXETERNA55_API_CODE_CapMovieImageFormat                    = API_CODE_CapMovieImageFormat,
	GFXETERNA55_API_CODE_SetMovieImageFormat                    = API_CODE_SetMovieImageFormat,
	GFXETERNA55_API_CODE_GetMovieImageFormat                    = API_CODE_GetMovieImageFormat,
	GFXETERNA55_API_CODE_GetHistogramData                       = API_CODE_GetHistogramData,
	GFXETERNA55_API_CODE_GetFocusMapData                        = API_CODE_GetFocusMapData,
	GFXETERNA55_API_CODE_CapWaveFormVectorScope                 = API_CODE_CapWaveFormVectorScope,
	GFXETERNA55_API_CODE_SetWaveFormVectorScope                 = API_CODE_SetWaveFormVectorScope,
	GFXETERNA55_API_CODE_GetWaveFormVectorScope                 = API_CODE_GetWaveFormVectorScope,
	GFXETERNA55_API_CODE_GetWaveFormData                        = API_CODE_GetWaveFormData,
	GFXETERNA55_API_CODE_GetVectorScopeData                     = API_CODE_GetVectorScopeData,
	GFXETERNA55_API_CODE_GetParadeData                          = API_CODE_GetParadeData,
	GFXETERNA55_API_CODE_CapRecFrameIndicator                   = API_CODE_CapRecFrameIndicator,
	GFXETERNA55_API_CODE_SetRecFrameIndicator                   = API_CODE_SetRecFrameIndicator,
	GFXETERNA55_API_CODE_GetRecFrameIndicator                   = API_CODE_GetRecFrameIndicator,
	GFXETERNA55_API_CODE_CapMovieCaptureDelay                   = API_CODE_CapMovieCaptureDelay,
	GFXETERNA55_API_CODE_SetMovieCaptureDelay                   = API_CODE_SetMovieCaptureDelay,
	GFXETERNA55_API_CODE_GetMovieCaptureDelay                   = API_CODE_GetMovieCaptureDelay,
	GFXETERNA55_API_CODE_CapAnamorphicDesqueezeDisplay          = API_CODE_CapAnamorphicDesqueezeDisplay,
	GFXETERNA55_API_CODE_SetAnamorphicDesqueezeDisplay          = API_CODE_SetAnamorphicDesqueezeDisplay,
	GFXETERNA55_API_CODE_GetAnamorphicDesqueezeDisplay          = API_CODE_GetAnamorphicDesqueezeDisplay,
	GFXETERNA55_API_CODE_CapAnamorphicMagnification             = API_CODE_CapAnamorphicMagnification,
	GFXETERNA55_API_CODE_SetAnamorphicMagnification             = API_CODE_SetAnamorphicMagnification,
	GFXETERNA55_API_CODE_GetAnamorphicMagnification             = API_CODE_GetAnamorphicMagnification,
	GFXETERNA55_API_CODE_CapWaveFormSetting                     = API_CODE_CapWaveFormSetting,
	GFXETERNA55_API_CODE_SetWaveFormSetting                     = API_CODE_SetWaveFormSetting,
	GFXETERNA55_API_CODE_GetWaveFormSetting                     = API_CODE_GetWaveFormSetting,
	GFXETERNA55_API_CODE_CapVectorScopeSetting                  = API_CODE_CapVectorScopeSetting,
	GFXETERNA55_API_CODE_SetVectorScopeSetting                  = API_CODE_SetVectorScopeSetting,
	GFXETERNA55_API_CODE_GetVectorScopeSetting                  = API_CODE_GetVectorScopeSetting,
	GFXETERNA55_API_CODE_CapParadeSettingDisplay                = API_CODE_CapParadeSettingDisplay,
	GFXETERNA55_API_CODE_SetParadeSettingDisplay                = API_CODE_SetParadeSettingDisplay,
	GFXETERNA55_API_CODE_GetParadeSettingDisplay                = API_CODE_GetParadeSettingDisplay,
	GFXETERNA55_API_CODE_CapParadeSettingColor                  = API_CODE_CapParadeSettingColor,
	GFXETERNA55_API_CODE_SetParadeSettingColor                  = API_CODE_SetParadeSettingColor,
	GFXETERNA55_API_CODE_GetParadeSettingColor                  = API_CODE_GetParadeSettingColor,
	GFXETERNA55_API_CODE_CapFlogDRangePriority                  = API_CODE_CapFlogDRangePriority,
	GFXETERNA55_API_CODE_SetFlogDRangePriority                  = API_CODE_SetFlogDRangePriority,
	GFXETERNA55_API_CODE_GetFlogDRangePriority                  = API_CODE_GetFlogDRangePriority,
	GFXETERNA55_API_CODE_CapMovieWhiteBalanceTune               = API_CODE_CapMovieWhiteBalanceTune,
	GFXETERNA55_API_CODE_SetMovieWhiteBalanceTune               = API_CODE_SetMovieWhiteBalanceTune,
	GFXETERNA55_API_CODE_GetMovieWhiteBalanceTune               = API_CODE_GetMovieWhiteBalanceTune,
	GFXETERNA55_API_CODE_CapMovieFilmSimulationMode             = API_CODE_CapMovieFilmSimulationMode,
	GFXETERNA55_API_CODE_SetMovieFilmSimulationMode             = API_CODE_SetMovieFilmSimulationMode,
	GFXETERNA55_API_CODE_GetMovieFilmSimulationMode             = API_CODE_GetMovieFilmSimulationMode,
	GFXETERNA55_API_CODE_CapMovieMonochromaticColor             = API_CODE_CapMovieMonochromaticColor,
	GFXETERNA55_API_CODE_SetMovieMonochromaticColor             = API_CODE_SetMovieMonochromaticColor,
	GFXETERNA55_API_CODE_GetMovieMonochromaticColor             = API_CODE_GetMovieMonochromaticColor,
	GFXETERNA55_API_CODE_CapMovieHighLightTone                  = API_CODE_CapMovieHighLightTone,
	GFXETERNA55_API_CODE_SetMovieHighLightTone                  = API_CODE_SetMovieHighLightTone,
	GFXETERNA55_API_CODE_GetMovieHighLightTone                  = API_CODE_GetMovieHighLightTone,
	GFXETERNA55_API_CODE_CapMovieShadowTone                     = API_CODE_CapMovieShadowTone,
	GFXETERNA55_API_CODE_SetMovieShadowTone                     = API_CODE_SetMovieShadowTone,
	GFXETERNA55_API_CODE_GetMovieShadowTone                     = API_CODE_GetMovieShadowTone,
	GFXETERNA55_API_CODE_CapMovieSharpness                      = API_CODE_CapMovieSharpness,
	GFXETERNA55_API_CODE_SetMovieSharpness                      = API_CODE_SetMovieSharpness,
	GFXETERNA55_API_CODE_GetMovieSharpness                      = API_CODE_GetMovieSharpness,
	GFXETERNA55_API_CODE_CapMovieColorMode                      = API_CODE_CapMovieColorMode,
	GFXETERNA55_API_CODE_SetMovieColorMode                      = API_CODE_SetMovieColorMode,
	GFXETERNA55_API_CODE_GetMovieColorMode                      = API_CODE_GetMovieColorMode,
	GFXETERNA55_API_CODE_CapMovieNoiseReduction                 = API_CODE_CapMovieNoiseReduction,
	GFXETERNA55_API_CODE_SetMovieNoiseReduction                 = API_CODE_SetMovieNoiseReduction,
	GFXETERNA55_API_CODE_GetMovieNoiseReduction                 = API_CODE_GetMovieNoiseReduction,
	GFXETERNA55_API_CODE_CapInterFrameNR                        = API_CODE_CapInterFrameNR,
	GFXETERNA55_API_CODE_SetInterFrameNR                        = API_CODE_SetInterFrameNR,
	GFXETERNA55_API_CODE_GetInterFrameNR                        = API_CODE_GetInterFrameNR,
	GFXETERNA55_API_CODE_CapMoviePeripheralLightCorrection      = API_CODE_CapMoviePeripheralLightCorrection,
	GFXETERNA55_API_CODE_SetMoviePeripheralLightCorrection      = API_CODE_SetMoviePeripheralLightCorrection,
	GFXETERNA55_API_CODE_GetMoviePeripheralLightCorrection      = API_CODE_GetMoviePeripheralLightCorrection,
	GFXETERNA55_API_CODE_CapMovieFaceDetectionMode              = API_CODE_CapMovieFaceDetectionMode,
	GFXETERNA55_API_CODE_SetMovieFaceDetectionMode              = API_CODE_SetMovieFaceDetectionMode,
	GFXETERNA55_API_CODE_GetMovieFaceDetectionMode              = API_CODE_GetMovieFaceDetectionMode,
	GFXETERNA55_API_CODE_CapMovieEyeAFMode                      = API_CODE_CapMovieEyeAFMode,
	GFXETERNA55_API_CODE_SetMovieEyeAFMode                      = API_CODE_SetMovieEyeAFMode,
	GFXETERNA55_API_CODE_GetMovieEyeAFMode                      = API_CODE_GetMovieEyeAFMode,
	GFXETERNA55_API_CODE_CapMovieSubjectDetectionMode           = API_CODE_CapMovieSubjectDetectionMode,
	GFXETERNA55_API_CODE_SetMovieSubjectDetectionMode           = API_CODE_SetMovieSubjectDetectionMode,
	GFXETERNA55_API_CODE_GetMovieSubjectDetectionMode           = API_CODE_GetMovieSubjectDetectionMode,
	GFXETERNA55_API_CODE_CapMovieAFCCustom                      = API_CODE_CapMovieAFCCustom,
	GFXETERNA55_API_CODE_SetMovieAFCCustom                      = API_CODE_SetMovieAFCCustom,
	GFXETERNA55_API_CODE_GetMovieAFCCustom                      = API_CODE_GetMovieAFCCustom,
	GFXETERNA55_API_CODE_CapMovieMFAssistMode                   = API_CODE_CapMovieMFAssistMode,
	GFXETERNA55_API_CODE_SetMovieMFAssistMode                   = API_CODE_SetMovieMFAssistMode,
	GFXETERNA55_API_CODE_GetMovieMFAssistMode                   = API_CODE_GetMovieMFAssistMode,
	GFXETERNA55_API_CODE_GetMovieFocusMeter                     = API_CODE_GetMovieFocusMeter,
	GFXETERNA55_API_CODE_CapMovieFocusCheckMode                 = API_CODE_CapMovieFocusCheckMode,
	GFXETERNA55_API_CODE_SetMovieFocusCheckMode                 = API_CODE_SetMovieFocusCheckMode,
	GFXETERNA55_API_CODE_GetMovieFocusCheckMode                 = API_CODE_GetMovieFocusCheckMode,
	GFXETERNA55_API_CODE_CapMovieFocusCheckLock                 = API_CODE_CapMovieFocusCheckLock,
	GFXETERNA55_API_CODE_SetMovieFocusCheckLock                 = API_CODE_SetMovieFocusCheckLock,
	GFXETERNA55_API_CODE_GetMovieFocusCheckLock                 = API_CODE_GetMovieFocusCheckLock,
	GFXETERNA55_API_CODE_GetMovieRecordingTime                  = API_CODE_GetMovieRecordingTime,
	GFXETERNA55_API_CODE_GetMovieRemainingTime                  = API_CODE_GetMovieRemainingTime,
	GFXETERNA55_API_CODE_GetTimeCode                            = API_CODE_GetTimeCode,
	GFXETERNA55_API_CODE_CapTimeCodeDisplay                     = API_CODE_CapTimeCodeDisplay,
	GFXETERNA55_API_CODE_SetTimeCodeDisplay                     = API_CODE_SetTimeCodeDisplay,
	GFXETERNA55_API_CODE_GetTimeCodeDisplay                     = API_CODE_GetTimeCodeDisplay,
	GFXETERNA55_API_CODE_CapTimeCodeStartSetting                = API_CODE_CapTimeCodeStartSetting,
	GFXETERNA55_API_CODE_SetTimeCodeStartSetting                = API_CODE_SetTimeCodeStartSetting,
	GFXETERNA55_API_CODE_CapTimeCodeCountUp                     = API_CODE_CapTimeCodeCountUp,
	GFXETERNA55_API_CODE_SetTimeCodeCountUp                     = API_CODE_SetTimeCodeCountUp,
	GFXETERNA55_API_CODE_GetTimeCodeCountUp                     = API_CODE_GetTimeCodeCountUp,
	GFXETERNA55_API_CODE_CapTimeCodeDropFrame                   = API_CODE_CapTimeCodeDropFrame,
	GFXETERNA55_API_CODE_SetTimeCodeDropFrame                   = API_CODE_SetTimeCodeDropFrame,
	GFXETERNA55_API_CODE_GetTimeCodeDropFrame                   = API_CODE_GetTimeCodeDropFrame,
	GFXETERNA55_API_CODE_CapTimeCodeHDMIOutput                  = API_CODE_CapTimeCodeHDMIOutput,
	GFXETERNA55_API_CODE_SetTimeCodeHDMIOutput                  = API_CODE_SetTimeCodeHDMIOutput,
	GFXETERNA55_API_CODE_GetTimeCodeHDMIOutput                  = API_CODE_GetTimeCodeHDMIOutput,
	GFXETERNA55_API_CODE_GetTimeCodeCurrentValue                = API_CODE_GetTimeCodeCurrentValue,
	GFXETERNA55_API_CODE_CapATOMOSAirGluConnection              = API_CODE_CapATOMOSAirGluConnection,
	GFXETERNA55_API_CODE_SetATOMOSAirGluConnection              = API_CODE_SetATOMOSAirGluConnection,
	GFXETERNA55_API_CODE_GetATOMOSAirGluConnection              = API_CODE_GetATOMOSAirGluConnection,
	GFXETERNA55_API_CODE_GetTimeCodeStatus                      = API_CODE_GetTimeCodeStatus,
	GFXETERNA55_API_CODE_CapInternalMicLevel                    = API_CODE_CapInternalMicLevel,
	GFXETERNA55_API_CODE_SetInternalMicLevel                    = API_CODE_SetInternalMicLevel,
	GFXETERNA55_API_CODE_GetInternalMicLevel                    = API_CODE_GetInternalMicLevel,
	GFXETERNA55_API_CODE_CapInternalMicLevelManual              = API_CODE_CapInternalMicLevelManual,
	GFXETERNA55_API_CODE_SetInternalMicLevelManual              = API_CODE_SetInternalMicLevelManual,
	GFXETERNA55_API_CODE_GetInternalMicLevelManual              = API_CODE_GetInternalMicLevelManual,
	GFXETERNA55_API_CODE_CapExternalMicLevel                    = API_CODE_CapExternalMicLevel,
	GFXETERNA55_API_CODE_SetExternalMicLevel                    = API_CODE_SetExternalMicLevel,
	GFXETERNA55_API_CODE_GetExternalMicLevel                    = API_CODE_GetExternalMicLevel,
	GFXETERNA55_API_CODE_CapExternalMicLevelManual              = API_CODE_CapExternalMicLevelManual,
	GFXETERNA55_API_CODE_SetExternalMicLevelManual              = API_CODE_SetExternalMicLevelManual,
	GFXETERNA55_API_CODE_GetExternalMicLevelManual              = API_CODE_GetExternalMicLevelManual,
	GFXETERNA55_API_CODE_CapMicLevelLimiter                     = API_CODE_CapMicLevelLimiter,
	GFXETERNA55_API_CODE_SetMicLevelLimiter                     = API_CODE_SetMicLevelLimiter,
	GFXETERNA55_API_CODE_GetMicLevelLimiter                     = API_CODE_GetMicLevelLimiter,
	GFXETERNA55_API_CODE_CapWindFilter                          = API_CODE_CapWindFilter,
	GFXETERNA55_API_CODE_SetWindFilter                          = API_CODE_SetWindFilter,
	GFXETERNA55_API_CODE_GetWindFilter                          = API_CODE_GetWindFilter,
	GFXETERNA55_API_CODE_CapLowCutFilter                        = API_CODE_CapLowCutFilter,
	GFXETERNA55_API_CODE_SetLowCutFilter                        = API_CODE_SetLowCutFilter,
	GFXETERNA55_API_CODE_GetLowCutFilter                        = API_CODE_GetLowCutFilter,
	GFXETERNA55_API_CODE_CapHeadPhonesVolume                    = API_CODE_CapHeadPhonesVolume,
	GFXETERNA55_API_CODE_SetHeadPhonesVolume                    = API_CODE_SetHeadPhonesVolume,
	GFXETERNA55_API_CODE_GetHeadPhonesVolume                    = API_CODE_GetHeadPhonesVolume,
	GFXETERNA55_API_CODE_CapXLRAdapterMicSource                 = API_CODE_CapXLRAdapterMicSource,
	GFXETERNA55_API_CODE_SetXLRAdapterMicSource                 = API_CODE_SetXLRAdapterMicSource,
	GFXETERNA55_API_CODE_GetXLRAdapterMicSource                 = API_CODE_GetXLRAdapterMicSource,
	GFXETERNA55_API_CODE_CapXLRAdapterMoniteringSource          = API_CODE_CapXLRAdapterMoniteringSource,
	GFXETERNA55_API_CODE_SetXLRAdapterMoniteringSource          = API_CODE_SetXLRAdapterMoniteringSource,
	GFXETERNA55_API_CODE_GetXLRAdapterMoniteringSource          = API_CODE_GetXLRAdapterMoniteringSource,
	GFXETERNA55_API_CODE_CapXLRAdapterHDMIOutputSource          = API_CODE_CapXLRAdapterHDMIOutputSource,
	GFXETERNA55_API_CODE_SetXLRAdapterHDMIOutputSource          = API_CODE_SetXLRAdapterHDMIOutputSource,
	GFXETERNA55_API_CODE_GetXLRAdapterHDMIOutputSource          = API_CODE_GetXLRAdapterHDMIOutputSource,
	GFXETERNA55_API_CODE_GetMicLevelIndicator                   = API_CODE_GetMicLevelIndicator,
	GFXETERNA55_API_CODE_GetMovieTransparentFrameInfo           = API_CODE_GetMovieTransparentFrameInfo,
	GFXETERNA55_API_CODE_CapShortMovieSecond                    = API_CODE_CapShortMovieSecond,
	GFXETERNA55_API_CODE_SetShortMovieSecond                    = API_CODE_SetShortMovieSecond,
	GFXETERNA55_API_CODE_GetShortMovieSecond                    = API_CODE_GetShortMovieSecond,
	GFXETERNA55_API_CODE_CapMoviePortraitEnhancer               = API_CODE_CapMoviePortraitEnhancer,
	GFXETERNA55_API_CODE_SetMoviePortraitEnhancer               = API_CODE_SetMoviePortraitEnhancer,
	GFXETERNA55_API_CODE_GetMoviePortraitEnhancer               = API_CODE_GetMoviePortraitEnhancer,
	GFXETERNA55_API_CODE_CapDirectionalMic                      = API_CODE_CapDirectionalMic,
	GFXETERNA55_API_CODE_SetDirectionalMic                      = API_CODE_SetDirectionalMic,
	GFXETERNA55_API_CODE_GetDirectionalMic                      = API_CODE_GetDirectionalMic,
	GFXETERNA55_API_CODE_CapEnvSoundsNR                         = API_CODE_CapEnvSoundsNR,
	GFXETERNA55_API_CODE_SetEnvSoundsNR                         = API_CODE_SetEnvSoundsNR,
	GFXETERNA55_API_CODE_GetEnvSoundsNR                         = API_CODE_GetEnvSoundsNR,
	GFXETERNA55_API_CODE_GetBodyTemperatureWarning              = API_CODE_GetBodyTemperatureWarning,
	GFXETERNA55_API_CODE_GetPlayBackMediaInfo                   = API_CODE_GetPlayBackMediaInfo,
	GFXETERNA55_API_CODE_GetPlayBackObjectInfo                  = API_CODE_GetPlayBackObjectInfo,
	GFXETERNA55_API_CODE_GetPlayBackThumb                       = API_CODE_GetPlayBackThumb,
	GFXETERNA55_API_CODE_GetPlayBackPartialObject               = API_CODE_GetPlayBackPartialObject,
	GFXETERNA55_API_CODE_CapMovieRecVolume                      = API_CODE_CapMovieRecVolume,
	GFXETERNA55_API_CODE_SetMovieRecVolume                      = API_CODE_SetMovieRecVolume,
	GFXETERNA55_API_CODE_GetMovieRecVolume                      = API_CODE_GetMovieRecVolume,
	GFXETERNA55_API_CODE_GetMovieExposureIndexCurrentValue      = API_CODE_GetMovieExposureIndexCurrentValue,
	GFXETERNA55_API_CODE_CapMovieProjectFrameRate               = API_CODE_CapMovieProjectFrameRate,
	GFXETERNA55_API_CODE_SetMovieProjectFrameRate               = API_CODE_SetMovieProjectFrameRate,
	GFXETERNA55_API_CODE_GetMovieProjectFrameRate               = API_CODE_GetMovieProjectFrameRate,
	GFXETERNA55_API_CODE_CapMovieHDMIOutput                     = API_CODE_CapMovieHDMIOutput,
	GFXETERNA55_API_CODE_SetMovieHDMIOutput                     = API_CODE_SetMovieHDMIOutput,
	GFXETERNA55_API_CODE_GetMovieHDMIOutput                     = API_CODE_GetMovieHDMIOutput,
	GFXETERNA55_API_CODE_CapMovieFrameGuideCenterMarkerColor    = API_CODE_CapMovieFrameGuideCenterMarkerColor,
	GFXETERNA55_API_CODE_SetMovieFrameGuideCenterMarkerColor    = API_CODE_SetMovieFrameGuideCenterMarkerColor,
	GFXETERNA55_API_CODE_GetMovieFrameGuideCenterMarkerColor    = API_CODE_GetMovieFrameGuideCenterMarkerColor,
	GFXETERNA55_API_CODE_CapMovieFrameGuideCenterMarkerThickness = API_CODE_CapMovieFrameGuideCenterMarkerThickness,
	GFXETERNA55_API_CODE_SetMovieFrameGuideCenterMarkerThickness = API_CODE_SetMovieFrameGuideCenterMarkerThickness,
	GFXETERNA55_API_CODE_GetMovieFrameGuideCenterMarkerThickness = API_CODE_GetMovieFrameGuideCenterMarkerThickness,
	GFXETERNA55_API_CODE_CapLUTSettings                         = API_CODE_CapLUTSettings,
	GFXETERNA55_API_CODE_SetLUTSettings                         = API_CODE_SetLUTSettings,
	GFXETERNA55_API_CODE_GetLUTSettings                         = API_CODE_GetLUTSettings,
	GFXETERNA55_API_CODE_CapMovieMediaRecordContainer           = API_CODE_CapMovieMediaRecordContainer,
	GFXETERNA55_API_CODE_SetMovieMediaRecordContainer           = API_CODE_SetMovieMediaRecordContainer,
	GFXETERNA55_API_CODE_GetMovieMediaRecordContainer           = API_CODE_GetMovieMediaRecordContainer,
	GFXETERNA55_API_CODE_SetClipSetting                         = API_CODE_SetClipSetting,
	GFXETERNA55_API_CODE_GetClipSetting                         = API_CODE_GetClipSetting,
	GFXETERNA55_API_CODE_CapGenlockSetting                      = API_CODE_CapGenlockSetting,
	GFXETERNA55_API_CODE_SetGenlockSetting                      = API_CODE_SetGenlockSetting,
	GFXETERNA55_API_CODE_GetGenlockSetting                      = API_CODE_GetGenlockSetting,
	GFXETERNA55_API_CODE_CapTimeCodeSyncSetting                 = API_CODE_CapTimeCodeSyncSetting,
	GFXETERNA55_API_CODE_SetTimeCodeSyncSetting                 = API_CODE_SetTimeCodeSyncSetting,
	GFXETERNA55_API_CODE_GetTimeCodeSyncSetting                 = API_CODE_GetTimeCodeSyncSetting,
	GFXETERNA55_API_CODE_CapMovieFrameGuideDisplay              = API_CODE_CapMovieFrameGuideDisplay,
	GFXETERNA55_API_CODE_SetMovieFrameGuideDisplay              = API_CODE_SetMovieFrameGuideDisplay,
	GFXETERNA55_API_CODE_GetMovieFrameGuideDisplay              = API_CODE_GetMovieFrameGuideDisplay,
	GFXETERNA55_API_CODE_CapMovieFrameGuideAspect               = API_CODE_CapMovieFrameGuideAspect,
	GFXETERNA55_API_CODE_SetMovieFrameGuideAspect               = API_CODE_SetMovieFrameGuideAspect,
	GFXETERNA55_API_CODE_GetMovieFrameGuideAspect               = API_CODE_GetMovieFrameGuideAspect,
	GFXETERNA55_API_CODE_CapMovieFrameGuideColor                = API_CODE_CapMovieFrameGuideColor,
	GFXETERNA55_API_CODE_SetMovieFrameGuideColor                = API_CODE_SetMovieFrameGuideColor,
	GFXETERNA55_API_CODE_GetMovieFrameGuideColor                = API_CODE_GetMovieFrameGuideColor,
	GFXETERNA55_API_CODE_CapMovieFrameGuideLineThickness        = API_CODE_CapMovieFrameGuideLineThickness,
	GFXETERNA55_API_CODE_SetMovieFrameGuideLineThickness        = API_CODE_SetMovieFrameGuideLineThickness,
	GFXETERNA55_API_CODE_GetMovieFrameGuideLineThickness        = API_CODE_GetMovieFrameGuideLineThickness,
	GFXETERNA55_API_CODE_CapMovieFrameGuideMask                 = API_CODE_CapMovieFrameGuideMask,
	GFXETERNA55_API_CODE_SetMovieFrameGuideMask                 = API_CODE_SetMovieFrameGuideMask,
	GFXETERNA55_API_CODE_GetMovieFrameGuideMask                 = API_CODE_GetMovieFrameGuideMask,
	GFXETERNA55_API_CODE_CapMovieFrameGuideTransparency         = API_CODE_CapMovieFrameGuideTransparency,
	GFXETERNA55_API_CODE_SetMovieFrameGuideTransparency         = API_CODE_SetMovieFrameGuideTransparency,
	GFXETERNA55_API_CODE_GetMovieFrameGuideTransparency         = API_CODE_GetMovieFrameGuideTransparency,
	GFXETERNA55_API_CODE_CapMovieFrameGuideCenterMarker         = API_CODE_CapMovieFrameGuideCenterMarker,
	GFXETERNA55_API_CODE_SetMovieFrameGuideCenterMarker         = API_CODE_SetMovieFrameGuideCenterMarker,
	GFXETERNA55_API_CODE_GetMovieFrameGuideCenterMarker         = API_CODE_GetMovieFrameGuideCenterMarker,
	GFXETERNA55_API_CODE_SetMovieFrameGuideCustom               = API_CODE_SetMovieFrameGuideCustom,
	GFXETERNA55_API_CODE_GetMovieFrameGuideCustom               = API_CODE_GetMovieFrameGuideCustom,
	GFXETERNA55_API_CODE_GetMovieFrameGuideInfo                 = API_CODE_GetMovieFrameGuideInfo,
	GFXETERNA55_API_CODE_CapBatteryWarningPercent               = API_CODE_CapBatteryWarningPercent,
	GFXETERNA55_API_CODE_SetBatteryWarningPercent               = API_CODE_SetBatteryWarningPercent,
	GFXETERNA55_API_CODE_GetBatteryWarningPercent               = API_CODE_GetBatteryWarningPercent,
	GFXETERNA55_API_CODE_CapBatteryWarningVoltage               = API_CODE_CapBatteryWarningVoltage,
	GFXETERNA55_API_CODE_SetBatteryWarningVoltage               = API_CODE_SetBatteryWarningVoltage,
	GFXETERNA55_API_CODE_GetBatteryWarningVoltage               = API_CODE_GetBatteryWarningVoltage,
	GFXETERNA55_API_CODE_GetBatteryVoltageInfo                  = API_CODE_GetBatteryVoltageInfo,
	GFXETERNA55_API_CODE_SetMovieWhiteBalancePreset             = API_CODE_SetMovieWhiteBalancePreset,
	GFXETERNA55_API_CODE_CapMovieShutterDisplay                 = API_CODE_CapMovieShutterDisplay,
	GFXETERNA55_API_CODE_SetMovieShutterDisplay                 = API_CODE_SetMovieShutterDisplay,
	GFXETERNA55_API_CODE_GetMovieShutterDisplay                 = API_CODE_GetMovieShutterDisplay,
	GFXETERNA55_API_CODE_CapMovieShutterAngle                   = API_CODE_CapMovieShutterAngle,
	GFXETERNA55_API_CODE_SetMovieShutterAngle                   = API_CODE_SetMovieShutterAngle,
	GFXETERNA55_API_CODE_GetMovieShutterAngle                   = API_CODE_GetMovieShutterAngle,
	GFXETERNA55_API_CODE_CapFanStopDuringRec                    = API_CODE_CapFanStopDuringRec,
	GFXETERNA55_API_CODE_SetFanStopDuringRec                    = API_CODE_SetFanStopDuringRec,
	GFXETERNA55_API_CODE_GetFanStopDuringRec                    = API_CODE_GetFanStopDuringRec,
	GFXETERNA55_API_CODE_GetClipDisplay                         = API_CODE_GetClipDisplay,
	GFXETERNA55_API_CODE_CapMovieNDMode                         = API_CODE_CapMovieNDMode,
	GFXETERNA55_API_CODE_SetMovieNDMode                         = API_CODE_SetMovieNDMode,
	GFXETERNA55_API_CODE_GetMovieNDMode                         = API_CODE_GetMovieNDMode,
	GFXETERNA55_API_CODE_CapMovieNDDisplay                      = API_CODE_CapMovieNDDisplay,
	GFXETERNA55_API_CODE_SetMovieNDDisplay                      = API_CODE_SetMovieNDDisplay,
	GFXETERNA55_API_CODE_GetMovieNDDisplay                      = API_CODE_GetMovieNDDisplay,
	GFXETERNA55_API_CODE_CapMovieNDDensity                      = API_CODE_CapMovieNDDensity,
	GFXETERNA55_API_CODE_SetMovieNDDensity                      = API_CODE_SetMovieNDDensity,
	GFXETERNA55_API_CODE_GetMovieNDDensity                      = API_CODE_GetMovieNDDensity,
	GFXETERNA55_API_CODE_CapMovieNDFactor                       = API_CODE_CapMovieNDFactor,
	GFXETERNA55_API_CODE_SetMovieNDFactor                       = API_CODE_SetMovieNDFactor,
	GFXETERNA55_API_CODE_GetMovieNDFactor                       = API_CODE_GetMovieNDFactor,
	GFXETERNA55_API_CODE_GetLUTList                             = API_CODE_GetLUTList,
	GFXETERNA55_API_CODE_GetMovieWhiteBalancePresetList         = API_CODE_GetMovieWhiteBalancePresetList,
	GFXETERNA55_API_CODE_CapSDIOutput                           = API_CODE_CapSDIOutput,
	GFXETERNA55_API_CODE_SetSDIOutput                           = API_CODE_SetSDIOutput,
	GFXETERNA55_API_CODE_GetSDIOutput                           = API_CODE_GetSDIOutput,
	GFXETERNA55_API_CODE_CapSDIRecControl                       = API_CODE_CapSDIRecControl,
	GFXETERNA55_API_CODE_SetSDIRecControl                       = API_CODE_SetSDIRecControl,
	GFXETERNA55_API_CODE_GetSDIRecControl                       = API_CODE_GetSDIRecControl,
	GFXETERNA55_API_CODE_CapMovieTNumber                        = API_CODE_CapMovieTNumber,
	GFXETERNA55_API_CODE_SetMovieTNumber                        = API_CODE_SetMovieTNumber,
	GFXETERNA55_API_CODE_GetMovieTNumber                        = API_CODE_GetMovieTNumber,
	GFXETERNA55_API_CODE_CapRGBHistogramDisplay                 = API_CODE_CapRGBHistogramDisplay,
	GFXETERNA55_API_CODE_SetRGBHistogramDisplay                 = API_CODE_SetRGBHistogramDisplay,
	GFXETERNA55_API_CODE_GetRGBHistogramDisplay                 = API_CODE_GetRGBHistogramDisplay,
	GFXETERNA55_API_CODE_CapHistogramDisplay                    = API_CODE_CapHistogramDisplay,
	GFXETERNA55_API_CODE_SetHistogramDisplay                    = API_CODE_SetHistogramDisplay,
	GFXETERNA55_API_CODE_GetHistogramDisplay                    = API_CODE_GetHistogramDisplay,
	GFXETERNA55_API_CODE_CapSDIHDMIOutputFps                    = API_CODE_CapSDIHDMIOutputFps,
	GFXETERNA55_API_CODE_SetSDIHDMIOutputFps                    = API_CODE_SetSDIHDMIOutputFps,
	GFXETERNA55_API_CODE_GetSDIHDMIOutputFps                    = API_CODE_GetSDIHDMIOutputFps,
	GFXETERNA55_API_CODE_CapFanHighSpeedOutput                  = API_CODE_CapFanHighSpeedOutput,
	GFXETERNA55_API_CODE_SetFanHighSpeedOutput                  = API_CODE_SetFanHighSpeedOutput,
	GFXETERNA55_API_CODE_GetFanHighSpeedOutput                  = API_CODE_GetFanHighSpeedOutput,
	GFXETERNA55_API_CODE_CapFanLowSpeedOutput                   = API_CODE_CapFanLowSpeedOutput,
	GFXETERNA55_API_CODE_SetFanLowSpeedOutput                   = API_CODE_SetFanLowSpeedOutput,
	GFXETERNA55_API_CODE_GetFanLowSpeedOutput                   = API_CODE_GetFanLowSpeedOutput,
	GFXETERNA55_API_CODE_CapLookMode                            = API_CODE_CapLookMode,
	GFXETERNA55_API_CODE_SetLookMode                            = API_CODE_SetLookMode,
	GFXETERNA55_API_CODE_GetLookMode                            = API_CODE_GetLookMode,
	GFXETERNA55_API_CODE_GetGenlockStatus                       = API_CODE_GetGenlockStatus,
	GFXETERNA55_API_CODE_GetMovieFNumberCurrentValue            = API_CODE_GetMovieFNumberCurrentValue,
	GFXETERNA55_API_CODE_GetMovieTNumberCurrentValue            = API_CODE_GetMovieTNumberCurrentValue,
	GFXETERNA55_API_CODE_CapTimeCodeConnector                   = API_CODE_CapTimeCodeConnector,
	GFXETERNA55_API_CODE_SetTimeCodeConnector                   = API_CODE_SetTimeCodeConnector,
	GFXETERNA55_API_CODE_GetTimeCodeConnector                   = API_CODE_GetTimeCodeConnector,
	GFXETERNA55_API_CODE_GetMovieSensitivityFDGain              = API_CODE_GetMovieSensitivityFDGain,
	GFXETERNA55_API_CODE_CapMovieFrameGuideMode                 = API_CODE_CapMovieFrameGuideMode,
	GFXETERNA55_API_CODE_SetMovieFrameGuideMode                 = API_CODE_SetMovieFrameGuideMode,
	GFXETERNA55_API_CODE_GetMovieFrameGuideMode                 = API_CODE_GetMovieFrameGuideMode,
	GFXETERNA55_API_CODE_CapMovieFrameGuideScale                = API_CODE_CapMovieFrameGuideScale,
	GFXETERNA55_API_CODE_SetMovieFrameGuideScale                = API_CODE_SetMovieFrameGuideScale,
	GFXETERNA55_API_CODE_GetMovieFrameGuideScale                = API_CODE_GetMovieFrameGuideScale,
	GFXETERNA55_API_CODE_GetLUTSettingsUserFileList             = API_CODE_GetLUTSettingsUserFileList,
	GFXETERNA55_API_CODE_CapFrameGuideDisplayAll                = API_CODE_CapFrameGuideDisplayAll,
	GFXETERNA55_API_CODE_SetFrameGuideDisplayAll                = API_CODE_SetFrameGuideDisplayAll,
	GFXETERNA55_API_CODE_GetFrameGuideDisplayAll                = API_CODE_GetFrameGuideDisplayAll,
	GFXETERNA55_API_CODE_CapFrameGuideMaskFrame                 = API_CODE_CapFrameGuideMaskFrame,
	GFXETERNA55_API_CODE_SetFrameGuideMaskFrame                 = API_CODE_SetFrameGuideMaskFrame,
	GFXETERNA55_API_CODE_GetFrameGuideMaskFrame                 = API_CODE_GetFrameGuideMaskFrame,
	GFXETERNA55_API_CODE_CapFrameGuideCenterMarkerPattern       = API_CODE_CapFrameGuideCenterMarkerPattern,
	GFXETERNA55_API_CODE_SetFrameGuideCenterMarkerPattern       = API_CODE_SetFrameGuideCenterMarkerPattern,
	GFXETERNA55_API_CODE_GetFrameGuideCenterMarkerPattern       = API_CODE_GetFrameGuideCenterMarkerPattern,
	GFXETERNA55_API_CODE_CapFrameioFunction                     = API_CODE_CapFrameioFunction,
	GFXETERNA55_API_CODE_SetFrameioFunction                     = API_CODE_SetFrameioFunction,
	GFXETERNA55_API_CODE_GetFrameioFunction                     = API_CODE_GetFrameioFunction,
	GFXETERNA55_API_CODE_GetFrameioPairingCode                  = API_CODE_GetFrameioPairingCode,
	GFXETERNA55_API_CODE_CapFrameioFileType                     = API_CODE_CapFrameioFileType,
	GFXETERNA55_API_CODE_SetFrameioFileType                     = API_CODE_SetFrameioFileType,
	GFXETERNA55_API_CODE_GetFrameioFileType                     = API_CODE_GetFrameioFileType,
	GFXETERNA55_API_CODE_CapFrameioAutoImageTransfer            = API_CODE_CapFrameioAutoImageTransfer,
	GFXETERNA55_API_CODE_SetFrameioAutoImageTransfer            = API_CODE_SetFrameioAutoImageTransfer,
	GFXETERNA55_API_CODE_GetFrameioAutoImageTransfer            = API_CODE_GetFrameioAutoImageTransfer,
	GFXETERNA55_API_CODE_CapFrameioTransferSuspend              = API_CODE_CapFrameioTransferSuspend,
	GFXETERNA55_API_CODE_SetFrameioTransferSuspend              = API_CODE_SetFrameioTransferSuspend,
	GFXETERNA55_API_CODE_GetFrameioTransferSuspend              = API_CODE_GetFrameioTransferSuspend,
	GFXETERNA55_API_CODE_CapFrameioImageTransferWhilePowerOff   = API_CODE_CapFrameioImageTransferWhilePowerOff,
	GFXETERNA55_API_CODE_SetFrameioImageTransferWhilePowerOff   = API_CODE_SetFrameioImageTransferWhilePowerOff,
	GFXETERNA55_API_CODE_GetFrameioImageTransferWhilePowerOff   = API_CODE_GetFrameioImageTransferWhilePowerOff,
	GFXETERNA55_API_CODE_GetFrameioUploadStatus                 = API_CODE_GetFrameioUploadStatus,
	GFXETERNA55_API_CODE_GetFrameioTransferQueue                = API_CODE_GetFrameioTransferQueue,
	GFXETERNA55_API_CODE_CapFrameioResetTransferOrder           = API_CODE_CapFrameioResetTransferOrder,
	GFXETERNA55_API_CODE_SetFrameioResetTransferOrder           = API_CODE_SetFrameioResetTransferOrder,
	GFXETERNA55_API_CODE_GetFrameioConnectionStatus             = API_CODE_GetFrameioConnectionStatus,
	GFXETERNA55_API_CODE_CapPlayBackFileFormat                  = API_CODE_CapPlayBackFileFormat,
	GFXETERNA55_API_CODE_SetPlayBackFileFormat                  = API_CODE_SetPlayBackFileFormat,
	GFXETERNA55_API_CODE_GetPlayBackFileFormat                  = API_CODE_GetPlayBackFileFormat,
};

// Movie Af Mode
enum{
	GFXETERNA55_MOVIE_AF_MULTI                     = SDK_MOVIE_AF_MULTI,
	GFXETERNA55_MOVIE_AF_AREA                      = SDK_MOVIE_AF_AREA,
	GFXETERNA55_MOVIE_AF_WIDETRACKING              = SDK_MOVIE_AF_WIDETRACKING,
};

// Short Movie Second
enum{
	GFXETERNA55_SHORT_MOVIE_SECOND_OFF             = SDK_SHORT_MOVIE_SECOND_OFF,
	GFXETERNA55_SHORT_MOVIE_SECOND_15S             = SDK_SHORT_MOVIE_SECOND_15S,
	GFXETERNA55_SHORT_MOVIE_SECOND_30S             = SDK_SHORT_MOVIE_SECOND_30S,
	GFXETERNA55_SHORT_MOVIE_SECOND_60S             = SDK_SHORT_MOVIE_SECOND_60S,
};

// Movie Resolution
// High Speed Rec Resolution
enum{
	GFXETERNA55_MOVIE_RESOLUTION_6P2K_3_2          = SDK_MOVIE_RESOLUTION_6P2K_3_2,
	GFXETERNA55_MOVIE_RESOLUTION_8K_16_9           = SDK_MOVIE_RESOLUTION_8K_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_6K_16_9           = SDK_MOVIE_RESOLUTION_6K_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_4KHQ_16_9         = SDK_MOVIE_RESOLUTION_4KHQ_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_4K_16_9           = SDK_MOVIE_RESOLUTION_4K_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_DCIHQ_17_9        = SDK_MOVIE_RESOLUTION_DCIHQ_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_DCI_17_9          = SDK_MOVIE_RESOLUTION_DCI_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_FULLHD_16_9       = SDK_MOVIE_RESOLUTION_FULLHD_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_FULLHD_17_9       = SDK_MOVIE_RESOLUTION_FULLHD_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_5K_17_9           = SDK_MOVIE_RESOLUTION_5K_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_DCI_8K_17_9       = SDK_MOVIE_RESOLUTION_DCI_8K_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_CINESCO_2P35_1    = SDK_MOVIE_RESOLUTION_CINESCO_2P35_1,
	GFXETERNA55_MOVIE_RESOLUTION_OPENGATE_3_2      = SDK_MOVIE_RESOLUTION_OPENGATE_3_2,
	GFXETERNA55_MOVIE_RESOLUTION_35MM_16_9         = SDK_MOVIE_RESOLUTION_35MM_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_ANAMORPHIC_2P76_1 = SDK_MOVIE_RESOLUTION_ANAMORPHIC_2P76_1,
	GFXETERNA55_MOVIE_RESOLUTION_ANAMORPHIC_1P38_1 = SDK_MOVIE_RESOLUTION_ANAMORPHIC_1P38_1,
	GFXETERNA55_MOVIE_RESOLUTION_FULLFRAME_3_2     = SDK_MOVIE_RESOLUTION_FULLFRAME_3_2,
	GFXETERNA55_MOVIE_RESOLUTION_FULLHD_LP_16_9    = SDK_MOVIE_RESOLUTION_FULLHD_LP_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_FULLHD_LP_17_9    = SDK_MOVIE_RESOLUTION_FULLHD_LP_17_9,
	GFXETERNA55_MOVIE_RESOLUTION_4K_LP_16_9        = SDK_MOVIE_RESOLUTION_4K_LP_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_FULLHD_9_16       = SDK_MOVIE_RESOLUTION_FULLHD_9_16,
	GFXETERNA55_MOVIE_RESOLUTION_6P2K_16_9         = SDK_MOVIE_RESOLUTION_6P2K_16_9,
	GFXETERNA55_MOVIE_RESOLUTION_4K_4_3            = SDK_MOVIE_RESOLUTION_4K_4_3,
	GFXETERNA55_MOVIE_RESOLUTION_ANAMORPHIC_2P39_1 = SDK_MOVIE_RESOLUTION_ANAMORPHIC_2P39_1,
	GFXETERNA55_MOVIE_RESOLUTION_ANAMORPHIC_1P195_1= SDK_MOVIE_RESOLUTION_ANAMORPHIC_1P195_1,
	GFXETERNA55_MOVIE_RESOLUTION_5P8K_2P39_1       = SDK_MOVIE_RESOLUTION_5P8K_2P39_1,
};

// Movie FrameRate
// High Speed Rec PlayBack FrameRate
enum{
	GFXETERNA55_MOVIE_FRAMERATE_59_94P             = SDK_MOVIE_FRAMERATE_59_94P,
	GFXETERNA55_MOVIE_FRAMERATE_50P                = SDK_MOVIE_FRAMERATE_50P,
	GFXETERNA55_MOVIE_FRAMERATE_29_97P             = SDK_MOVIE_FRAMERATE_29_97P,
	GFXETERNA55_MOVIE_FRAMERATE_25P                = SDK_MOVIE_FRAMERATE_25P,
	GFXETERNA55_MOVIE_FRAMERATE_24P                = SDK_MOVIE_FRAMERATE_24P,
	GFXETERNA55_MOVIE_FRAMERATE_23_98P             = SDK_MOVIE_FRAMERATE_23_98P,
	GFXETERNA55_MOVIE_FRAMERATE_48P                = SDK_MOVIE_FRAMERATE_48P,
	GFXETERNA55_MOVIE_FRAMERATE_47_95P             = SDK_MOVIE_FRAMERATE_47_95P,
	GFXETERNA55_MOVIE_FRAMERATE_119_88P            = SDK_MOVIE_FRAMERATE_119_88P,
	GFXETERNA55_MOVIE_FRAMERATE_100P               = SDK_MOVIE_FRAMERATE_100P,
	GFXETERNA55_MOVIE_FRAMERATE_22P                = SDK_MOVIE_FRAMERATE_22P,
};

// Movie BitRate
enum{
	GFXETERNA55_MOVIE_BITRATE_720MBPS              = SDK_MOVIE_BITRATE_720MBPS,
	GFXETERNA55_MOVIE_BITRATE_400MBPS              = SDK_MOVIE_BITRATE_400MBPS,
	GFXETERNA55_MOVIE_BITRATE_360MBPS              = SDK_MOVIE_BITRATE_360MBPS,
	GFXETERNA55_MOVIE_BITRATE_200MBPS              = SDK_MOVIE_BITRATE_200MBPS,
	GFXETERNA55_MOVIE_BITRATE_100MBPS              = SDK_MOVIE_BITRATE_100MBPS,
	GFXETERNA55_MOVIE_BITRATE_50MBPS               = SDK_MOVIE_BITRATE_50MBPS,
	GFXETERNA55_MOVIE_BITRATE_25MBPS               = SDK_MOVIE_BITRATE_25MBPS,
	GFXETERNA55_MOVIE_BITRATE_8MBPS                = SDK_MOVIE_BITRATE_8MBPS,
};

// Movie FileFormat
enum{
	GFXETERNA55_MOVIE_FORMAT_H264_ALL_I_MOV        = SDK_MOVIE_FORMAT_H264_ALL_I_MOV,
	GFXETERNA55_MOVIE_FORMAT_H264_LONGGOP_I_MOV    = SDK_MOVIE_FORMAT_H264_LONGGOP_I_MOV,
	GFXETERNA55_MOVIE_FORMAT_H264_LONGGOP_MP4      = SDK_MOVIE_FORMAT_H264_LONGGOP_MP4,
	GFXETERNA55_MOVIE_FORMAT_H265_4_2_0_ALL_I      = SDK_MOVIE_FORMAT_H265_4_2_0_ALL_I,
	GFXETERNA55_MOVIE_FORMAT_H265_4_2_0_LONGGOP    = SDK_MOVIE_FORMAT_H265_4_2_0_LONGGOP,
	GFXETERNA55_MOVIE_FORMAT_H265_4_2_2_ALL_I      = SDK_MOVIE_FORMAT_H265_4_2_2_ALL_I,
	GFXETERNA55_MOVIE_FORMAT_H265_4_2_2_LONGGOP    = SDK_MOVIE_FORMAT_H265_4_2_2_LONGGOP,
	GFXETERNA55_MOVIE_FORMAT_PRORESHQ              = SDK_MOVIE_FORMAT_PRORESHQ,
	GFXETERNA55_MOVIE_FORMAT_PRORES                = SDK_MOVIE_FORMAT_PRORES,
	GFXETERNA55_MOVIE_FORMAT_PRORESLT              = SDK_MOVIE_FORMAT_PRORESLT,
};

// High Speed RecMode
enum{
	GFXETERNA55_HIGHSPEEDREC_OFF                   = SDK_HIGHSPEEDREC_OFF,
	GFXETERNA55_HIGHSPEEDREC_ON                    = SDK_HIGHSPEEDREC_ON,
	GFXETERNA55_HIGHSPEEDREC_ON_HDMI_ONLY          = SDK_HIGHSPEEDREC_ON_HDMI_ONLY,
};

// High Speed Rec FrameRate
enum{
	GFXETERNA55_HIGHSPEEDREC_FRAMERATE_240P        = SDK_HIGHSPEEDREC_FRAMERATE_240P,
	GFXETERNA55_HIGHSPEEDREC_FRAMERATE_200P        = SDK_HIGHSPEEDREC_FRAMERATE_200P,
	GFXETERNA55_HIGHSPEEDREC_FRAMERATE_120P        = SDK_HIGHSPEEDREC_FRAMERATE_120P,
	GFXETERNA55_HIGHSPEEDREC_FRAMERATE_100P        = SDK_HIGHSPEEDREC_FRAMERATE_100P,
};

// Movie Media Record
enum{
	GFXETERNA55_MOVIE_MEDIARECORD_SEQUENTIAL_SLOT1_SLOT2 = SDK_MOVIE_MEDIARECORD_SEQUENTIAL_SLOT1_SLOT2,
	GFXETERNA55_MOVIE_MEDIARECORD_SLOT2                  = SDK_MOVIE_MEDIARECORD_SLOT2,
	GFXETERNA55_MOVIE_MEDIARECORD_SLOT1                  = SDK_MOVIE_MEDIARECORD_SLOT1,
	GFXETERNA55_MOVIE_MEDIARECORD_BACKUP                 = SDK_MOVIE_MEDIARECORD_BACKUP,
	GFXETERNA55_MOVIE_MEDIARECORD_SSD                    = SDK_MOVIE_MEDIARECORD_SSD,
	GFXETERNA55_MOVIE_MEDIARECORD_SSD_CF                 = SDK_MOVIE_MEDIARECORD_SSD_CF,
	GFXETERNA55_MOVIE_MEDIARECORD_OFF                    = SDK_MOVIE_MEDIARECORD_OFF,
	GFXETERNA55_MOVIE_MEDIARECORD_SEQUENTIAL_SD_CF       = SDK_MOVIE_MEDIARECORD_SEQUENTIAL_SD_CF,
	GFXETERNA55_MOVIE_MEDIARECORD_SEQUENTIAL_SLOT2_SLOT1 = SDK_MOVIE_MEDIARECORD_SEQUENTIAL_SLOT2_SLOT1,
};

// Movie Media Record ProRes
enum{
	GFXETERNA55_MOVIE_MEDIARECORD_PRORES_OFF       = SDK_MOVIE_MEDIARECORD_PRORES_OFF,
	GFXETERNA55_MOVIE_MEDIARECORD_PRORES_H264      = SDK_MOVIE_MEDIARECORD_PRORES_H264,
	GFXETERNA55_MOVIE_MEDIARECORD_PRORES_PROXY     = SDK_MOVIE_MEDIARECORD_PRORES_PROXY,
};

// Movie Media Record Container
enum{
	GFXETERNA55_MOVIE_MEDIARECORD_CONTAINER_MOV    = SDK_MOVIE_MEDIARECORD_CONTAINER_MOV,
	GFXETERNA55_MOVIE_MEDIARECORD_CONTAINER_MXF    = SDK_MOVIE_MEDIARECORD_CONTAINER_MXF,
};

// Movie HDMIOutput RAW
enum{
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RAW_OFF          = SDK_MOVIE_HDMI_OUTPUT_RAW_OFF,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RAW_ATOMOS       = SDK_MOVIE_HDMI_OUTPUT_RAW_ATOMOS,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RAW_BLACKMAGIC   = SDK_MOVIE_HDMI_OUTPUT_RAW_BLACKMAGIC,
};

// Movie HDMI Output RAW Resolution
enum{
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_4P8K  = SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_4P8K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_6P2K  = SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_6P2K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_8K    = SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_8K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_5P2K  = SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_5P2K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_4K    = SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_4K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_DCI_8K= SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_DCI_8K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_DCI_4K= SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_DCI_4K,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_RESOLUTION_FULLHD= SDK_MOVIE_HDMI_OUTPUT_RESOLUTION_FULLHD,
};

// Movie HDMI Output RAW FrameRate
enum{
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_59_94P = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_59_94P,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_50P    = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_50P,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_29_97P = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_29_97P,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_25P    = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_25P,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_24P    = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_24P,
	GFXETERNA55_MOVIE_HDMI_OUTPUT_FRAMERATE_23_98P = SDK_MOVIE_HDMI_OUTPUT_FRAMERATE_23_98P,
};

// Flog Recording
enum{
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_FSIM   = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_FSIM,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG_HDMI_FLOG   = SDK_MOVIERECORD_MEDIA_FLOG_HDMI_FLOG,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2_HDMI_FLOG2 = SDK_MOVIERECORD_MEDIA_FLOG2_HDMI_FLOG2,
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG   = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG,
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG2  = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG2,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG_HDMI_FSIM   = SDK_MOVIERECORD_MEDIA_FLOG_HDMI_FSIM,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2_HDMI_FSIM  = SDK_MOVIERECORD_MEDIA_FLOG2_HDMI_FSIM,
	GFXETERNA55_MOVIERECORD_MEDIA_HLG_HDMI_HLG     = SDK_MOVIERECORD_MEDIA_HLG_HDMI_HLG,
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG2C      = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_FLOG2C,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2C_HDMI_FLOG2C    = SDK_MOVIERECORD_MEDIA_FLOG2C_HDMI_FLOG2C,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2C_HDMI_FSIM      = SDK_MOVIERECORD_MEDIA_FLOG2C_HDMI_FSIM,
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_RAW_ATOMOS  = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_RAW_ATOMOS,
	GFXETERNA55_MOVIERECORD_MEDIA_FSIM_HDMI_RAW_BLACK   = SDK_MOVIERECORD_MEDIA_FSIM_HDMI_RAW_BLACK,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG_HDMI_RAW_ATOMOS  = SDK_MOVIERECORD_MEDIA_FLOG_HDMI_RAW_ATOMOS,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG_HDMI_RAW_BLACK   = SDK_MOVIERECORD_MEDIA_FLOG_HDMI_RAW_BLACK,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2_HDMI_RAW_ATOMOS = SDK_MOVIERECORD_MEDIA_FLOG2_HDMI_RAW_ATOMOS,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2_HDMI_RAW_BLACK  = SDK_MOVIERECORD_MEDIA_FLOG2_HDMI_RAW_BLACK,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2C_HDMI_RAW_ATOMOS= SDK_MOVIERECORD_MEDIA_FLOG2C_HDMI_RAW_ATOMOS,
	GFXETERNA55_MOVIERECORD_MEDIA_FLOG2C_HDMI_RAW_BLACK = SDK_MOVIERECORD_MEDIA_FLOG2C_HDMI_RAW_BLACK,
	GFXETERNA55_MOVIERECORD_MEDIA_HLG_HDMI_RAW_ATOMOS   = SDK_MOVIERECORD_MEDIA_HLG_HDMI_RAW_ATOMOS,
	GFXETERNA55_MOVIERECORD_MEDIA_HLG_HDMI_RAW_BLACK    = SDK_MOVIERECORD_MEDIA_HLG_HDMI_RAW_BLACK,
};

// SDI HDMI Output Fps
enum{
	GFXETERNA55_SDIHDMI_OUTPUT_FPS_PROJECT         = SDK_SDIHDMI_OUTPUT_FPS_PROJECT,
	GFXETERNA55_SDIHDMI_OUTPUT_FPS_RECORDING       = SDK_SDIHDMI_OUTPUT_FPS_RECORDING,
};

// MovieIsMode
enum{
	GFXETERNA55_MOVIE_IS_MODE_OFF                  = SDK_MOVIE_IS_MODE_OFF,
	GFXETERNA55_MOVIE_IS_MODE_ON                   = SDK_MOVIE_IS_MODE_ON,
	GFXETERNA55_MOVIE_IS_MODE_IBIS_OIS             = SDK_MOVIE_IS_MODE_IBIS_OIS,
	GFXETERNA55_MOVIE_IS_MODE_IBIS_OIS_DIS         = SDK_MOVIE_IS_MODE_IBIS_OIS_DIS,
	GFXETERNA55_MOVIE_IS_MODE_OIS                  = SDK_MOVIE_IS_MODE_OIS,
	GFXETERNA55_MOVIE_IS_MODE_OIS_DIS              = SDK_MOVIE_IS_MODE_OIS_DIS,
};

// Movie Zebra Setting
enum{
	GFXETERNA55_MOVIE_ZEBRA_SETTING_OFF            = SDK_MOVIE_ZEBRA_SETTING_OFF,
	GFXETERNA55_MOVIE_ZEBRA_SETTING_RIGHT          = SDK_MOVIE_ZEBRA_SETTING_RIGHT,
	GFXETERNA55_MOVIE_ZEBRA_SETTING_LEFT           = SDK_MOVIE_ZEBRA_SETTING_LEFT,
};

// Movie Tally Light
enum{
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_ON      = SDK_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_ON,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_BLINK   = SDK_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_BLINK,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_ON_REAR_ON       = SDK_MOVIE_TALLYLIGHT_FRONT_ON_REAR_ON,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_ON_REAR_OFF      = SDK_MOVIE_TALLYLIGHT_FRONT_ON_REAR_OFF,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_BLINK_REAR_BLINK = SDK_MOVIE_TALLYLIGHT_FRONT_BLINK_REAR_BLINK,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_BLINK_REAR_OFF   = SDK_MOVIE_TALLYLIGHT_FRONT_BLINK_REAR_OFF,
	GFXETERNA55_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_OFF     = SDK_MOVIE_TALLYLIGHT_FRONT_OFF_REAR_OFF,
};

// Media Eject Warning
enum{
	GFXETERNA55_MEDIA_EJECT_WARNING_SLOT1          = SDK_MEDIA_EJECT_WARNING_SLOT1,
	GFXETERNA55_MEDIA_EJECT_WARNING_SLOT2          = SDK_MEDIA_EJECT_WARNING_SLOT2,
	GFXETERNA55_MEDIA_EJECT_WARNING_SLOT3          = SDK_MEDIA_EJECT_WARNING_SLOT3,
};

// Movie Data Level Setting
enum{
	GFXETERNA55_MOVIE_DATA_LEVEL_SETTING_FULL      = SDK_MOVIE_DATA_LEVEL_SETTING_FULL,
	GFXETERNA55_MOVIE_DATA_LEVEL_SETTING_VIDEO     = SDK_MOVIE_DATA_LEVEL_SETTING_VIDEO,
};

// Movie ImageFormat
enum{
	GFXETERNA55_MOVIE_IMAGEFORMAT_GF               = SDK_MOVIE_IMAGEFORMAT_GF,
	GFXETERNA55_MOVIE_IMAGEFORMAT_35MM             = SDK_MOVIE_IMAGEFORMAT_35MM,
	GFXETERNA55_MOVIE_IMAGEFORMAT_ANAMORPHIC_35MM  = SDK_MOVIE_IMAGEFORMAT_ANAMORPHIC_35MM,
	GFXETERNA55_MOVIE_IMAGEFORMAT_PREMISTA         = SDK_MOVIE_IMAGEFORMAT_PREMISTA,
	GFXETERNA55_MOVIE_IMAGEFORMAT_SUPER_35MM       = SDK_MOVIE_IMAGEFORMAT_SUPER_35MM,
};

// WaveForm VectorScope
enum{
	GFXETERNA55_WAVEFORM_VECTORSCOPE_OFF           = SDK_WAVEFORM_VECTORSCOPE_OFF,
	GFXETERNA55_WAVEFORM_VECTORSCOPE_WAVEFORM      = SDK_WAVEFORM_VECTORSCOPE_WAVEFORM,
	GFXETERNA55_WAVEFORM_VECTORSCOPE_PARADE        = SDK_WAVEFORM_VECTORSCOPE_PARADE,
	GFXETERNA55_WAVEFORM_VECTORSCOPE_VECTORSCOPE   = SDK_WAVEFORM_VECTORSCOPE_VECTORSCOPE,
	GFXETERNA55_WAVEFORM_VECTORSCOPE_RGB_HISTOGRAM = SDK_WAVEFORM_VECTORSCOPE_RGB_HISTOGRAM,
	GFXETERNA55_WAVEFORM_VECTORSCOPE_HISTOGRAM     = SDK_WAVEFORM_VECTORSCOPE_HISTOGRAM,
};

// WaveForm Setting
enum{
	GFXETERNA55_WAVEFORM_SETTING_PATTERN1          = SDK_WAVEFORM_SETTING_PATTERN1,
	GFXETERNA55_WAVEFORM_SETTING_PATTERN2          = SDK_WAVEFORM_SETTING_PATTERN2,
	GFXETERNA55_WAVEFORM_SETTING_PATTERN3          = SDK_WAVEFORM_SETTING_PATTERN3,
	GFXETERNA55_WAVEFORM_SETTING_PATTERN4          = SDK_WAVEFORM_SETTING_PATTERN4,
};

// VectorScope Setting
enum{
	GFXETERNA55_VECTORSCORE_SETTING_PATTERN1       = SDK_VECTORSCORE_SETTING_PATTERN1,
	GFXETERNA55_VECTORSCORE_SETTING_PATTERN2       = SDK_VECTORSCORE_SETTING_PATTERN2,
	GFXETERNA55_VECTORSCORE_SETTING_PATTERN3       = SDK_VECTORSCORE_SETTING_PATTERN3,
	GFXETERNA55_VECTORSCORE_SETTING_PATTERN4       = SDK_VECTORSCORE_SETTING_PATTERN4,
};

// Parade Setting Display
enum{
	GFXETERNA55_PARADE_SETTING_DISPLAY_PATTERN1    = SDK_PARADE_SETTING_DISPLAY_PATTERN1,
	GFXETERNA55_PARADE_SETTING_DISPLAY_PATTERN2    = SDK_PARADE_SETTING_DISPLAY_PATTERN2,
	GFXETERNA55_PARADE_SETTING_DISPLAY_PATTERN3    = SDK_PARADE_SETTING_DISPLAY_PATTERN3,
	GFXETERNA55_PARADE_SETTING_DISPLAY_PATTERN4    = SDK_PARADE_SETTING_DISPLAY_PATTERN4,
};

// Parade Setting Color
enum{
	GFXETERNA55_PARADE_SETTING_COLOR_RGB           = SDK_PARADE_SETTING_COLOR_RGB,
	GFXETERNA55_PARADE_SETTING_COLOR_WHITE         = SDK_PARADE_SETTING_COLOR_WHITE,
};

// RGB Histogram Display
// Histogram Display
enum{
	GFXETERNA55_HISTOGRAM_DISPLAY_PATTERN1         = SDK_HISTOGRAM_DISPLAY_PATTERN1,
	GFXETERNA55_HISTOGRAM_DISPLAY_PATTERN2         = SDK_HISTOGRAM_DISPLAY_PATTERN2,
	GFXETERNA55_HISTOGRAM_DISPLAY_PATTERN3         = SDK_HISTOGRAM_DISPLAY_PATTERN3,
	GFXETERNA55_HISTOGRAM_DISPLAY_PATTERN4         = SDK_HISTOGRAM_DISPLAY_PATTERN4,
};

// Movie FocusMeter(display)
enum{
	GFXETERNA55_FOCUSMETER_DISPLAY_OFF             = SDK_FOCUSMETER_DISPLAY_OFF,
	GFXETERNA55_FOCUSMETER_DISPLAY_ON              = SDK_FOCUSMETER_DISPLAY_ON,
};

// Movie FocusMeter(color)
enum{
	GFXETERNA55_FOCUSMETER_COLOR_WHITE             = SDK_FOCUSMETER_COLOR_WHITE,
	GFXETERNA55_FOCUSMETER_COLOR_GREEN             = SDK_FOCUSMETER_COLOR_GREEN,
};

// TimeCode Start Setting
enum{
	GFXETERNA55_TIMECODE_START_SETTING_MANUAL      = SDK_TIMECODE_START_SETTING_MANUAL,
	GFXETERNA55_TIMECODE_START_SETTING_CURRENT     = SDK_TIMECODE_START_SETTING_CURRENT,
	GFXETERNA55_TIMECODE_START_SETTING_RESET       = SDK_TIMECODE_START_SETTING_RESET,
};

// TimeCode CountUp
enum{
	GFXETERNA55_TIMECODE_COUNTUP_RECRUN            = SDK_TIMECODE_COUNTUP_RECRUN,
	GFXETERNA55_TIMECODE_COUNTUP_FREERUN           = SDK_TIMECODE_COUNTUP_FREERUN,
};

// TimeCode Status
enum{
	GFXETERNA55_TIMECODE_STATUS_USE_DSC_ALONE      = SDK_TIMECODE_STATUS_USE_DSC_ALONE,
	GFXETERNA55_TIMECODE_STATUS_SYNCING            = SDK_TIMECODE_STATUS_SYNCING,
	GFXETERNA55_TIMECODE_STATUS_DISCONNECTED       = SDK_TIMECODE_STATUS_DISCONNECTED,
	GFXETERNA55_TIMECODE_STATUS_NOT_SYNCED         = SDK_TIMECODE_STATUS_NOT_SYNCED,
	GFXETERNA55_TIMECODE_STATUS_FRAMERATE_MISMATCH = SDK_TIMECODE_STATUS_FRAMERATE_MISMATCH,
};

// TimeCode Sync Setting
enum{
	GFXETERNA55_TIMECODE_SYNCSETTING_CAMERA        = SDK_TIMECODE_SYNCSETTING_CAMERA,
	GFXETERNA55_TIMECODE_SYNCSETTING_BLUETOOTH     = SDK_TIMECODE_SYNCSETTING_BLUETOOTH,
	GFXETERNA55_TIMECODE_SYNCSETTING_USB           = SDK_TIMECODE_SYNCSETTING_USB,
	GFXETERNA55_TIMECODE_SYNCSETTING_MIC           = SDK_TIMECODE_SYNCSETTING_MIC,
	GFXETERNA55_TIMECODE_SYNCSETTING_TC_IN         = SDK_TIMECODE_SYNCSETTING_TC_IN,
};

// TimeCode Connector
enum{
	GFXETERNA55_TIMECODE_CONNECTOR_IN              = SDK_TIMECODE_CONNECTOR_IN,
	GFXETERNA55_TIMECODE_CONNECTOR_OUT             = SDK_TIMECODE_CONNECTOR_OUT,
};

// Genlock Status
enum{
	GFXETERNA55_GENLOCK_STATUS_NOT_CONNECTED       = SDK_GENLOCK_STATUS_NOT_CONNECTED,
	GFXETERNA55_GENLOCK_STATUS_UNLOCK              = SDK_GENLOCK_STATUS_UNLOCK,
	GFXETERNA55_GENLOCK_STATUS_LOCKED              = SDK_GENLOCK_STATUS_LOCKED,
};

// Internal Mic Level
// External Mic Level
enum{
	GFXETERNA55_MIC_LEVEL_OFF                      = SDK_MIC_LEVEL_OFF,
	GFXETERNA55_MIC_LEVEL_MANUAL                   = SDK_MIC_LEVEL_MANUAL,
	GFXETERNA55_MIC_LEVEL_AUTO                     = SDK_MIC_LEVEL_AUTO,
};

// HeadPhones Volume
enum{
	GFXETERNA55_HEADPHONES_VOLUME_0                = SDK_HEADPHONES_VOLUME_0,
	GFXETERNA55_HEADPHONES_VOLUME_1                = SDK_HEADPHONES_VOLUME_1,
	GFXETERNA55_HEADPHONES_VOLUME_2                = SDK_HEADPHONES_VOLUME_2,
	GFXETERNA55_HEADPHONES_VOLUME_3                = SDK_HEADPHONES_VOLUME_3,
	GFXETERNA55_HEADPHONES_VOLUME_4                = SDK_HEADPHONES_VOLUME_4,
	GFXETERNA55_HEADPHONES_VOLUME_5                = SDK_HEADPHONES_VOLUME_5,
	GFXETERNA55_HEADPHONES_VOLUME_6                = SDK_HEADPHONES_VOLUME_6,
	GFXETERNA55_HEADPHONES_VOLUME_7                = SDK_HEADPHONES_VOLUME_7,
	GFXETERNA55_HEADPHONES_VOLUME_8                = SDK_HEADPHONES_VOLUME_8,
	GFXETERNA55_HEADPHONES_VOLUME_9                = SDK_HEADPHONES_VOLUME_9,
	GFXETERNA55_HEADPHONES_VOLUME_10               = SDK_HEADPHONES_VOLUME_10,
};

// XLR Adapter Mic Source
enum{
	GFXETERNA55_XLRADAPTER_MIC_SOURCE_4CH          = SDK_XLRADAPTER_MIC_SOURCE_4CH,
	GFXETERNA55_XLRADAPTER_MIC_SOURCE_2CH          = SDK_XLRADAPTER_MIC_SOURCE_2CH,
};

// XLR Adapter Monitering Source
enum{
	GFXETERNA55_XLRADAPTER_MONITER_SOURCE_XLR      = SDK_XLRADAPTER_MONITER_SOURCE_XLR,
	GFXETERNA55_XLRADAPTER_MONITER_SOURCE_CAMERA   = SDK_XLRADAPTER_MONITER_SOURCE_CAMERA,
};

// XLR Adapter HDMI Output Source
enum{
	GFXETERNA55_XLRADAPTER_HDMIOUTPUT_SOURCE_XLR   = SDK_XLRADAPTER_HDMIOUTPUT_SOURCE_XLR,
	GFXETERNA55_XLRADAPTER_HDMIOUTPUT_SOURCE_CAMERA= SDK_XLRADAPTER_HDMIOUTPUT_SOURCE_CAMERA,
};

// Directional Mic
enum{
	GFXETERNA55_DIRECTIONAL_MIC_AUTO               = SDK_DIRECTIONAL_MIC_AUTO,
	GFXETERNA55_DIRECTIONAL_MIC_SURROUND           = SDK_DIRECTIONAL_MIC_SURROUND,
	GFXETERNA55_DIRECTIONAL_MIC_FRONT              = SDK_DIRECTIONAL_MIC_FRONT,
	GFXETERNA55_DIRECTIONAL_MIC_TRACKING           = SDK_DIRECTIONAL_MIC_TRACKING,
	GFXETERNA55_DIRECTIONAL_MIC_BACK               = SDK_DIRECTIONAL_MIC_BACK,
	GFXETERNA55_DIRECTIONAL_MIC_FRONT_BACK         = SDK_DIRECTIONAL_MIC_FRONT_BACK,
};

// Body Temperature Warning
enum{
	GFXETERNA55_BODY_TEMPERATURE_WARNING_NONE      = SDK_BODY_TEMPERATURE_WARNING_NONE,
	GFXETERNA55_BODY_TEMPERATURE_WARNING_YELLOW    = SDK_BODY_TEMPERATURE_WARNING_YELLOW,
	GFXETERNA55_BODY_TEMPERATURE_WARNING_RED       = SDK_BODY_TEMPERATURE_WARNING_RED,
};

// Movie Rec Volume
enum{
	GFXETERNA55_MOVIE_REC_VOLUME_OFF               = SDK_MOVIE_REC_VOLUME_OFF,
	GFXETERNA55_MOVIE_REC_VOLUME_1                 = SDK_MOVIE_REC_VOLUME_1,
	GFXETERNA55_MOVIE_REC_VOLUME_2                 = SDK_MOVIE_REC_VOLUME_2,
	GFXETERNA55_MOVIE_REC_VOLUME_3                 = SDK_MOVIE_REC_VOLUME_3,
};

// Movie FocusCheck Mode
enum{
	GFXETERNA55_MOVIE_FOCUSCHECKMODE_ON            = SDK_MOVIE_FOCUSCHECKMODE_ON,
	GFXETERNA55_MOVIE_FOCUSCHECKMODE_OFF           = SDK_MOVIE_FOCUSCHECKMODE_OFF,
	GFXETERNA55_MOVIE_FOCUSCHECKMODE_ON_LOW        = SDK_MOVIE_FOCUSCHECKMODE_ON_LOW,
	GFXETERNA55_MOVIE_FOCUSCHECKMODE_ON_HIGH       = SDK_MOVIE_FOCUSCHECKMODE_ON_HIGH,
};

// Movie Sensitivity FDGain
enum{
	GFXETERNA55_MOVIE_SENSITIVITY_FDGAIN_AUTO      = SDK_MOVIE_SENSITIVITY_FDGAIN_AUTO,
	GFXETERNA55_MOVIE_SENSITIVITY_FDGAIN_HIGH      = SDK_MOVIE_SENSITIVITY_FDGAIN_HIGH,
	GFXETERNA55_MOVIE_SENSITIVITY_FDGAIN_LOW       = SDK_MOVIE_SENSITIVITY_FDGAIN_LOW,
};

// Movie Shutter Display
enum{
	GFXETERNA55_MOVIE_SHUTTER_DISPLAY_ANGLE        = SDK_MOVIE_SHUTTER_DISPLAY_ANGLE,
	GFXETERNA55_MOVIE_SHUTTER_DISPLAY_SPEED        = SDK_MOVIE_SHUTTER_DISPLAY_SPEED,
};

// Movie ND Mode
enum{
	GFXETERNA55_MOVIE_NDMODE_CLEAR                 = SDK_MOVIE_NDMODE_CLEAR,
	GFXETERNA55_MOVIE_NDMODE_ON_VARIABLE           = SDK_MOVIE_NDMODE_ON_VARIABLE,
};

// Movie ND Display
enum{
	GFXETERNA55_MOVIE_NDDISPLAY_DENSITY            = SDK_MOVIE_NDDISPLAY_DENSITY,
	GFXETERNA55_MOVIE_NDDISPLAY_FACTOR             = SDK_MOVIE_NDDISPLAY_FACTOR,
};

// Look Mode
enum{
	GFXETERNA55_LOOKMODE_A                         = SDK_LOOKMODE_A,
	GFXETERNA55_LOOKMODE_B                         = SDK_LOOKMODE_B,
	GFXETERNA55_LOOKMODE_C                         = SDK_LOOKMODE_C,
};

// LUT Setting
enum{
	GFXETERNA55_LUTSETTING_CATEGORY_FILMSIMULATION = SDK_LUTSETTING_CATEGORY_FILMSIMULATION,
	GFXETERNA55_LUTSETTING_CATEGORY_FLOG           = SDK_LUTSETTING_CATEGORY_FLOG,
	GFXETERNA55_LUTSETTING_CATEGORY_FLOG2          = SDK_LUTSETTING_CATEGORY_FLOG2,
	GFXETERNA55_LUTSETTING_CATEGORY_FLOG2C         = SDK_LUTSETTING_CATEGORY_FLOG2C,
	GFXETERNA55_LUTSETTING_CATEGORY_HLG            = SDK_LUTSETTING_CATEGORY_HLG,
	GFXETERNA55_LUTSETTING_DEFAULT                 = SDK_LUTSETTING_DEFAULT,
	GFXETERNA55_LUTSETTING_LUT1                    = SDK_LUTSETTING_LUT1,
	GFXETERNA55_LUTSETTING_LUT2                    = SDK_LUTSETTING_LUT2,
	GFXETERNA55_LUTSETTING_LUT3                    = SDK_LUTSETTING_LUT3,
	GFXETERNA55_LUTSETTING_LUT4                    = SDK_LUTSETTING_LUT4,
	GFXETERNA55_LUTSETTING_LUT5                    = SDK_LUTSETTING_LUT5,
	GFXETERNA55_LUTSETTING_LUT6                    = SDK_LUTSETTING_LUT6,
	GFXETERNA55_LUTSETTING_LUT7                    = SDK_LUTSETTING_LUT7,
	GFXETERNA55_LUTSETTING_LUT8                    = SDK_LUTSETTING_LUT8,
	GFXETERNA55_LUTSETTING_LUT9                    = SDK_LUTSETTING_LUT9,
	GFXETERNA55_LUTSETTING_LUT10                   = SDK_LUTSETTING_LUT10,
	GFXETERNA55_LUTSETTING_LUT11                   = SDK_LUTSETTING_LUT11,
	GFXETERNA55_LUTSETTING_LUT12                   = SDK_LUTSETTING_LUT12,
	GFXETERNA55_LUTSETTING_LUT13                   = SDK_LUTSETTING_LUT13,
	GFXETERNA55_LUTSETTING_LUT14                   = SDK_LUTSETTING_LUT14,
	GFXETERNA55_LUTSETTING_LUT15                   = SDK_LUTSETTING_LUT15,
	GFXETERNA55_LUTSETTING_LUT16                   = SDK_LUTSETTING_LUT16,
};

// Movie WhiteBalance Preset
enum{
	GFXETERNA55_WB_PRESET_COMMAND_ADD              = SDK_WB_PRESET_COMMAND_ADD,
	GFXETERNA55_WB_PRESET_COMMAND_DELETE           = SDK_WB_PRESET_COMMAND_DELETE,
	GFXETERNA55_WB_PRESET_COMMAND_EDIT             = SDK_WB_PRESET_COMMAND_EDIT,
	GFXETERNA55_WB_PRESET1                         = SDK_WB_PRESET1,
	GFXETERNA55_WB_PRESET2                         = SDK_WB_PRESET2,
	GFXETERNA55_WB_PRESET3                         = SDK_WB_PRESET3,
	GFXETERNA55_WB_PRESET4                         = SDK_WB_PRESET4,
	GFXETERNA55_WB_PRESET5                         = SDK_WB_PRESET5,
	GFXETERNA55_WB_PRESET6                         = SDK_WB_PRESET6,
	GFXETERNA55_WB_PRESET7                         = SDK_WB_PRESET7,
	GFXETERNA55_WB_PRESET8                         = SDK_WB_PRESET8,
	GFXETERNA55_WB_PRESET9                         = SDK_WB_PRESET9,
	GFXETERNA55_WB_PRESET10                        = SDK_WB_PRESET10,
	GFXETERNA55_WB_PRESET11                        = SDK_WB_PRESET11,
	GFXETERNA55_WB_PRESET12                        = SDK_WB_PRESET12,
	GFXETERNA55_WB_PRESET13                        = SDK_WB_PRESET13,
	GFXETERNA55_WB_PRESET14                        = SDK_WB_PRESET14,
	GFXETERNA55_WB_PRESET15                        = SDK_WB_PRESET15,
	GFXETERNA55_WB_PRESET16                        = SDK_WB_PRESET16,
	GFXETERNA55_WB_PRESET17                        = SDK_WB_PRESET17,
	GFXETERNA55_WB_PRESET18                        = SDK_WB_PRESET18,
	GFXETERNA55_WB_PRESET19                        = SDK_WB_PRESET19,
	GFXETERNA55_WB_PRESET20                        = SDK_WB_PRESET20,
	GFXETERNA55_WB_PRESET21                        = SDK_WB_PRESET21,
	GFXETERNA55_WB_PRESET22                        = SDK_WB_PRESET22,
	GFXETERNA55_WB_PRESET23                        = SDK_WB_PRESET23,
	GFXETERNA55_WB_PRESET24                        = SDK_WB_PRESET24,
	GFXETERNA55_WB_PRESET25                        = SDK_WB_PRESET25,
	GFXETERNA55_WB_PRESET26                        = SDK_WB_PRESET26,
	GFXETERNA55_WB_PRESET27                        = SDK_WB_PRESET27,
	GFXETERNA55_WB_PRESET28                        = SDK_WB_PRESET28,
	GFXETERNA55_WB_PRESET29                        = SDK_WB_PRESET29,
	GFXETERNA55_WB_PRESET30                        = SDK_WB_PRESET30,
	GFXETERNA55_WB_PRESET31                        = SDK_WB_PRESET31,
	GFXETERNA55_WB_PRESET32                        = SDK_WB_PRESET32,
};

// FrameGuide Frame
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAME1            = SDK_MOVIE_FRAMEGUIDE_FRAME1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAME2            = SDK_MOVIE_FRAMEGUIDE_FRAME2,
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAME3            = SDK_MOVIE_FRAMEGUIDE_FRAME3,
};

// FrameGuide Aspect
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_OFF        = SDK_MOVIE_FRAMEGUIDE_ASPECT_OFF,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_CUSTOM     = SDK_MOVIE_FRAMEGUIDE_ASPECT_CUSTOM,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_2P39_1     = SDK_MOVIE_FRAMEGUIDE_ASPECT_2P39_1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_2P35_1     = SDK_MOVIE_FRAMEGUIDE_ASPECT_2P35_1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_17_9       = SDK_MOVIE_FRAMEGUIDE_ASPECT_17_9,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_16_9       = SDK_MOVIE_FRAMEGUIDE_ASPECT_16_9,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_5_4        = SDK_MOVIE_FRAMEGUIDE_ASPECT_5_4,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_4_3        = SDK_MOVIE_FRAMEGUIDE_ASPECT_4_3,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_3_2        = SDK_MOVIE_FRAMEGUIDE_ASPECT_3_2,
	GFXETERNA55_MOVIE_FRAMEGUIDE_ASPECT_1_1        = SDK_MOVIE_FRAMEGUIDE_ASPECT_1_1,
};

// FrameGuide Color
// FrameGuide CenterMarker Color
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_COLOR_BLACK       = SDK_MOVIE_FRAMEGUIDE_COLOR_BLACK,
	GFXETERNA55_MOVIE_FRAMEGUIDE_COLOR_WHITE       = SDK_MOVIE_FRAMEGUIDE_COLOR_WHITE,
	GFXETERNA55_MOVIE_FRAMEGUIDE_COLOR_YELLOW      = SDK_MOVIE_FRAMEGUIDE_COLOR_YELLOW,
	GFXETERNA55_MOVIE_FRAMEGUIDE_COLOR_MAGENTA     = SDK_MOVIE_FRAMEGUIDE_COLOR_MAGENTA,
	GFXETERNA55_MOVIE_FRAMEGUIDE_COLOR_CYAN        = SDK_MOVIE_FRAMEGUIDE_COLOR_CYAN,
};


// FrameGuide FrameLine
// FrameGuide CenterMarker FrameLine
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAMELINE1        = SDK_MOVIE_FRAMEGUIDE_FRAMELINE1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAMELINE2        = SDK_MOVIE_FRAMEGUIDE_FRAMELINE2,
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAMELINE3        = SDK_MOVIE_FRAMEGUIDE_FRAMELINE3,
	GFXETERNA55_MOVIE_FRAMEGUIDE_FRAMELINE4        = SDK_MOVIE_FRAMEGUIDE_FRAMELINE4,
};


// FrameGuide Mask Frame Select
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_MASKFRAME1        = SDK_MOVIE_FRAMEGUIDE_MASKFRAME1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_MASKFRAME2        = SDK_MOVIE_FRAMEGUIDE_MASKFRAME2,
	GFXETERNA55_MOVIE_FRAMEGUIDE_MASKFRAME3        = SDK_MOVIE_FRAMEGUIDE_MASKFRAME3,
};

// FrameGuide CenterMarker Pattern
enum{
	GFXETERNA55_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN1 = SDK_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN1,
	GFXETERNA55_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN2 = SDK_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN2,
	GFXETERNA55_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN3 = SDK_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN3,
	GFXETERNA55_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN4 = SDK_MOVIE_FRAMEGUIDE_CENTERMARKER_PATTERN4,
};

// Frameio FileType
enum{
	GFXETERNA55_MOVIE_FRAMEIO_FILETYPE_MOV_PROXY   = SDK_FRAMEIO_FILETYPE_MOV_PROXY,
	GFXETERNA55_MOVIE_FRAMEIO_FILETYPE_MOV_PRORES  = SDK_FRAMEIO_FILETYPE_MOV_PRORES,
	GFXETERNA55_MOVIE_FRAMEIO_FILETYPE_MOV_OTHER   = SDK_FRAMEIO_FILETYPE_MOV_OTHER,
	GFXETERNA55_MOVIE_FRAMEIO_FILETYPE_JPEG        = SDK_FRAMEIO_FILETYPE_JPEG,
};

// Frameio TransferSuspend
enum{
	GFXETERNA55_FRAMEIO_TRANSFERSUSPEND_TRANSFER   = SDK_FRAMEIO_TRANSFERSUSPEND_TRANSFER,
	GFXETERNA55_FRAMEIO_TRANSFERSUSPEND_SUSPEND    = SDK_FRAMEIO_TRANSFERSUSPEND_SUSPEND,
};

// Frameio Reset Transfer Order
enum{
	GFXETERNA55_FRAMEIO_RESETTRANFERORDER_RESET    = SDK_FRAMEIO_RESETTRANFERORDER_RESET,

};

// Frameio Connection Status
enum{
	GFXETERNA55_FRAMEIO_CONNECTIONSTATUS_NOT_CONNECTED       = SDK_FRAMEIO_CONNECTIONSTATUS_NOT_CONNECTED,
	GFXETERNA55_FRAMEIO_CONNECTIONSTATUS_CONNECTED           = SDK_FRAMEIO_CONNECTIONSTATUS_CONNECTED,
	GFXETERNA55_FRAMEIO_CONNECTIONSTATUS_TRANSFER_SUSPENDED  = SDK_FRAMEIO_CONNECTIONSTATUS_TRANSFER_SUSPENDED,
	GFXETERNA55_FRAMEIO_CONNECTIONSTATUS_CONNECTION_SUSPENDED= SDK_FRAMEIO_CONNECTIONSTATUS_CONNECTION_SUSPENDED,
};

// Playback File Format
enum{
	GFXETERNA55_PLAYBACK_FILEFORMAT_MOVIE          = SDK_PLAYBACK_FILEFORMAT_MOVIE,
	GFXETERNA55_PLAYBACK_FILEFORMAT_STILL          = SDK_PLAYBACK_FILEFORMAT_STILL,
};
