package com.fujifilm.liveview.xsdk

class XSDK {
    companion object {
        init {
            System.loadLibrary("LibWrapper")
        }
    }

    data class SDKLong(
        var long:Long
    )

    data class SDKString(
        var string:String
    )

    data class XSDK_DeviceInformation(
        var strVendor:String = "",
        var strManufacturer:String = "",
        var strProduct:String = "",
        var strFirmware :String = "",
        var strDeviceType:String = "",
        var strSerialNo:String = "",
        var strFramework:String = "",
        var bDeviceId:Byte = 0,
        var strDeviceName:String = "",
        var strYNo:String = ""
    )

    data class XSDK_LensInformation(
        var strModel:String = "",
        var strProductName:String = "",
        var strSerialNo:String = "",
        var lISCapability:Long = 0,
        var lMFCapability:Long = 0,
        var lZoomPosCapability:Long = 0
    )

    data class XSDK_ImageInformation(
        var strInternalName:String = "",
        var lFormat:Long = 0,
        var lDataSize:Long = 0,
        var lImagePixHeight:Long = 0,
        var lImagePixWidth:Long = 0,
        var lImageBitDepth:Long = 0,
        var lPreviewSize:Long = 0,
        var hImage:Long = 0
    )

    data class SDK_FaceFrameInfo(
        var lID:Long = 0,
        var lTime:Long = 0,
        var lX:Long = 0,
        var lY:Long = 0,
        var lLength_H:Long = 0,
        var lLength_V:Long = 0,
        var lColorR:Long = 0,
        var lColorG:Long = 0,
        var lColorB:Long = 0,
        var lAlpha:Long = 0,
        var lType:Long = 0,
        var lLikeness:Long = 0,
        var lDisp:Long = 0,
        var lSelected:Long = 0
    )

    data class SDK_MOVIE_AFC_CUSTOM(
        var lTracking:Long = 0,
        var lSpeed:Long = 0
    )

    data class SDK_FocusArea(
        var h:Long = 0,
        var v:Long = 0,
        var size:Long = 0
    )

    data class SDK_AFZoneCustom(
        var h:Long = 0,
        var v:Long = 0
    )

    data class SDK_AFZoneCustomCapablity(
        var mode:Long = 0,
        var min:SDK_AFZoneCustom = SDK_AFZoneCustom(),
        var max:SDK_AFZoneCustom = SDK_AFZoneCustom()
    )

    data class SDK_CustomWBArea(
        var lX:Long = 0,
        var lY:Long = 0,
        var lSize:Long = 0,
        var lMode:Long = 0
    )

    data class SDK_FrameGuideGridInfo(
        var lGridH:LongArray = LongArray(5),
        var lGridV:LongArray = LongArray(5),
        var lLineWidthH:Long = 0,
        var lLineWidthV:Long = 0,
        var lLineColorIndex:Long = 0,
        var lLineAlpha:Long = 0
    )

    data class SDK_CropAreaFrameInfo(
        var lX:Long = 0,
        var lY:Long = 0,
        var lLength_H:Long = 0,
        var lLength_V:Long = 0,
        var lColorR:Long = 0,
        var lColorG:Long = 0,
        var lColorB:Long = 0,
        var lAlpha:Long = 0
    )

    data class SDK_FOCUS_LIMITER_INDICATOR(
        var lCurrent:Long = 0,
        var lDOF_Near:Long = 0,
        var lDOF_Far:Long = 0,
        var lPos_A:Long = 0,
        var lPos_B:Long = 0,
        var lStatus:Long = 0
    )

    data class SDK_FOCUS_LIMITER(
        var lPos_A:Long = 0,
        var lPos_B:Long = 0
    )

    data class SDK_TrackingAfFrameInfo(
        var lX:Long = 0,
        var lY:Long = 0,
        var lLength_H:Long = 0,
        var lLength_V:Long = 0,
        var lColorR:Long = 0,
        var lColorG:Long = 0,
        var lColorB:Long = 0,
        var lAlpha:Long = 0
    )

    data class SDK_MovieTransparentFrameInfo(
        var lX:Long = 0,
        var lY:Long = 0,
        var lLength_H:Long = 0,
        var lLength_V:Long = 0,
        var lAlpha:Long = 0
    )

    data class SDK_MICLEVEL_INDICATOR(
        var lDSC_L_Peak:Long = 0,
        var lDSC_L_PeakHold:Long = 0,
        var lDSC_R_Peak:Long = 0,
        var lDSC_R_PeakHold:Long = 0,
        var lXLR_1_Peak:Long = 0,
        var lXLR_1_PeakHold:Long = 0,
        var lXLR_2_Peak:Long = 0,
        var lXLR_2_PeakHold:Long = 0,
        var lWarning1:Long = 0,
        var lWarning2:Long = 0,
        var lMicLine:Long = 0
    )

    data class SDK_PlayBackObjectInformation(
        var lFormat:Long = 0,
        var llDataSize:Long = 0,
        var lThumbSize:Long = 0,
        var strFileName:String = "",
        var strcapturedata:String = "",
        var lImagePixHeight:Long = 0,
        var lImagePixWidth:Long = 0,
        var lImageBitDepth:Long = 0,
        var Duration:Long = 0
    )

    data class SDK_FOLDER_INFO(
        var pFoldernameSuffix:String = "",
        var lFolderNumber:Long = 0,
        var lMaxFrameNumber:Long = 0,
        var lStatus:Long = 0
    )

    data class SDK_FOCUS_POS_CAP(
        var lSizeFocusPosCap:Long = 0,
        var lStructVer:Long = 0,
        var lFocusPlsINF:Long = 0,
        var lFocusPlsMOD:Long = 0,
        var lFocusOverSearchPlsINF:Long = 0,
        var lFocusOverSearchPlsMOD:Long = 0,
        var lFocusPlsFCSDepthCap:Long = 0,
        var lMinDriveStepMFDriveEndThresh:Long = 0
    )

    data class SDK_FocusMapData(
        var lDistance:Long = 0,
        var lColorR:Long = 0,
        var lColorG:Long = 0,
        var lColorB:Long = 0,
        var lAlpha:Long = 0
    )

    data class SDK_HistogramData(
        var lLuminance:Long = 0,
        var lColorR:Long = 0,
        var lColorG:Long = 0,
        var lColorB:Long = 0
    )

    //////////////////////////////// JNI APIs ///////////////////////////////////
    /**
     * Load library
     *
     * @return Load library result.
     */
    external fun XSDK_loadLibrary(): Long
    /**
     * Initializes and starts use of the SDK.
     *
     * @return API result.
     */
    external fun XSDK_Init(): Long

    /**
     * Finalizes and terminates use of the SDK.
     *
     * @return API result.
     */
    external fun XSDK_Exit():Long

    /**
     * Establishes a session between the camera and the computer.
     *
     * @param lFileDescriptor
     * @param descriptors
     * @param phCamera Returns the camera handle when the function completes.
     * @return API result.
     */
    external fun XSDK_SetUSBDeviceHandle(lFileDescriptor:Long, descriptors:ByteArray, phCamera: SDKLong): Long

    /**
     * Disestablish a session between the camera and the computer.
     *
     * @param hCamera Camera handle.
     * @return API result.
     */
    external fun XSDK_Close(hCamera:Long):Long

    /**
     * Disestablish a session between the camera and the computer, and shut the camera down.
     *
     * @param hCamera Camera handle.
     * @return API result.
     */
    external fun XSDK_PowerOFF(hCamera:Long):Long

    /**
     * Gets the detailed result of the last called function.
     *
     * @param hCamera Camera handle , phCamera can be set to NULL.
     * @param plAPICode The last called API code.
     * @param plERRCode See the ERROR CODES for details.
     * @return API result.
     */
    external fun XSDK_GetErrorNumber(hCamera:Long, plAPICode: SDKLong, plERRCode: SDKLong):Long

    /**
     * Gets details of the busy error when the plERRCode returned by a call to XSDK_GetErrorNumber is XSDK_ERRCODE_RUNNING_OTHER_FUNCTION.
     *
     * @param hCamera Camera handle , phCamera can be set to NULL.
     * @param plERRCode Returns the function currently running.
     * @return API result.
     */
    external fun XSDK_GetErrorDetails(hCamera:Long, plERRCode: SDKLong):Long

    /**
     * Gets version numbers in a string format.
     *
     * @param pVersionString Returns the SDK version as a string.
     * @return API result.
     */
    external fun XSDK_GetVersionString(pVersionString: SDKString):Long

    /**
     * Gets information about the connected camera.
     *
     * @param hCamera Camera handle.
     * @param pDevInfo Returns camera information.
     * @return API result.
     */
    external fun XSDK_GetDeviceInfo(hCamera:Long, pDevInfo: XSDK_DeviceInformation):Long

    /**
     * Gets information about the connected camera and supported APIs by the camera.
     *
     * @param hCamera Camera handle.
     * @param pDevInfo Returns camera information.
     * @param plNumAPICode Returns the number of APICode supported.
     * @param plAPICode If not NULL, plAPICode will return a list of APICode supported.
     * @return API result.
     */
    external fun XSDK_GetDeviceInfoEx(hCamera:Long, pDevInfo: XSDK_DeviceInformation, plNumAPICode: SDKLong, plAPICode: LongArray?):Long

    /**
     * Assigns a device-unique name to the camera.
     *
     * @param hCamera Camera handle.
     * @param pDeviceName A unique name. Up to 32 characters including the NULL terminator.
     * @return API result.
     */
    external fun XSDK_WriteDeviceName(hCamera:Long, pDeviceName: String):Long

    /**
     * Assigns a device-unique name to the camera.
     *
     * @param hCamera Camera handle.
     * @param pFirmwareVersion Returns the camera firmware version as a string.
     * @return API result.
     */
    external fun XSDK_GetFirmwareVersion(hCamera:Long, pFirmwareVersion: SDKString):Long

    /**
     * Gets lens information from the camera.
     *
     * @param hCamera Camera handle.
     * @param pLensInfo Returns lens information.
     * @return API result.
     */
    external fun XSDK_GetLensInfo(hCamera:Long, pLensInfo: XSDK_LensInformation):Long

    /**
     * Gets the firmware version of the lens attached to the camera in a string format.
     *
     * @param hCamera Camera handle.
     * @param pLensVersion Returns the lens firmware version as a string.
     * @return API result.
     */
    external fun XSDK_GetLensVersion(hCamera:Long, pLensVersion: SDKString):Long

    /**
     * Queries supported operation modes.
     *
     * @param hCamera Camera handle.
     * @param plNumPriorityMode Returns the supported number of settings for XSDK_SetPriorityMode.
     * @param plPriorityMode If not NULL, plPriorityMode will return a list of the XSDK_SetPriorityMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapPriorityMode(hCamera:Long, plNumPriorityMode: SDKLong, plPriorityMode:LongArray?):Long

    /**
     * Sets the camera operation mode.
     *
     * @param hCamera Camera handle.
     * @param lPriorityMode The priority mode.
     * @return API result.
     */
    external fun XSDK_SetPriorityMode(hCamera:Long, lPriorityMode:Long):Long

    /**
     * Gets the current camera operation mode.
     *
     * @param hCamera Camera handle.
     * @param pPriorityMode The priority mode.
     * @return API result.
     */
    external fun XSDK_GetPriorityMode(hCamera:Long, pPriorityMode: SDKLong):Long

    /**
     * Queries supported release-related modes when the system is in PC priority mode.
     *
     * @param hCamera Camera handle.
     * @param plNumReleaseMode The number of supported XSDK_Release settings.
     * @param plReleaseMode If plReleaseMode is NULL, the function will return only plNumReleaseMode with the number of supported XSDK_Release lReleaseMode settings.
     * @return API result.
     */
    external fun XSDK_CapRelease(hCamera:Long, plNumReleaseMode: SDKLong, plReleaseMode:LongArray?):Long

    /**
     * Triggers shutter release-related operations when the system is in PC priority mode.
     *
     * @param hCamera Camera handle.
     * @param lReleaseMode If plReleaseMode is NULL, the function will return only plNumReleaseMode with the number of supported XSDK_Release lReleaseMode settings.
     * @param pShotOpt Specifies the number of pictures to be taken per burst in burst photography modes and returns the number of pictures actually taken.
     * @param pStatus Sometimes returns AF status when the function is called for S1- and S2-related operations.
     *                  Calls to measure custom white balance return autoexposure status.
     * @return API result.
     */
    external fun XSDK_Release(hCamera:Long, lReleaseMode:Long, pShotOpt: SDKLong, pStatus: SDKLong):Long

    /**
     * Queries supported release-related modes when the system is in CAMERA priority mode.
     *
     * @param hCamera Camera handle.
     * @param plNumReleaseMode The number of supported XSDK_Release settings.
     * @param plReleaseMode If pulReleaseMode is NULL, the function will return only plNumReleaseMode with the number of supported XSDK_ReleaseEx ulReleaseMode settings.
     *                      Otherwise it will return pulReleaseMode with a list of the XSDK_ReleaseEx ulReleaseMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapReleaseEx(hCamera:Long, plNumReleaseMode: SDKLong, plReleaseMode:LongArray?):Long

    /**
     * Triggers shutter release-related operations when the system is in camera priority mode.
     *
     * @param hCamera Camera handle.
     * @param lReleaseMode If pulReleaseMode is NULL, the function will return only plNumReleaseMode with the number of supported XSDK_ReleaseEx ulReleaseMode settings.
     *                      Otherwise it will return pulReleaseMode with a list of the XSDK_ReleaseEx ulReleaseMode settings supported.
     * @param pShotOpt Specifies the number of pictures to be taken per burst in burst photography modes and returns the number of pictures actually taken.
     * @param pStatus Sometimes returns AF status when the function is called for S1- and S2-related operations.
     *                  Calls to measure custom white balance return autoexposure status.
     * @return API result.
     */
    external fun XSDK_ReleaseEx(hCamera:Long, lReleaseMode:Long, pShotOpt: SDKLong, pStatus: SDKLong):Long

    /**
     * Gets the status of release operation.
     *
     * @param hCamera Camera handle.
     * @param plReleaseStatus Returns release status via bit ON/OFF.
     * @return API result.
     */
    external fun XSDK_GetReleaseStatus(hCamera:Long, plReleaseStatus: SDKLong):Long

    /**
     * Gets the current video recording status.
     *
     * @param hCamera Camera handle.
     * @param plStatus The video recording status.
     * @return API result.
     */
    external fun XSDK_GetRecordingStatus(hCamera:Long, plStatus: SDKLong):Long

    /**
     * Gets information from an image from the top of the in-camera buffer.
     *
     * @param hCamera Camera handle.
     * @param pImgInfoArray Returns the image information.
     * @return API result.
     */
    external fun XSDK_ReadImageInfo(hCamera:Long, pImgInfoArray: XSDK_ImageInformation):Long

    /**
     * Gets a low-resolution image of the image from the top of the in-camera buffer.
     *
     * @param hCamera Camera handle.
     * @param pData The read-image buffer.
     * @param dataSize The number of bytes allocated for pData.
     * @return API result.
     */
    external fun XSDK_ReadPreview(hCamera:Long, pData:ByteArray, dataSize:Long):Long

    /**
     * Gets a captured image from the top of the in-camera buffer and deletes it from the buffer.
     *
     * @param hCamera Camera handle.
     * @param pData The read-image buffer.
     * @param dataSize The number of bytes allocated for pData.
     * @return API result.
     */
    external fun XSDK_ReadImage(hCamera:Long, pData:ByteArray, dataSize:Long):Long

    /**
     * Deletes a captured image from the top of the in-camera buffer.
     *
     * @param hCamera Camera handle.
     * @return API result.
     */
    external fun XSDK_DeleteImage(hCamera:Long):Long

    /**
     * Gets the status of the in-camera buffer.
     *
     * @param hCamera Camera handle.
     * @param pShootFrameNum Returns the number of frames shot (the number of captured images).
     * @param plTotalFrameNum Returns the total number of frames.
     * @return API result.
     */
    external fun XSDK_GetBufferCapacity(hCamera:Long, pShootFrameNum: SDKLong, plTotalFrameNum: SDKLong):Long

    /**
     * Queries supported exposure modes (P/A/S/M) to set.
     *
     * @param hCamera Camera handle.
     * @param plNumAEMode Returns the number of supported XSDK_SetAEMode settings.
     * @param plAEMode If not NULL, plAEMode will return a list of the XSDK_SetAEMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapAEMode(hCamera:Long, plNumAEMode: SDKLong, plAEMode:LongArray?):Long

    /**
     * Sets the exposure mode setting.
     *
     * @param hCamera Camera handle.
     * @param lAEMode The exposure mode to which the camera will be set.
     * @return API result.
     */
    external fun XSDK_SetAEMode(hCamera:Long, lAEMode:Long):Long

    /**
     * Sets the exposure mode setting.
     *
     * @param hCamera Camera handle.
     * @param plAEMode Returns the exposure mode.
     * @return API result.
     */
    external fun XSDK_GetAEMode(hCamera:Long, plAEMode: SDKLong):Long

    /**
     * Queries supported shutter speeds to set.
     *
     * @param hCamera Camera handle.
     * @param plNumShutterSpeed Returns the number of supported XSDK_SetShutterSpeed settings.
     * @param plShutterSpeed If not NULL, plShutterSpeed will return a list of the XSDK_SetShutterSpeed settings supported.
     * @param plBulbCapable BULB Capable.
     * @return API result.
     */
    external fun XSDK_CapShutterSpeed(hCamera:Long, plNumShutterSpeed: SDKLong, plShutterSpeed:LongArray?, plBulbCapable:SDKLong):Long

    /**
     * Sets the shutter speed value.
     *
     * @param hCamera Camera handle.
     * @param lShutterSpeed The shutter speed to which the camera will be set.
     * @param lBulb BULB Capable.
     * @return API result.
     */
    external fun XSDK_SetShutterSpeed(hCamera:Long, lShutterSpeed:Long, lBulb:Long):Long

    /**
     * Gets the shutter speed setting.
     *
     * @param hCamera Camera handle.
     * @param plShutterSpeed Returns the shutter speed.
     * @param plBulb Returns  the shutter speed setting is BULB or not.
     * @return API result.
     */
    external fun XSDK_GetShutterSpeed(hCamera:Long, plShutterSpeed: SDKLong, plBulb: SDKLong):Long

    /**
     * Queries supported exposure compensations to set.
     *
     * @param hCamera Camera handle.
     * @param plNumExposureBias Returns the number of supported XSDK_SetExposureBias settings.
     * @param plExposureBias If not NULL, plExposureBias will return a list of the XSDK_SetExposureBias settings supported.
     * @return API result.
     */
    external fun XSDK_CapExposureBias(hCamera:Long, plNumExposureBias: SDKLong, plExposureBias:LongArray?):Long

    /**
     * Sets the exposure compensation value.
     *
     * @param hCamera Camera handle.
     * @param lExposureBias The value to which exposure compensation will be set.
     * @return API result.
     */
    external fun XSDK_SetExposureBias(hCamera:Long, lExposureBias:Long):Long

    /**
     * Gets the exposure compensation setting.
     *
     * @param hCamera Camera handle.
     * @param plExposureBias Returns the current exposure compensation value.
     * @return API result.
     */
    external fun XSDK_GetExposureBias(hCamera:Long, plExposureBias: SDKLong):Long

    /**
     * Queries supported dynamic ranges to set.
     *
     * @param hCamera Camera handle.
     * @param plNumDynamicRange Returns the number of supported XSDK_SetDynamicRange settings.
     * @param plDynamicRange If not NULL, plDynamicRange will return a list of the XSDK_SetDynamicRange settings supported.
     * @return API result.
     */
    external fun XSDK_CapDynamicRange(hCamera:Long, plNumDynamicRange: SDKLong, plDynamicRange:LongArray?):Long

    /**
     * Sets the dynamic range value.
     *
     * @param hCamera Camera handle.
     * @param lDynamicRange The value to which dynamic range will be set.
     * @return API result.
     */
    external fun XSDK_SetDynamicRange(hCamera:Long, lDynamicRange:Long):Long

    /**
     * Gets the dynamic range setting.
     *
     * @param hCamera Camera handle.
     * @param plDynamicRange Returns the dynamic range.
     * @return API result.
     */
    external fun XSDK_GetDynamicRange(hCamera:Long, plDynamicRange: SDKLong):Long

    /**
     * Queries supported ISO sensitivities to set.
     *
     * @param hCamera Camera handle.
     * @param plNumSensitivity Returns the number of supported settings for XSDK_SetSensitivity.
     * @param plSensitivity If not NULL, plSensitivity will return a list of the XSDK_SetSensitivity settings supported.
     * @return API result.
     */
    external fun XSDK_CapSensitivity(hCamera:Long, plNumSensitivity: SDKLong, plSensitivity:LongArray?):Long

    /**
     * Sets the ISO sensitivity value.
     *
     * @param hCamera Camera handle.
     * @param lSensitivity The value to which sensitivity will be set.
     * @return API result.
     */
    external fun XSDK_SetSensitivity(hCamera:Long, lSensitivity:Long):Long

    /**
     * Gets the ISO sensitivity setting.
     *
     * @param hCamera Camera handle.
     * @param plSensitivity Returns the current value for ISO sensitivity.
     * @return API result.
     */
    external fun XSDK_GetSensitivity(hCamera:Long, plSensitivity: SDKLong):Long

    /**
     * Queries supported metering modes to set.
     *
     * @param hCamera Camera handle.
     * @param plNumMeteringMode Returns the number of supported XSDK_SetMeteringMode settings.
     * @param plMeteringMode If not NULL, plMeteringMode will return a list of the XSDK_SetMeteringMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapMeteringMode(hCamera:Long, plNumMeteringMode: SDKLong, plMeteringMode:LongArray?):Long

    /**
     * Sets the metering mode.
     *
     * @param hCamera Camera handle.
     * @param lMeteringMode The metering mode
     * @return API result.
     */
    external fun XSDK_SetMeteringMode(hCamera:Long, lMeteringMode:Long):Long

    /**
     * Gets the metering mode setting.
     *
     * @param hCamera Camera handle.
     * @param plMeteringMode The metering mode
     * @return API result.
     */
    external fun XSDK_GetMeteringMode(hCamera:Long, plMeteringMode: SDKLong):Long

    /**
     * Queries supported zoom positions to set.
     *
     * @param hCamera Camera handle.
     * @param plNumZoomPos Returns the number of supported zoom positions.
     * @param plZoomPos If not NULL, plZoomPos returns a list of the zoom positions supported.
     * @param plFocusLength If not NULL, plFocalLength returns a list of the focal length positions supported. The values are 100 times the actual focal lengths.
     * @param pl35mmFocusLength If not NULL, pl35mmFocalLength returns a list of the 35 mm-equivalent focal length positions supported. The values are 100 times the actual focal lengths.
     * @return API result.
     */
    external fun XSDK_CapLensZoomPos(hCamera:Long, plNumZoomPos: SDKLong, plZoomPos:LongArray?, plFocusLength:LongArray?, pl35mmFocusLength:LongArray?):Long

    /**
     * Sets the zoom position.
     *
     * @param hCamera Camera handle.
     * @param lZoomPos The zoom position, in steps.
     * @return API result.
     */
    external fun XSDK_SetLensZoomPos(hCamera:Long, lZoomPos:Long):Long

    /**
     * Gets the zoom position setting.
     *
     * @param hCamera Camera handle.
     * @param plZoomPos The zoom position, in steps.
     * @return API result.
     */
    external fun XSDK_GetLensZoomPos(hCamera:Long, plZoomPos: SDKLong):Long

    /**
     * Queries supported aperture values to set.
     *
     * @param hCamera Camera handle.
     * @param lZoomPos The zoom position retrieved using “XSDK_CapLensZoomPos”.
     * @param plNumAperture Returns the number of XSDK_SetAperture settings available at zoom position lZoomPos.
     * @param plFNumber If not NULL, plFNumber returns a list of the XSDK_SetAperture settings available at zoom position lZoomPos.
     * @return API result.
     */
    external fun XSDK_CapAperture(hCamera:Long, lZoomPos:Long, plNumAperture: SDKLong, plFNumber:LongArray?):Long

    /**
     * Sets the aperture value.
     *
     * @param hCamera Camera handle.
     * @param lFNumber The aperture value, expressed as the F number multiplied by 100.
     * @return API result.
     */
    external fun XSDK_SetAperture(hCamera:Long, lFNumber:Long):Long

    /**
     * Gets the aperture setting.
     *
     * @param hCamera Camera handle.
     * @param plFNumber Receive the aperture in F number.
     *                  The value is hundredfold value of the actual aperture F number.
     * @return API result.
     */
    external fun XSDK_GetAperture(hCamera:Long, plFNumber: SDKLong):Long

    /**
     * Queries supported white-balance modes to set.
     *
     * @param hCamera Camera handle.
     * @param plNumWBMode Returns the number of supported XSDK_SetWBMode settings.
     * @param plWBMode If not NULL, plWBMode returns a list of the XSDK_SetWBMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapWBMode(hCamera:Long, plNumWBMode: SDKLong, plWBMode:LongArray?):Long

    /**
     * Sets the white-balance mode.
     *
     * @param hCamera Camera handle.
     * @param lWBMode The white-balance mode.
     * @return API result.
     */
    external fun XSDK_SetWBMode(hCamera:Long, lWBMode:Long):Long

    /**
     * Gets the white-balance mode setting.
     *
     * @param hCamera Camera handle.
     * @param plWBMode The current white-balance mode.
     * @return API result.
     */
    external fun XSDK_GetWBMode(hCamera:Long, plWBMode: SDKLong):Long

    /**
     * Queries supported color temperatures to set available when WBMode=ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param plNumWBColorTemp Returns the number of supported XSDK_SetWBColorTemp settings.
     * @param plWBColorTemp If not NULL, plWBColorTemp returns a list of the XSDK_SetWBColorTemp settings supported.
     * @return API result.
     */
    external fun XSDK_CapWBColorTemp(hCamera:Long, plNumWBColorTemp: SDKLong, plWBColorTemp:LongArray?):Long

    /**
     * Sets the color temperature value for WBMode=ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param lColorTemp The color temperature, in degrees Kelvin.
     * @return API result.
     */
    external fun XSDK_SetWBColorTemp(hCamera:Long, lColorTemp:Long):Long

    /**
     * Gets the color temperature setting for WBMode=ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param plColorTemp Returns the current color temperature, in degrees Kelvin.
     * @return API result.
     */
    external fun XSDK_GetWBColorTemp(hCamera:Long, plColorTemp: SDKLong):Long

    /**
     * Queries supported shutter speeds to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumShutterSpeed Returns the number of supported XSDK_SetMovieShutterSpeed settings.
     * @param pllShutterSpeed If not NULL, pllShutterSpeed will return a list of the XSDK_SetMovieShutterSpeed settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieShutterSpeed(hCamera:Long, plNumShutterSpeed: SDKLong, pllShutterSpeed:LongArray?):Long

    /**
     * Sets the shutter speed value in movie mode.
     *
     * @param hCamera Camera handle.
     * @param llShutterSpeed The value to which shutter speed will be set.
     * @return API result.
     */
    external fun XSDK_SetMovieShutterSpeed(hCamera:Long, llShutterSpeed:Long):Long

    /**
     * Gets the shutter speed setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param pllShutterSpeed Returns the current value for shutter speed.
     * @return API result.
     */
    external fun XSDK_GetMovieShutterSpeed(hCamera:Long, pllShutterSpeed: SDKLong):Long

    /**
     * Returns the current value for shutter speed.
     *
     * @param hCamera Camera handle.
     * @param plNumExposureBias Returns the number of supported XSDK_SetMovieExposureBias settings.
     * @param plExposureBias If not NULL, plExposureBias will return a list of the XSDK_SetMovieExposureBias settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieExposureBias(hCamera:Long, plNumExposureBias: SDKLong, plExposureBias:LongArray?):Long

    /**
     * Sets the exposure compensation value in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lExposureBias The value to which exposure compensation will be set.
     * @return API result.
     */
    external fun XSDK_SetMovieExposureBias(hCamera:Long, lExposureBias:Long):Long

    /**
     * Gets the exposure compensation setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plExposureBias Returns the current exposure compensation value.
     * @return API result.
     */
    external fun XSDK_GetMovieExposureBias(hCamera:Long, plExposureBias: SDKLong):Long

    /**
     * Queries supported ISO sensitivities to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumSensitivity Returns the number of supported XSDK_SetMovieSensitivity settings.Returns the number of supported XSDK_SetMovieSensitivity settings.
     * @param plSensitivity If not NULL, plSensitivity will return a list of the XSDK_SetMovieSensitivity settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieSensitivity(hCamera:Long, plNumSensitivity: SDKLong, plSensitivity:LongArray?):Long

    /**
     * Sets the ISO sensitivity value in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lSensitivity The value to which ISO sensitivity will be set.
     * @return API result.
     */
    external fun XSDK_SetMovieSensitivity(hCamera:Long, lSensitivity:Long):Long

    /**
     * Gets the ISO sensitivity setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plSensitivity Returns the current value for ISO sensitivity.
     * @return API result.
     */
    external fun XSDK_GetMovieSensitivity(hCamera:Long, plSensitivity: SDKLong):Long

    /**
     * Queries supported aperture values to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumAperture Returns the number of supported XSDK_SetMovieAperture settings.
     * @param plFNumber If not NULL, plAperture will return a list of the XSDK_SetMovieAperture settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieAperture(hCamera:Long, plNumAperture: SDKLong, plFNumber:LongArray?):Long

    /**
     * Sets the aperture value in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lFNumber The value to which aperture will be set.
     *                  The aperture values returned are 100 times the actual F numbers.
     * @return API result.
     */
    external fun XSDK_SetMovieAperture(hCamera:Long, lFNumber:Long):Long

    /**
     * Gets the aperture setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plFNumber Returns the current value for aperture.
     * @return API result.
     */
    external fun XSDK_GetMovieAperture(hCamera:Long, plFNumber: SDKLong):Long

    /**
     * Queries supported dynamic ranges to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumDynamicRange Returns the number of supported XSDK_SetMovieDynamicRange settings.
     * @param plDynamicRange If not NULL, plDynamicRange returns a list of the XSDK_SetWBMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieDynamicRange(hCamera:Long, plNumDynamicRange: SDKLong, plDynamicRange:LongArray?):Long

    /**
     * Sets the dynamic range value in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lDynamicRange The value to which dynamic range will be set.
     * @return API result.
     */
    external fun XSDK_SetMovieDynamicRange(hCamera:Long, lDynamicRange:Long):Long

    /**
     * Gets the dynamic range setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plDynamicRange Returns the current value for dynamic range.
     * @return API result.
     */
    external fun XSDK_GetMovieDynamicRange(hCamera:Long, plDynamicRange: SDKLong):Long

    /**
     * Queries supported metering modes to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumMeteringMode Returns the number of supported XSDK_SetMovieMeteringMode settings.
     * @param plMeteringMode If not NULL, plMeteringMode returns a list of the XSDK_SetWBMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieMeteringMode(hCamera:Long, plNumMeteringMode: SDKLong, plMeteringMode:LongArray?):Long

    /**
     * Sets the metering mode in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lMeteringMode The value to which metering mode will be set.
     * @return API result.
     */
    external fun XSDK_SetMovieMeteringMode(hCamera:Long, lMeteringMode:Long):Long

    /**
     * Gets the metering mode setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plMeteringMode Returns the current value for metering mode.
     * @return API result.
     */
    external fun XSDK_GetMovieMeteringMode(hCamera:Long, plMeteringMode: SDKLong):Long

    /**
     * Queries supported white-balance modes to set in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plNumWBMode Returns the number of supported XSDK_SetMovieWBMode settings.
     * @param plWBMode If not NULL, plWBMode returns a list of the XSDK_SetMovieWBMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieWBMode(hCamera:Long, plNumWBMode: SDKLong, plWBMode:LongArray?):Long

    /**
     * Sets the white-balance mode in movie mode.
     *
     * @param hCamera Camera handle.
     * @param lWBMode The white-balance mode.
     * @return API result.
     */
    external fun XSDK_SetMovieWBMode(hCamera:Long, lWBMode:Long):Long

    /**
     * Gets the white-balance mode setting in movie mode.
     *
     * @param hCamera Camera handle.
     * @param plWBMode The current white-balance mode.
     * @return API result.
     */
    external fun XSDK_GetMovieWBMode(hCamera:Long, plWBMode: SDKLong):Long

    /**
     * Queries supported color temperatures to set available in movie mode when WBMode = ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param plNumWBColorTemp Returns the number of supported XSDK_SetMovieWBColorTemp settings.
     * @param plWBColorTemp If not NULL, plWBColorTemp returns a list of the XSDK_SetMovieWBColorTemp settings supported.
     * @return API result.
     */
    external fun XSDK_CapMovieWBColorTemp(hCamera:Long, plNumWBColorTemp: SDKLong, plWBColorTemp:LongArray?):Long

    /**
     * Sets the color temperature value in movie mode for WBMode = ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param lColorTemp The COLOR TEMPERATURE, in degrees Kelvin
     * @return API result.
     */
    external fun XSDK_SetMovieWBColorTemp(hCamera:Long, lColorTemp:Long):Long

    /**
     * Gets the movie color temperature setting in movie mode for WBMode = ColorTemperature.
     *
     * @param hCamera Camera handle.
     * @param plColorTemp Returns the current COLOR TEMPERATURE, in degrees Kelvin.
     * @return API result.
     */
    external fun XSDK_GetMovieWBColorTemp(hCamera:Long, plColorTemp: SDKLong):Long

    /**
     * Queries supported media recording control modes to set.
     *
     * @param hCamera Camera handle.
     * @param plNumMediaRecord Returns the number of supported XSDK_SetMediaRecord settings.
     * @param plMediaRecord If not NULL, plMediaRecord returns a list of the XSDK_SetMediaRecord settings supported.
     * @return API result.
     */
    external fun XSDK_CapMediaRecord(hCamera:Long, plNumMediaRecord: SDKLong, plMediaRecord:LongArray?):Long

    /**
     * Sets the media recording control modes for the tethering operation.
     *
     * @param hCamera Camera handle.
     * @param lMediaRecord The media recording control mode.
     * @return API result.
     */
    external fun XSDK_SetMediaRecord(hCamera:Long, lMediaRecord:Long):Long

    /**
     * Gets the media recording control modes setting for the tethering operation.
     *
     * @param hCamera Camera handle.
     * @param plMediaRecord The current media recording control mode.
     * @return API result.
     */
    external fun XSDK_GetMediaRecord(hCamera:Long, plMediaRecord: SDKLong):Long

    /**
     * Queries supported operation modes to set.
     *
     * @param hCamera Camera handle.
     * @param plNumStandbyMode Returns the number of supported XSDK_SetForceMode settings.
     * @param plForceShootStandby If not NULL, plForceMode returns a list of the XSDK_SetForceMode settings supported.
     * @return API result.
     */
    external fun XSDK_CapForceMode(hCamera:Long, plNumStandbyMode: SDKLong, plForceShootStandby:LongArray?):Long

    /**
     * Forcibly changes the operating mode to SHOOTING MODE.
     *
     * @param hCamera Camera handle.
     * @param plMode The operating mode to SHOOTING MODE.
     * @return API result.
     */
    external fun XSDK_SetForceMode(hCamera:Long, plMode:Long):Long

    /**
     * Queries supported drive modes.
     *
     * @param hCamera Camera handle.
     * @param plNum Returns the number of XSDK_SetDriveMode settings supported.
     * @param plDriveMode If plDriveMode is NULL, the function will return only plNumDriveMode with the number of supported XSDK_SetDriveMode settings.
     * @return API result.
     */
    external fun XSDK_CapDriveMode(hCamera:Long, plNum: SDKLong, plDriveMode:LongArray?):Long

    /**
     * Sets the camera drive mode.
     *
     * @param hCamera Camera handle.
     * @param lDriveMode The drive mode.
     * @return API result.
     */
    external fun XSDK_SetDriveMode(hCamera:Long, lDriveMode:Long):Long

    /**
     * Gets the current camera drive mode.
     *
     * @param hCamera Camera handle.
     * @param plDriveMode Drive Mode
     * @return API result.
     */
    external fun XSDK_GetDriveMode(hCamera:Long, plDriveMode: SDKLong):Long

    /**
     * Queries supported camera MODES.
     *
     * @param hCamera Camera handle.
     * @param plNum Returns the number of XSDK_SetMode settings supported.
     * @param plMode If plMode is NULL, the function will return only plNumMode with the number of supported XSDK_SetMode settings.
     * @return API result.
     */
    external fun XSDK_CapMode(hCamera:Long, plNum: SDKLong, plMode:LongArray?):Long

    /**
     * Sets the camera MODE.
     *
     * @param hCamera Camera handle.
     * @param lMode The mode.
     * @return API result.
     */
    external fun XSDK_SetMode(hCamera:Long, lMode:Long):Long

    /**
     * Gets the current camera MODE.
     *
     * @param hCamera Camera handle.
     * @param plMode The mode.
     * @return API result.
     */
    external fun XSDK_GetMode(hCamera:Long, plMode: SDKLong):Long

    /**
     * Restore camera backup settings.
     *
     * @param hCamera Camera handle.
     * @param lSize The size of the backup data.
     * @param pBackup The backup data.
     * @return API result.
     */
    external fun XSDK_SetBackupSettings(hCamera:Long, lSize:Long, pBackup: ByteArray):Long

    /**
     * Backup camera settings.
     *
     * @param hCamera Camera handle.
     * @param plSize The size of the backup data.
     * @param pBackup Camera setting data.
     * @return API result.
     */
    external fun XSDK_GetBackupSettings(hCamera:Long, plSize: SDKLong, pBackup: ByteArray):Long

    external fun XSDK_SetProp(hCamera:Long, lAPICode:Long, lAPIParam:Long):Long
    external fun XSDK_SetProp_L(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long):Long
    external fun XSDK_SetProp_LL(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long):Long
    external fun XSDK_SetProp_LLL(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long, param3:Long):Long
    external fun XSDK_SetProp_LLLLL(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long, param3:Long, param4:Long, param5:Long):Long
    external fun XSDK_SetProp_LLLLLL(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long, param3:Long, param4:Long, param5:Long, param6:Long):Long
    external fun XSDK_SetProp_P(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any):Long
    external fun XSDK_SetProp_LP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any):Long
    external fun XSDK_SetProp_LS(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:String):Long
    external fun XSDK_SetProp_LSL(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:String, param3:Long):Long
    external fun XSDK_SetProp_S(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:String):Long
    external fun XSDK_SetProp_SS(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:String, param2:String):Long
    external fun XSDK_GetProp_P(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any):Long
    external fun XSDK_GetProp_LP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any):Long
    external fun XSDK_GetProp_LLP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long, param3:Any):Long
    external fun XSDK_GetProp_LLLPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Long, param3:Long, param4:Any, param5:Any):Long
    external fun XSDK_GetProp_LPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any, param3: Any?):Long
    external fun XSDK_GetProp_LPPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any, param3:Any, param4:Any, param5:Any):Long
    external fun XSDK_GetProp_PP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2: Any?):Long
    external fun XSDK_GetProp_PPLP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Long, param4: Any?):Long
    external fun XSDK_GetProp_PPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Any):Long
    external fun XSDK_GetProp_PPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Any, param4:Any):Long
    external fun XSDK_GetProp_PPPPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Any, param4:Any, param5:Any, param6:Any):Long
    external fun XSDK_GetProp_PPPPPPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Any, param4:Any, param5:Any, param6:Any, param7:Any, param8:Any):Long
    external fun XSDK_CapProp_PP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2: Any?):Long
    external fun XSDK_CapProp_LPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any, param3: Any?):Long
    external fun XSDK_CapProp_LPPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Long, param2:Any, param3:Any, param4:Any, param5:Any):Long
    external fun XSDK_CapProp_PPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2: Any?, param3: Any?, param4: Any?):Long
    external fun XSDK_CapProp_PPPPPP(hCamera:Long, lAPICode:Long, lAPIParam:Long, param1:Any, param2:Any, param3:Any, param4: Any?, param5: Any?, param6: Any?):Long
}