package com.fujifilm.liveview

import android.content.Context
import androidx.appcompat.app.AlertDialog

class ErrorDialog(private val context: Context) {
    fun showErrorDialog(message: String, retryAction: () -> Unit){
        val builder = AlertDialog.Builder(context)
        builder.setTitle("Error")
            .setMessage(message)
            .setPositiveButton("OK") { dialog, _ ->
                retryAction()
                dialog.dismiss()
            }
        val dialog = builder.create()
        dialog.setCancelable(false)
        dialog.setCanceledOnTouchOutside(false)
        dialog.show()
    }
}