#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
PID_FILE="${SCRIPT_DIR}/app.pid"
echo "$PID_FILE"
if [ ! -f "$PID_FILE" ]; then
  echo "No PID file found. Application is not runnning."
  exit 1
fi

APP_PID=$(cat "$PID_FILE")

if ps -p $APP_PID  >/dev/null; then
  echo "Stopping application with PID $APP_PID..."
  kill -SIGTERM $APP_PID
  rm -f "$PID_FILE"
  echo "Application stopped."
else
  echo "No Application runnningWith PID $APP_PID."
  rm -f "$PID_FILE"
fi

exit 0
