#!/bin/bash

killall HotFolder

# Set SCRIPT_DIR to the directory of this script
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

# Change to the SDK directory inside SCRIPT_DIR
SDK_DIR="${SCRIPT_DIR}/SDK"

# Check if the SDK directory exists
if [ ! -d "$SDK_DIR" ]; then
  echo "SDK directory not found: $SDK_DIR"
  exit 1
fi

cd "$SDK_DIR" || exit 1

# Set LD_LIBRARY_PATH for dl_open()
if [ -z "$LD_LIBRARY_PATH" ]; then
  export LD_LIBRARY_PATH="$SDK_DIR"
else
  export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$SDK_DIR"
fi

echo "LD_LIBRARY_PATH: $LD_LIBRARY_PATH"

if [ -z "$1" ]; then
  echo "Usage: $0 <file_path>"
  exit 1
fi

FILE_PATH=$1

PID_FILE="${SCRIPT_DIR}/app.pid"

echo "Starting the application with file path: $FILE_PATH..."
cd "$SCRIPT_DIR" || exit 1
./HotFolder  "$FILE_PATH" &

APP_PID=$!

echo $APP_PID > "$PID_FILE"

echo "Application started with PID $APP_PID"
exit 0
