#include <iostream>
#include <fstream>
#include <unistd.h>
#include <cstring>
#include <cstdlib>
#include <signal.h>
#include "CameraControl.h"
#include <fcntl.h>
#include "SDK/XAPI.H"
#include "HotFolder.h"
#include <string>
#include <cstdint>
#include <sys/stat.h>
#include <chrono>
#include <ctime>
#include <sstream>
#include <iomanip> 

bool isStop = false;
void CheckFolder(std::string savePath, BOOL* pboErr)
{
BOOL boErr = FALSE;

std::string sPath = savePath;

if(sPath.back() != '/')
{
	sPath += '/';
}

sPath += "___test.___";

int fd = open(sPath.c_str(), O_WRONLY | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
if(fd == -1)
{
	// Error Opening file.
	boErr = TRUE;
	std::cerr << "Error Opening file: " << strerror(errno) << std::endl;
}
else
{
	ssize_t bytesWritten;
	unsigned int dwData = 0;
	
	bytesWritten = write(fd, &dwData, sizeof(dwData));
	if(bytesWritten == -1)
	{
		// Error writing to file.
		boErr = TRUE;
		std::cerr << "Error writing to file: " << strerror(errno) << std::endl;
	}
	else if(bytesWritten != sizeof(dwData))
	{
		boErr = TRUE;
	}
	
	if(fsync(fd) == -1)
	{
		boErr = TRUE;
		std::cerr << "Error flushing file: " << strerror(errno) << std::endl;
	}
	
	close(fd);
	
	if(unlink(sPath.c_str()) == -1)
	{
		boErr = TRUE;
		std::cerr << "Error deleting file: " << strerror(errno) << std::endl;
	}
}
	
*pboErr = boErr;
}

void StopLoop(int signum)
{
    isStop = true;
}

int main(int argc, char* argv[]) {
	XSDK_HANDLE hCamera= 0;
	CCameraControl* cameraControl = new CCameraControl();
	int state = STATE_DISCONNECT;
	
	std::string savePath = argv[1];
	
	signal(SIGTERM, StopLoop);
	
	bool isLoad = cameraControl->LoadLibraty();
	if(!isLoad)
	{
		std::cerr << "Failed to load XSDK.so" << std::endl;
		delete cameraControl;
		cameraControl = NULL;
		return 0;
	}
	
	BOOL boFolderAccessError;
	CheckFolder(savePath, &boFolderAccessError);
	if(boFolderAccessError)
	{
		std::cerr << "Invalid path" << std::endl;
		delete cameraControl;
		cameraControl = NULL;
		return 0;
	}
	
	while (!isStop) 
	{
		BOOL boBreak;
		int count;
		switch(state)
		{
			case STATE_DISCONNECT:
				boBreak = FALSE;
				hCamera = NULL;
			    count = 0;
				while(!isStop)
				{
					if(XSDK_COMPLETE == cameraControl->Init()) // Initialize SDK.
					{
						long lNumCameras = 0;
						long lInterface = XSDK_DSC_IF_USB;
						sleep(1);
						// CameraSearch
						if(XSDK_COMPLETE == cameraControl->Detect(lInterface, NULL, NULL, &lNumCameras)) 
						{
							if(lNumCameras > 0)
							{
								long lCameraMode = 0;
								char* enumCamera = "ENUM:0";
								// Establish a session between the camera.
								if(XSDK_COMPLETE == cameraControl->Open(enumCamera, &hCamera, &lCameraMode, NULL))
								{
									// Open Success
									if(lCameraMode&XSDK_DSC_MODE_TETHER)
									{
										long lmode = XSDK_PRIORITY_CAMERA;
										if(XSDK_COMPLETE == cameraControl->SetPriorityMode(hCamera, lmode))
										{
											boBreak = TRUE;
										}
										else
										{
											std::cerr << "SetPriorityMode Error" << std::endl;
											cameraControl->Close(hCamera);
											usleep(600000);				
											hCamera = NULL;
											cameraControl->Exit();
										}
									}
									else
									{
										// Tether shooting is not supported
										std::cerr << "Tether shooting is not supported." << std::endl;
										cameraControl->Close(hCamera);
										usleep(600000);					
										hCamera = NULL;
										cameraControl->Exit();
									}
								}
								else
								{
									// Open Error
									std::cerr << "Open Error" << std::endl;
									hCamera = NULL;
									cameraControl->Exit();
								}
							}
							else
							{
								// No camera detected Error
								count += 1;
								if(count == 5)
								{
									std::cerr << "Waiting for a camera to be connected..." << std::endl;
									count = 0;
								}
								
								cameraControl->Exit();
							}
						}
						else
						{
							// Detect Error
							std::cerr << "Detect Error" << std::endl;
							cameraControl->Exit();
						}
					}
					else
					{
						// Init Error
						std::cerr << "Init Error" << std::endl;
						cameraControl->Exit();
						delete cameraControl;
						cameraControl = NULL;
						return 0;
					}
					if(boBreak) break;
					
				}
				state = STATE_CONNECT;
				break;
			case STATE_CONNECT:
				XSDK_ImageInformation imgInfo;
				unsigned char* pBuf;
				while(!isStop)
				{
					imgInfo.lFormat = XSDK_IMAGEFORMAT_NONE;
					
					// Get Information about the image at the top of the camera's internal buffer.
					if(XSDK_COMPLETE == cameraControl->ReadImageInfo(hCamera, &imgInfo))
					{	
						try
						   {
							   pBuf = new unsigned char [imgInfo.lDataSize];
						   }
						   catch(...)
						   {
							   pBuf = NULL;
						   }
								   
						   if(pBuf !=NULL)
						   {
							   // Get the image at the top of yhe camera's internal buffer and the delete it.
							   if(XSDK_COMPLETE == cameraControl->ReadImage(hCamera, pBuf, imgInfo.lDataSize))
							   {
								   std::string sSaveFolder = savePath;
								   std::string sSeq;
								   int hSeq;
								   
								   if(sSaveFolder.back() != '/')
									{
										sSaveFolder += '/';
									}
									
									auto now = std::chrono::system_clock::now();
									std::time_t now_c = std::chrono::system_clock::to_time_t(now);
									auto duration = now.time_since_epoch();
									auto milliseconds = std::chrono::duration_cast<std::chrono::milliseconds>(duration).count() % 1000;
									std::tm* local_time = std::localtime(&now_c);
									std::ostringstream oss;
									oss << std::put_time(local_time, "%Y%m%d_%H%M%S") << "_" << std::setw(3) << std::setfill('0') << milliseconds;
									std::string timeString = oss.str();
									
									std::string sSaveToPath;

									switch((imgInfo.lFormat & 0x00FF))
									{
										case XSDK_IMAGEFORMAT_RAW:
											sSaveToPath = sSaveFolder + timeString + ".RAF";									
											break;
										case XSDK_IMAGEFORMAT_JPEG:
											sSaveToPath = sSaveFolder + timeString + ".JPG";
											break;
										case XSDK_IMAGEFORMAT_HEIF:
											sSaveToPath = sSaveFolder + timeString + ".HEIC";											
											break;
										default :
										    delete [] pBuf;
								            pBuf = NULL;
											continue;
									}
									
									int iImg;
									iImg = open(sSaveToPath.c_str(), O_RDWR | O_CREAT, S_IRUSR | S_IWUSR);
									if(iImg == -1)
									{
										std::cerr <<"File open error: " << sSaveToPath << std::endl;
									}
									else
									{
										ssize_t dwSeqWritten = write(iImg, pBuf, imgInfo.lDataSize);
										if(dwSeqWritten == -1)
										{
											std::cerr <<"Write error to: " << sSaveToPath << std::endl;
										}
										else if(dwSeqWritten != imgInfo.lDataSize)
										{
											std::cerr <<"Write size mismath " << std::endl;
										}
										
										close(iImg);
									}
									
								}
								delete [] pBuf;
								pBuf = NULL;
						   }
						   else
						   {
							   std::cerr << "Memory Error" << std::endl;
						   }
						
					}
					
					// Check the camera alivie?
					BOOL boAlive = TRUE;
					XSDK_DeviceInformation devInfo;
					// Get Device Information.
					if(XSDK_COMPLETE != cameraControl->GetDeviceInfo(hCamera, &devInfo))
					{
						if(XSDK_ERRCODE_BUSY == cameraControl->m_errCode || XSDK_ERRCODE_NODRIVER == cameraControl->m_errCode || cameraControl->m_errCode == XSDK_ERRCODE_RUNNING_OTHER_FUNCTION)
						{
							// busy
						}
						else
						{
							// err
							boAlive = FALSE;
							std::cerr << "Connection lost." << std::endl;
						}
					}
	
					if(boAlive == FALSE) break;
				}
			  state = STATE_DISCONNECT;
			  break;	
		}
			
	}
	
	if(hCamera != NULL)
	{
		usleep(600000);
		cameraControl->Close(hCamera);
		hCamera = NULL;
	}
	
	usleep(600000);
	cameraControl->Exit();
	
	delete cameraControl;
	cameraControl = NULL;
	
	exit(0);
	return 0;
}
