#include <stdint.h>
#include <pthread.h>
#include <cstdio>
#include "FujiSDK.h"

inline std::string sensitivityToString(long num)
{
	switch (num)
	{
		case XSDK_SENSITIVITY_ISO40:     return "ISO40";
		case XSDK_SENSITIVITY_ISO50:     return "ISO50";
		case XSDK_SENSITIVITY_ISO60:     return "ISO60";
		case XSDK_SENSITIVITY_ISO64:     return "ISO64";
		case XSDK_SENSITIVITY_ISO80:     return "ISO80";
		case XSDK_SENSITIVITY_ISO100:    return "ISO100";
		case XSDK_SENSITIVITY_ISO125:    return "ISO125";
		case XSDK_SENSITIVITY_ISO160:    return "ISO160";
		case XSDK_SENSITIVITY_ISO200:    return "ISO200";
		case XSDK_SENSITIVITY_ISO250:    return "ISO250";
		case XSDK_SENSITIVITY_ISO320:    return "ISO320";
		case XSDK_SENSITIVITY_ISO400:    return "ISO400";
		case XSDK_SENSITIVITY_ISO500:    return "ISO500";
		case XSDK_SENSITIVITY_ISO640:    return "ISO640";
		case XSDK_SENSITIVITY_ISO800:    return "ISO800";
		case XSDK_SENSITIVITY_ISO1000:   return "ISO1000";
		case XSDK_SENSITIVITY_ISO1250:   return "ISO1250";
		case XSDK_SENSITIVITY_ISO1600:   return "ISO1600";
		case XSDK_SENSITIVITY_ISO2000:   return "ISO2000";
		case XSDK_SENSITIVITY_ISO2500:   return "ISO2500";
		case XSDK_SENSITIVITY_ISO3200:   return "ISO3200";
		case XSDK_SENSITIVITY_ISO4000:   return "ISO4000";
		case XSDK_SENSITIVITY_ISO5000:   return "ISO5000";
		case XSDK_SENSITIVITY_ISO6400:   return "ISO6400";
		case XSDK_SENSITIVITY_ISO8000:   return "ISO8000";
		case XSDK_SENSITIVITY_ISO10000:  return "ISO10000";
		case XSDK_SENSITIVITY_ISO12800:  return "ISO12800";
		case XSDK_SENSITIVITY_ISO16000:  return "ISO16000";
		case XSDK_SENSITIVITY_ISO20000:  return "ISO20000";
		case XSDK_SENSITIVITY_ISO25600:  return "ISO25600";
		case XSDK_SENSITIVITY_ISO32000:  return "ISO32000";
		case XSDK_SENSITIVITY_ISO40000:  return "ISO40000";
		case XSDK_SENSITIVITY_ISO51200:  return "ISO51200";
		case XSDK_SENSITIVITY_ISO64000:  return "ISO64000";
		case XSDK_SENSITIVITY_ISO80000:  return "ISO80000";
		case XSDK_SENSITIVITY_ISO102400: return "ISO102400";
		case XSDK_SENSITIVITY_AUTO_1:    return "AUTO_1";
		case XSDK_SENSITIVITY_AUTO_2:    return "AUTO_2";
		case XSDK_SENSITIVITY_AUTO_3:    return "AUTO_3";
		case XSDK_SENSITIVITY_AUTO_4:    return "AUTO_4";
		case XSDK_SENSITIVITY_AUTO:      return "AUTO";
		case XSDK_SENSITIVITY_AUTO400:   return "AUTO400";
		case XSDK_SENSITIVITY_AUTO800:   return "AUTO800";
		case XSDK_SENSITIVITY_AUTO1600:  return "AUTO1600";
		case XSDK_SENSITIVITY_AUTO3200:  return "AUTO3200";
		case XSDK_SENSITIVITY_AUTO6400:  return "AUTO6400";
		case 0:                          return "";
		default:
			char code[11] = {0};
			std::sprintf(code, "0x%08lx", num);
			return code;
	}
}

inline std::string apiCodeToString(long num)
{
	switch (num)
	{
		case API_CODE_Init:           return "API_CODE_Init";
		case API_CODE_Exit:           return "API_CODE_Exit";
		case API_CODE_Detect:         return "API_CODE_Detect";
		case API_CODE_Append:         return "API_CODE_Append";
		case API_CODE_Close:          return "API_CODE_Close";
		case API_CODE_OpenEx:         return "API_CODE_OpenEx";
		case API_CODE_GetErrorNumber: return "API_CODE_GetErrorNumber";
		case API_CODE_GetDeviceInfo:  return "API_CODE_GetDeviceInfo";
		case API_CODE_GetSensitivity: return "API_CODE_GetSensitivity";
		default:
			char code[7] = {0};
			std::sprintf(code, "0x%04lx", num);
			return code;
	}
}

inline std::string errCodeToString(long num)
{
	switch (num)
	{
		case XSDK_ERRCODE_NOERR:                  return "XSDK_ERRCODE_NOERR";
		case XSDK_ERRCODE_SEQUENCE:               return "XSDK_ERRCODE_SEQUENCE";
		case XSDK_ERRCODE_PARAM:                  return "XSDK_ERRCODE_PARAM";
		case XSDK_ERRCODE_INVALID_CAMERA:         return "XSDK_ERRCODE_INVALID_CAMERA";
		case XSDK_ERRCODE_LOADLIB:                return "XSDK_ERRCODE_LOADLIB";
		case XSDK_ERRCODE_UNSUPPORTED:            return "XSDK_ERRCODE_UNSUPPORTED";
		case XSDK_ERRCODE_BUSY:                   return "XSDK_ERRCODE_BUSY";
		case XSDK_ERRCODE_AF_TIMEOUT:             return "XSDK_ERRCODE_AF_TIMEOUT";
		case XSDK_ERRCODE_SHOOT_ERROR:            return "XSDK_ERRCODE_SHOOT_ERROR";
		case XSDK_ERRCODE_FRAME_FULL:             return "XSDK_ERRCODE_FRAME_FULL";
		case XSDK_ERRCODE_STANDBY:                return "XSDK_ERRCODE_STANDBY";
		case XSDK_ERRCODE_NODRIVER:               return "XSDK_ERRCODE_NODRIVER";
		case XSDK_ERRCODE_NO_MODEL_MODULE:        return "XSDK_ERRCODE_NO_MODEL_MODULE";
		case XSDK_ERRCODE_API_NOTFOUND:           return "XSDK_ERRCODE_API_NOTFOUND";
		case XSDK_ERRCODE_API_MISMATCH:           return "XSDK_ERRCODE_API_MISMATCH";
		case XSDK_ERRCODE_INVALID_USBMODE:        return "XSDK_ERRCODE_INVALID_USBMODE";
		case XSDK_ERRCODE_FORCEMODE_BUSY:         return "XSDK_ERRCODE_FORCEMODE_BUSY";
		case XSDK_ERRCODE_RUNNING_OTHER_FUNCTION: return "XSDK_ERRCODE_RUNNING_OTHER_FUNCTION";
		case XSDK_ERRCODE_COMMUNICATION:          return "XSDK_ERRCODE_COMMUNICATION";
		case XSDK_ERRCODE_TIMEOUT:                return "XSDK_ERRCODE_TIMEOUT";
		case XSDK_ERRCODE_COMBINATION:            return "XSDK_ERRCODE_COMBINATION";
		case XSDK_ERRCODE_WRITEERROR:             return "XSDK_ERRCODE_WRITEERROR";
		case XSDK_ERRCODE_CARDFULL:               return "XSDK_ERRCODE_CARDFULL";
		case XSDK_ERRCODE_HARDWARE:               return "XSDK_ERRCODE_HARDWARE";
		case XSDK_ERRCODE_INTERNAL:               return "XSDK_ERRCODE_INTERNAL";
		case XSDK_ERRCODE_MEMFULL:                return "XSDK_ERRCODE_MEMFULL";
		case XSDK_ERRCODE_UNKNOWN:                return "XSDK_ERRCODE_UNKNOWN";
		default:
			char code[11] = {0};
			std::sprintf(code, "0x%08lx", num);
			return code;
	}
}


class CCameraControl {
public:
	CCameraControl();
	~CCameraControl();
	bool LoadLibraty();
	long Init();
	long Exit();
	long Detect(long iInterface, LPSTR pInterface, LPSTR pDeviceName, long* pCount);
	long Append(long iInterface, LPSTR pInterface, LPSTR pDeviceName, long* pCount, XSDK_CameraList* pCameraList);
	long Open(LPSTR pDevice, XSDK_HANDLE* phCamera, long* plCameraMode, void* pOption);
	long Close(XSDK_HANDLE hCamera);
	long GetDeviceInfo(XSDK_HANDLE hCamera, XSDK_DeviceInformation* pDevInfo);
	long GetSensitivity(XSDK_HANDLE hCamera, long* pSensitivity);
	long ReadImageInfo(XSDK_HANDLE hCamera, XSDK_ImageInformation* imgInfo);
	long ReadImage(XSDK_HANDLE hCamera, unsigned char* pBuf, unsigned long lDataSize);
	long SetPriorityMode(XSDK_HANDLE hCamera, long lmode);

	long m_apiCode;
	long m_errCode;

private:
	CFujiSDK* m_pFujiSDK;
	pthread_mutex_t m_cameraControlExclusion;

};

